/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.ChartLabel;
import chart.ChartPropertyValues;
import chart.data.ChartDataFilter;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChartRenderTools {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int NONE = 4;
    public static final int margine = 0;
    public static String platformKey = "CHARTPLATFORM";
    public static String paperKey = "CHARTCOORDINATEPAPER";
    public static String legendKey = "CHARTLEGEND";
    public static String labelKey = "CHARTLABEL";
    public static String CategoryKey = "CATEGORIES";
    public static String SeriesKey = "SERIES";
    public static String ValueKey = "VALUES";
    public static final String DELIM = "\u0007";
    private static final String QOIV = "" + (char)("\u0007".charAt(0) + '\u0001');

    public static Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext, Font font) {
        if (string == null || string.length() <= 0) {
            return new Rectangle2D.Float();
        }
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), Math.ceil(rectangle2D.getWidth()), lineMetrics.getHeight());
        return rectangle2D;
    }

    public static Rectangle2D getStringBounds(String string, Font font) {
        if (string == null || string.length() == 0) {
            return new Rectangle2D.Float();
        }
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return font.getStringBounds(string, fontRenderContext);
    }

    public static Rectangle cutRectangle(Rectangle rectangle, Rectangle rectangle2, int n) {
        Rectangle rectangle3 = new Rectangle();
        switch (n) {
            case 0: {
                rectangle3.x = rectangle.x + 0;
                rectangle3.y = rectangle.y + rectangle2.height + 0;
                rectangle3.width = rectangle.width - 0;
                rectangle3.height = rectangle.height - rectangle2.height - 0;
                break;
            }
            case 2: {
                rectangle3.x = rectangle.x + 0;
                rectangle3.y = rectangle.y + 0;
                rectangle3.width = rectangle.width - 0;
                rectangle3.height = rectangle.height - rectangle2.height - 0;
                break;
            }
            case 3: {
                rectangle3.x = rectangle2.x + rectangle2.width + 0;
                rectangle3.y = rectangle.y + 0;
                rectangle3.width = rectangle.width - 0 - rectangle2.width;
                rectangle3.height = rectangle.height - 0;
                break;
            }
            case 1: {
                rectangle3.x = rectangle.x + 0;
                rectangle3.y = rectangle.y + 0;
                rectangle3.width = rectangle.width - rectangle2.width - 0;
                rectangle3.height = rectangle.height - 0;
            }
        }
        return rectangle3;
    }

    public static Vector getCoordFromPath(GeneralPath generalPath) {
        Vector<Point> vector = new Vector<Point>();
        float[] fArray2 = new float[6];
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray2);
            int n = (int)fArray2[0];
            int n2 = (int)fArray2[1];
            Point point = new Point();
            point.setLocation(n, n2);
            vector.add(point);
            pathIterator.next();
        }
        return vector;
    }

    public static Rectangle calculateTitleAutoPos(Rectangle rectangle, ChartLabel chartLabel, int n) {
        String string = chartLabel.getText();
        if (string == null || string.length() == 0) {
            string = "Title";
        }
        Rectangle2D rectangle2D = ChartRenderTools.getStringBounds(string, chartLabel.getChartTextStyle().getFont());
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        int n4 = 0;
        int n5 = 0;
        if (chartLabel.getIcon() != null && !chartLabel.getIcon().isNoIcon()) {
            n4 = chartLabel.getIconHeight();
            n5 = chartLabel.getIconWidth();
            int n6 = (int)chartLabel.getIconTextGap();
            switch (chartLabel.getIconAlignment()) {
                case 6: 
                case 7: {
                    n2 = n2 > n4 ? n2 : n4;
                    n3 += n6 + n5;
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 5: {
                    n2 += n6 + n4;
                    n3 += n5;
                    break;
                }
                case 1: 
                case 4: {
                    n3 = n3 > n5 ? n3 : n5;
                    n2 += n4;
                    break;
                }
            }
        }
        Rectangle rectangle2 = new Rectangle();
        switch (n) {
            case 4: {
                break;
            }
            case 3: {
                rectangle2.width = n3 + 6;
                rectangle2.height = n2 + 12;
                rectangle2.x = rectangle.x + 0;
                rectangle2.y = rectangle.y + (rectangle.height - rectangle2.width) / 2;
                break;
            }
            case 0: {
                rectangle2.width = n2 + 6;
                rectangle2.height = n3 + 6;
                rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                rectangle2.y = rectangle.y + 0;
                break;
            }
            case 2: {
                rectangle2.width = n2 + 12;
                rectangle2.height = n3 + 6;
                rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height - 0;
                break;
            }
            case 1: {
                rectangle2.width = n3 + 6;
                rectangle2.height = n2 + 12;
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 0;
                rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            }
        }
        return rectangle2;
    }

    public static ChartDataFilter mapChartDataFilter(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        ChartDataFilter chartDataFilter = null;
        if (string != null && n > 0) {
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector = new Vector<Object[]>();
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string2.substring(0, 1))), string2.substring(1)};
                vector.add(objectArray);
                ++n2;
            }
            chartDataFilter.setFilters(vector);
        }
        return chartDataFilter;
    }

    public static ChartDataFilter[] mapChartDataFilters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, QOIV);
        int n = stringTokenizer.countTokens();
        ChartDataFilter[] chartDataFilterArray = null;
        if (string != null && n > 0) {
            chartDataFilterArray = new ChartDataFilter[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                chartDataFilterArray[n2] = ChartRenderTools.mapChartDataFilter(string2);
                ++n2;
            }
        }
        return chartDataFilterArray;
    }

    public static String mapFilterString(ChartDataFilter chartDataFilter) {
        String string = "";
        if (chartDataFilter != null) {
            int n = 0;
            while (n < chartDataFilter.getFilters().size()) {
                if (n != 0) {
                    string = string + DELIM;
                }
                Object[] objectArray = (Object[])chartDataFilter.getFilters().get(n);
                string = string + objectArray[0].toString() + objectArray[1].toString();
                ++n;
            }
        }
        return string;
    }

    public static String mapChartDataFilterList(ChartDataFilter[] chartDataFilterArray) {
        String string = "";
        if (chartDataFilterArray != null) {
            int n = 0;
            while (n < chartDataFilterArray.length) {
                if (n != 0) {
                    string = string + QOIV;
                }
                ChartRenderTools.mapFilterString(chartDataFilterArray[n]);
                ++n;
            }
        }
        return string;
    }

    public static ChartFillPattern mapFillPattern(String string) {
        ChartFillPattern chartFillPattern = null;
        switch (string.charAt(0)) {
            case 'C': 
            case 'c': {
                String string2 = string.substring(1, 9);
                Color color = !string2.equals("No_Color") ? ChartRenderTools.mapStringToColor(string2) : null;
                chartFillPattern = new ChartColorPattern(color);
                String string3 = string.substring(9);
                float f = (float)Integer.valueOf(string3).intValue() / 100.0f;
                chartFillPattern.setAlpha(f);
                break;
            }
            case 'T': 
            case 't': {
                String string4 = string.charAt(1) != '0' ? string.substring(1, 3) : string.substring(1, 3);
                int n = Integer.valueOf(string4);
                String string5 = string.substring(3, 11);
                Color color = !string5.equals("No_Color") ? ChartRenderTools.mapStringToColor(string5) : null;
                String string6 = string.substring(11, 19);
                Color color2 = !string6.equals("No_Color") ? ChartRenderTools.mapStringToColor(string6) : null;
                chartFillPattern = new ChartTexturePattern(n, new ChartColorPattern(color), new ChartColorPattern(color2));
                String string7 = string.substring(19);
                float f = (float)Integer.valueOf(string7).intValue() / 100.0f;
                ((ChartTexturePattern)chartFillPattern).setAlpha(f);
                break;
            }
            case 'G': 
            case 'g': {
                String string8 = string.substring(1, 3);
                int n = Integer.valueOf(string8);
                String string9 = string.substring(3, 11);
                Color color = !string9.equals("No_Color") ? ChartRenderTools.mapStringToColor(string9) : null;
                String string10 = string.substring(11, 19);
                Color color3 = !string10.equals("No_Color") ? ChartRenderTools.mapStringToColor(string10) : null;
                String string11 = string.substring(19, 22);
                float f = (float)Integer.valueOf(string11).intValue() / 100.0f;
                String string12 = string.substring(22, 25);
                float f2 = 1.0f - (float)Integer.valueOf(string12).intValue() / 100.0f;
                String string13 = string.substring(25, 28);
                float f3 = (float)Integer.valueOf(string13).intValue() / 100.0f;
                String string14 = string.substring(28, 31);
                float f4 = 1.0f - (float)Integer.valueOf(string14).intValue() / 100.0f;
                String string15 = string.substring(31);
                chartFillPattern = new ChartGradientPattern(n);
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(color));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(color3));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float(f, f2));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float(f3, f4));
                float f5 = (float)Integer.valueOf(string15).intValue() / 100.0f;
                ((ChartGradientPattern)chartFillPattern).setAlpha(f5);
                break;
            }
            case 'N': 
            case 'n': {
                chartFillPattern = null;
            }
        }
        return chartFillPattern;
    }

    public static ChartFillPattern[] mapPatterns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        ChartFillPattern[] chartFillPatternArray = null;
        if (string != null && n > 0) {
            chartFillPatternArray = new ChartFillPattern[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                chartFillPatternArray[n2] = ChartRenderTools.mapFillPattern(string2);
                ++n2;
            }
        }
        return chartFillPatternArray;
    }

    public static String mapPatternString(ChartFillPattern chartFillPattern) {
        String string;
        Object object;
        String string2 = "";
        if (chartFillPattern == null) {
            string2 = string2 + "n";
        } else if (chartFillPattern instanceof ChartColorPattern) {
            string2 = string2 + "c";
            Color color = ((ChartColorPattern)chartFillPattern).getColor();
            string2 = color != null ? string2 + ChartRenderTools.mapColorToString(color) : string2 + "No_Color";
        } else if (chartFillPattern instanceof ChartTexturePattern) {
            string2 = string2 + "t";
            object = (ChartTexturePattern)chartFillPattern;
            int n = ((ChartTexturePattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf(new Integer(n));
            Color color = ((ChartTexturePattern)object).getForeground().getColor();
            String string3 = color != null ? ChartRenderTools.mapColorToString(color) : "No_Color";
            Color color2 = ((ChartTexturePattern)object).getBackground().getColor();
            String string4 = color2 != null ? ChartRenderTools.mapColorToString(color2) : "No_Color";
            string2 = string2 + string + string3 + string4;
        } else if (chartFillPattern instanceof ChartGradientPattern) {
            string2 = string2 + "g";
            object = (ChartGradientPattern)chartFillPattern;
            int n = ((ChartGradientPattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf(new Integer(n));
            Color color = ((ChartGradientPattern)object).getStartColor().getColor();
            String string5 = color != null ? ChartRenderTools.mapColorToString(color) : "No_Color";
            Color color3 = ((ChartGradientPattern)object).getEndColor().getColor();
            String string6 = color3 != null ? ChartRenderTools.mapColorToString(color3) : "No_Color";
            int n2 = (int)(((ChartGradientPattern)object).getStartPoint().getX() * 100.0);
            int n3 = (int)((1.0 - ((ChartGradientPattern)object).getStartPoint().getY()) * 100.0);
            int n4 = (int)(((ChartGradientPattern)object).getEndPoint().getX() * 100.0);
            int n5 = (int)((1.0 - ((ChartGradientPattern)object).getEndPoint().getY()) * 100.0);
            String string7 = "";
            if (n2 < 10) {
                string7 = "00";
            } else if (n2 < 100) {
                string7 = "0";
            }
            string7 = string7 + String.valueOf(new Integer(n2));
            String string8 = "";
            if (n4 < 10) {
                string8 = "00";
            } else if (n4 < 100) {
                string8 = "0";
            }
            string8 = string8 + String.valueOf(new Integer(n4));
            String string9 = "";
            if (n3 < 10) {
                string9 = "00";
            } else if (n3 < 100) {
                string9 = "0";
            }
            string9 = string9 + String.valueOf(new Integer(n3));
            String string10 = "";
            if (n5 < 10) {
                string10 = "00";
            } else if (n5 < 100) {
                string10 = "0";
            }
            string10 = string10 + String.valueOf(new Integer(n5));
            string2 = string2 + string + string5 + string6 + string7 + string9 + string8 + string10;
        }
        if (chartFillPattern != null) {
            object = "";
            int n = (int)(chartFillPattern.getAlpha() * 100.0f);
            if (n < 10) {
                object = "00";
            } else if (n < 100) {
                object = "0";
            }
            object = (String)object + String.valueOf(new Integer(n));
            string2 = string2 + (String)object;
        }
        return string2;
    }

    public static String mapPatternList(ChartFillPattern[] chartFillPatternArray) {
        String string = "";
        if (chartFillPatternArray != null) {
            int n = 0;
            while (n < chartFillPatternArray.length) {
                if (n != 0) {
                    string = string + DELIM;
                }
                ChartRenderTools.mapPatternString(chartFillPatternArray[n]);
                ++n;
            }
        }
        return string;
    }

    public static String mapColorToString(Color color) {
        return String.valueOf(color.getRGB());
    }

    public static Color mapStringToColor(String string) {
        String string2 = string;
        if (string.length() > 2 && string.substring(0, 2).equals("0x")) {
            return new Color(Integer.parseInt(string.substring(2), 16));
        }
        return new Color(Integer.parseInt(string));
    }

    public static void setFontSpecialEffect1(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleEmbossed();
                break;
            }
            case 2: {
                chartTextStyle.toggleEngraved();
                break;
            }
            case 3: {
                chartTextStyle.toggleShadowed();
                break;
            }
            case 4: {
                chartTextStyle.toggleOutlined();
                break;
            }
            case 5: {
                chartTextStyle.toggleShadowed();
                chartTextStyle.toggleOutlined();
            }
        }
    }

    public static void setFontSpecialEffect2(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleSuperscript();
                break;
            }
            case 2: {
                chartTextStyle.toggleSubscript();
            }
        }
    }

    public static float[] mapRotationMatrix(String string) {
        float[] fArray2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        if (string != null && n > 0) {
            fArray2 = new float[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                fArray2[n2] = Float.parseFloat(string2);
                ++n2;
            }
        }
        return fArray2;
    }

    public static float[][] formatMinorTickMark(float[][] fArray2, float[][] fArray3, float f) {
        float[][] fArray4;
        if (fArray2 == null || fArray3 == null) {
            return null;
        }
        int n = fArray2.length;
        boolean bl = false;
        boolean bl2 = false;
        if (!bl && !bl2) {
            fArray4 = new float[n - 1][2];
        } else if (bl && bl2) {
            fArray4 = new float[n + 1][2];
            fArray4[n - 1] = ChartRenderTools.CategoryKey(fArray2[0], fArray3[0], f);
            fArray4[n] = ChartRenderTools.CategoryKey(fArray2[n - 1], fArray3[1], f);
        } else {
            fArray4 = new float[n][2];
            fArray4[n - 1] = bl ? ChartRenderTools.CategoryKey(fArray2[0], fArray3[0], f) : ChartRenderTools.CategoryKey(fArray2[n - 1], fArray3[1], f);
        }
        int n2 = 0;
        while (n2 < n - 1) {
            fArray4[n2][0] = (fArray2[n2][0] + fArray2[n2 + 1][0]) / 2.0f;
            fArray4[n2][1] = (fArray2[n2][1] + fArray2[n2 + 1][1]) / 2.0f;
            ++n2;
        }
        return fArray4;
    }

    private static float[] CategoryKey(float[] fArray2, float[] fArray3, float f) {
        float[] fArray4 = new float[2];
        float f2 = (float)Math.sqrt(Math.pow(fArray2[1] - fArray3[1], 2.0) + Math.pow(fArray2[0] - fArray3[0], 2.0));
        float f3 = (f2 - f) / f2;
        fArray4[0] = fArray2[0] + f3 * (fArray3[0] - fArray2[0]);
        fArray4[1] = fArray2[1] + f3 * (fArray3[1] - fArray2[1]);
        return fArray4;
    }

    public static ChartDataFilter constructPercentFilter(ChartDataFilter chartDataFilter, boolean bl) {
        if (chartDataFilter == null || chartDataFilter.getFilters().size() == 0) {
            chartDataFilter = new ChartDataFilter();
            if (bl) {
                ChartPropertyValues.addFilter(chartDataFilter, 1, "0.00%");
            } else {
                ChartPropertyValues.addFilter(chartDataFilter, 1, "0%");
            }
        } else {
            chartDataFilter = new ChartDataFilter((Vector)((Vector)chartDataFilter.getFilters()).clone());
            List list = chartDataFilter.getFilters();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object[] objectArray = (Object[])list.get(n2);
                if ((Integer)objectArray[0] == 1) {
                    Object[] objectArray2 = new Object[]{new Integer(1), bl ? "0.00%" : "0%"};
                    list.set(n2, objectArray2);
                }
                ++n2;
            }
            chartDataFilter.init();
        }
        return chartDataFilter;
    }
}

