/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class UUID
implements Serializable {
    private static final long serialVersionUID = -4856846361193249489L;
    private final long mostSigBits;
    private final long leastSigBits;
    private transient int QOIV = -1;
    private transient int append = -1;
    private volatile transient long decode = -1L;
    private transient int defaultReadObject = -1;
    private transient long digest = -1L;
    private transient int getInstance = -1;
    private static volatile SecureRandom longValue = null;

    private UUID(byte[] byArray) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < 8) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
            ++n;
        }
        int n2 = 8;
        while (n2 < 16) {
            l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
            ++n2;
        }
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public UUID(long l, long l2) {
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public static UUID randomUUID() {
        SecureRandom secureRandom = longValue;
        if (secureRandom == null) {
            longValue = secureRandom = new SecureRandom();
        }
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return new UUID(byArray);
    }

    public static UUID nameUUIDFromBytes(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 not supported");
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        byArray2[6] = (byte)(byArray2[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return new UUID(byArray2);
    }

    public static UUID fromString(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + string);
        }
        int n = 0;
        while (n < 5) {
            stringArray[n] = "0x" + stringArray[n];
            ++n;
        }
        long l = Long.decode(stringArray[0]);
        l <<= 16;
        l |= Long.decode(stringArray[1]).longValue();
        l <<= 16;
        long l2 = Long.decode(stringArray[3]);
        l2 <<= 48;
        return new UUID(l |= Long.decode(stringArray[2]).longValue(), l2 |= Long.decode(stringArray[4]).longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        if (this.QOIV < 0) {
            this.QOIV = (int)(this.mostSigBits >> 12 & 0xFL);
        }
        return this.QOIV;
    }

    public int variant() {
        if (this.append < 0) {
            this.append = this.leastSigBits >>> 63 == 0L ? 0 : (this.leastSigBits >>> 62 == 2L ? 2 : (int)(this.leastSigBits >>> 61));
        }
        return this.append;
    }

    public long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        long l = this.decode;
        if (l < 0L) {
            l = (this.mostSigBits & 0xFFFL) << 48;
            l |= (this.mostSigBits >> 16 & 0xFFFFL) << 32;
            this.decode = l |= this.mostSigBits >>> 32;
        }
        return l;
    }

    public int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        if (this.defaultReadObject < 0) {
            this.defaultReadObject = (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
        }
        return this.defaultReadObject;
    }

    public long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        if (this.digest < 0L) {
            this.digest = this.leastSigBits & 0xFFFFFFFFFFFFL;
        }
        return this.digest;
    }

    public String toString() {
        return UUID.QOIV(this.mostSigBits >> 32, 8) + "-" + UUID.QOIV(this.mostSigBits >> 16, 4) + "-" + UUID.QOIV(this.mostSigBits, 4) + "-" + UUID.QOIV(this.leastSigBits >> 48, 4) + "-" + UUID.QOIV(this.leastSigBits, 12);
    }

    private static String QOIV(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }

    public int hashCode() {
        if (this.getInstance == -1) {
            this.getInstance = (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
        }
        return this.getInstance;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UUID)) {
            return false;
        }
        if (((UUID)object).variant() != this.variant()) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.mostSigBits == uUID.mostSigBits && this.leastSigBits == uUID.leastSigBits;
    }

    public int compareTo(UUID uUID) {
        return this.mostSigBits < uUID.mostSigBits ? -1 : (this.mostSigBits > uUID.mostSigBits ? 1 : (this.leastSigBits < uUID.leastSigBits ? -1 : (this.leastSigBits > uUID.leastSigBits ? 1 : 0)));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.QOIV = -1;
        this.append = -1;
        this.decode = -1L;
        this.defaultReadObject = -1;
        this.digest = -1L;
        this.getInstance = -1;
    }
}

