/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.join.core;

import com.jinfonet.dataservice.relational.localrelation.join.core.FullOuterJoiner;
import com.jinfonet.dataservice.relational.localrelation.join.core.LeftOuterJoiner;
import com.jinfonet.dataservice.relational.localrelation.join.core.RightOuterJoiner;
import com.jinfonet.dataservice.relational.localrelation.join.core.ThetaJoiner;
import com.jinfonet.dataservice.relational.localrelation.join.data.DataTyper;
import com.jinfonet.dataservice.relational.localrelation.util.LinearCache;
import com.jinfonet.dataservice.relational.localrelation.util.cont.IndexLocalRelation;
import com.jinfonet.dataservice.relational.localrelation.util.cont.LocalRelationData;
import jet.dataengine.api.DSException;

public abstract class Joiner {
    protected static final String errID = "LR040";
    private int QOIV;
    protected LinearCache cache;
    protected DataTyper typer;

    protected Joiner(int n, int n2) {
        this.typer = DataTyper.getInstance(n);
        this.QOIV = n2;
    }

    public static Joiner getInstance(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                return new ThetaJoiner(n, n3);
            }
            case 1: {
                return new LeftOuterJoiner(n, n3);
            }
            case 2: {
                return new RightOuterJoiner(n, n3);
            }
            case 3: {
                return new FullOuterJoiner(n, n3);
            }
        }
        return null;
    }

    public abstract void doJoin(IndexLocalRelation var1, int var2, IndexLocalRelation var3, LocalRelationData var4) throws DSException;

    protected void copyPosition(IndexLocalRelation indexLocalRelation, LocalRelationData localRelationData, long l) throws DSException {
    }

    protected LinearCache getAutoCache(int n) {
        if (n <= 1000) {
            return new LinearCache(100);
        }
        if (n <= 10000) {
            return new LinearCache(n / 10);
        }
        return new LinearCache(1000);
    }

    protected void treatNull(IndexLocalRelation indexLocalRelation, IndexLocalRelation indexLocalRelation2, LocalRelationData localRelationData, long l) throws DSException {
        long l2 = -1L;
        if (this.QOIV == 0) {
            while (indexLocalRelation2.findNull(this.typer.getDataType())) {
                l2 = indexLocalRelation2.getPosition();
                localRelationData.addPosition(l, indexLocalRelation, l2, indexLocalRelation2);
            }
        } else if (this.QOIV == 1) {
            // empty if block
        }
    }
}

