/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dom.css.impl;

import com.jinfonet.css.sac.impl.parser.JCSSDOMParser;
import com.jinfonet.dom.css.JCSSMediaRule;
import com.jinfonet.dom.css.JCSSRuleList;
import com.jinfonet.dom.css.JCSSStyleRule;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.dom.css.JMediaList;
import com.jinfonet.dom.css.impl.JCSSRuleListImpl;
import com.jinfonet.dom.css.impl.JCSSStyleSheetImpl;
import com.jinfonet.dom.css.impl.JDOMException;
import com.jinfonet.dom.css.impl.JLitConvertKit;
import com.jinfonet.dom.css.impl.JMediaListImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class JCSSMediaRuleImpl
implements JCSSMediaRule {
    private static final long serialVersionUID = 0x100100L;
    private CSSStyleSheet QOIV = null;
    private CSSRule append = null;
    private MediaList cvCSSRule = null;
    private CSSRuleList cvMediaList = null;

    public JCSSMediaRuleImpl(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, MediaList mediaList) {
        this.QOIV = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.append = JLitConvertKit.cvCSSRule(cSSRule);
        this.cvCSSRule = JLitConvertKit.cvMediaList(mediaList);
    }

    public JCSSMediaRuleImpl(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, String string) {
        this.QOIV = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.append = JLitConvertKit.cvCSSRule(cSSRule);
        this.cvCSSRule = new JMediaListImpl(string);
    }

    public JCSSMediaRuleImpl() {
    }

    public short getType() {
        return 4;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer("@media ");
        stringBuffer.append(this.getMedia().toString()).append(" {");
        int n = 0;
        while (n < this.getCssRules().getLength()) {
            CSSRule cSSRule = this.getCssRules().item(n);
            stringBuffer.append(cSSRule.getCssText()).append(" ");
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        if (this.QOIV != null && ((JCSSStyleSheet)this.QOIV).isReadOnly()) {
            throw new JDOMException(7, 2);
        }
        try {
            InputSource inputSource = new InputSource((Reader)new StringReader(string));
            JCSSDOMParser jCSSDOMParser = JCSSDOMParser.newInstance();
            CSSRule cSSRule = jCSSDOMParser.parseRule(inputSource);
            if (cSSRule == null || cSSRule.getType() != 4) {
                throw new JDOMException(13, 7);
            }
            this.cvCSSRule = ((JCSSMediaRuleImpl)cSSRule).cvCSSRule;
            this.cvMediaList = ((JCSSMediaRuleImpl)cSSRule).cvMediaList;
        }
        catch (CSSException cSSException) {
            throw new JDOMException(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new JDOMException(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this.QOIV;
    }

    public CSSRule getParentRule() {
        return this.append;
    }

    public MediaList getMedia() {
        return this.cvCSSRule;
    }

    public CSSRuleList getCssRules() {
        return this.cvMediaList;
    }

    public int insertRule(String string, int n) throws DOMException {
        if (this.QOIV != null && ((JCSSStyleSheet)this.QOIV).isReadOnly()) {
            throw new JDOMException(7, 2);
        }
        try {
            InputSource inputSource = new InputSource((Reader)new StringReader(string));
            JCSSDOMParser jCSSDOMParser = JCSSDOMParser.newInstance();
            jCSSDOMParser.setParentStyleSheet((JCSSStyleSheetImpl)this.QOIV);
            CSSRule cSSRule = jCSSDOMParser.parseRule(inputSource);
            ((JCSSRuleListImpl)this.getCssRules()).insert(cSSRule, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JDOMException(1, 1, arrayIndexOutOfBoundsException.getMessage());
        }
        catch (CSSException cSSException) {
            throw new JDOMException(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new JDOMException(12, 0, iOException.getMessage());
        }
        return n;
    }

    public void deleteRule(int n) throws DOMException {
        if (this.QOIV != null && ((JCSSStyleSheet)this.QOIV).isReadOnly()) {
            throw new JDOMException(7, 2);
        }
        try {
            ((JCSSRuleListImpl)this.getCssRules()).delete(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JDOMException(1, 1, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public String toString() {
        return this.getCssText();
    }

    public void setRuleList(CSSRuleList cSSRuleList) {
        this.cvMediaList = JLitConvertKit.cvRuleList(cSSRuleList);
        int n = 0;
        while (n < this.cvMediaList.getLength()) {
            CSSRule cSSRule = this.cvMediaList.item(n);
            switch (cSSRule.getType()) {
                case 1: {
                    ((JCSSStyleRule)cSSRule).resetParent(this.QOIV, this.append);
                    break;
                }
                default: {
                    throw new JDOMException(12, 0);
                }
            }
            ++n;
        }
    }

    public void resetParent(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule) {
        this.QOIV = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.append = JLitConvertKit.cvCSSRule(cSSRule);
    }

    public CSSMediaRule duplate() {
        JCSSMediaRuleImpl jCSSMediaRuleImpl = new JCSSMediaRuleImpl(this.QOIV, this.append, ((JMediaList)this.cvCSSRule).duplate());
        ((JCSSMediaRule)jCSSMediaRuleImpl).setRuleList(((JCSSRuleList)this.cvMediaList).duplate());
        return jCSSMediaRuleImpl;
    }
}

