/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDouble;
import jet.connect.DbValue;

public class DbDoubleColumnBuffer
extends DbColumnBuffer {
    double[] QOIV;
    boolean clearMem = false;

    public double[] getBuffer() {
        return this.QOIV;
    }

    public DbDoubleColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new double[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = ((DbDouble)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbDouble)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeDouble(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readDouble();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

