/*
 * Decompiled with CFR 0.152.
 */
package jet.crosstab;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Timestamp;
import java.math.BigDecimal;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.cursor.DimensionCursor;
import jet.reportset.DataSet;
import jet.rptengine.JReportEngine;
import jet.util.DbValueable;

public class CTCubeInput {
    public static DbValueable[] makeDbValue_DimCursor(DimensionCursor[] dimensionCursorArray, JReportEngine jReportEngine, DataSet dataSet) {
        try {
            int n = dimensionCursorArray.length;
            DbValueable[] dbValueableArray = new DbValueable[n];
            int n2 = 0;
            while (n2 < n) {
                DbColDesc dbColDesc = new DbColDesc(jReportEngine.getMappingNameByDimName(dataSet, dimensionCursorArray[n2].getMetaData().getColumnName(1)), dimensionCursorArray[n2].getMetaData().getColumnType(1), dimensionCursorArray[n2].getMetaData().getScale(1), dimensionCursorArray[n2].getMetaData().getPrecision(1), dimensionCursorArray[n2].getMetaData().isNullable(1));
                dbColDesc.setEncodingName("8859_1");
                dbValueableArray[n2] = DbValue.makeDbValue(dbColDesc);
                ++n2;
            }
            return dbValueableArray;
        }
        catch (DSException dSException) {
            dSException.printStackTrace();
            return null;
        }
    }

    public static DbValueable setDbValueOfDim(DbValueable dbValueable, DimensionCursor dimensionCursor) {
        DbValueable dbValueable2 = (DbValueable)dbValueable.clone();
        try {
            int n = dimensionCursor.getMetaData().getColumnType(1);
            switch (n) {
                case 5: {
                    ((DbSmallInt)dbValueable2).set(dimensionCursor.getShort(1));
                    break;
                }
                case -6: {
                    ((DbTinyInt)dbValueable2).set(dimensionCursor.getByte(1));
                    break;
                }
                case 4: {
                    ((DbInteger)dbValueable2).set(dimensionCursor.getInt(1));
                    break;
                }
                case -5: {
                    ((DbBigInt)dbValueable2).set(dimensionCursor.getLong(1));
                    break;
                }
                case 6: 
                case 7: {
                    ((DbReal)dbValueable2).set(dimensionCursor.getFloat(1));
                    break;
                }
                case 2: 
                case 3: {
                    ((DbDecimal)dbValueable2).set((BigDecimal)dimensionCursor.getObject(1));
                    break;
                }
                case 8: {
                    ((DbDouble)dbValueable2).set(dimensionCursor.getDouble(1));
                    break;
                }
                case -7: {
                    ((DbBit)dbValueable2).set(dimensionCursor.getBoolean(1));
                    break;
                }
                case 91: {
                    ((DbDate)dbValueable2).set(((Date)dimensionCursor.getObject(1)).getTime());
                    break;
                }
                case 92: {
                    ((DbTime)dbValueable2).set(((Date)dimensionCursor.getObject(1)).getTime());
                    break;
                }
                case 93: {
                    ((DbTimestamp)dbValueable2).set(((Timestamp)dimensionCursor.getObject(1)).getTime());
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    ((DbChar)dbValueable2).set((String)dimensionCursor.getObject(1));
                    break;
                }
                default: {
                    throw new Error("unknow sql type : " + dimensionCursor.getMetaData().getColumnType(1) + " of the column " + dimensionCursor.getMetaData().getColumnName(1));
                }
            }
        }
        catch (DSException dSException) {
            dSException.printStackTrace();
        }
        return dbValueable2;
    }

    public static DbValueable makeFakeDbValueOfDim(int n) {
        DbValue dbValue = null;
        DbColDesc dbColDesc = new DbColDesc(null, n, 0, 0, 2);
        switch (n) {
            case 5: {
                dbValue = new DbSmallInt(dbColDesc);
                break;
            }
            case -6: {
                dbValue = new DbTinyInt(dbColDesc);
                break;
            }
            case 4: {
                dbValue = new DbInteger(dbColDesc);
                break;
            }
            case -5: {
                dbValue = new DbBigInt(dbColDesc);
                break;
            }
            case 6: 
            case 7: {
                dbValue = new DbReal(dbColDesc);
                break;
            }
            case 2: 
            case 3: {
                dbValue = new DbDecimal(dbColDesc);
                break;
            }
            case 8: {
                dbValue = new DbDouble(dbColDesc);
                break;
            }
            case -7: {
                dbValue = new DbBit(dbColDesc);
                break;
            }
            case 91: {
                dbValue = new DbDate(dbColDesc);
                break;
            }
            case 92: {
                dbValue = new DbTime(dbColDesc);
                break;
            }
            case 93: {
                dbValue = new DbTimestamp(dbColDesc);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                dbValue = new DbChar(dbColDesc);
                break;
            }
            default: {
                throw new Error("unknow sql type : ");
            }
        }
        return dbValue;
    }
}

