/*
 * Decompiled with CFR 0.152.
 */
package jet.css;

import com.jinfonet.dom.css.JCSSMediaRule;
import com.jinfonet.dom.css.JCSSPageRule;
import com.jinfonet.dom.css.JCSSProperty;
import com.jinfonet.dom.css.JCSSStyleRule;
import com.jinfonet.util.JRLog;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.css.CSSMemRule;
import jet.css.CSSRuleKey;
import jet.css.CssStyleSheetManager;
import jet.css.JCSSException;
import jet.log.JRLogger;
import jet.naming.PropertyNameConstant;
import jet.report.JRObjectTemplate;
import jet.report.JetRptObject;
import jet.report.UpgradeName;
import jet.report.mode.JetRptMode;
import jet.util.MiscTools;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.stylesheets.MediaList;

public class CSSHandler {
    public static final int MEDIA_DEFAULT = 0;
    public static final int MEDIA_SCREEN = 1;
    public static final int MEDIA_PRINT = 2;
    public static final int MEDIA_TV = 3;
    public static final int MEDIA_RADIO = 4;
    public static final int MEDIA_AURAL = 5;
    private static final String[] QOIV = new String[]{"default", "screen", "print", "tv", "radio", "aural"};
    private int _mapStringToColor = 0;
    private int add = 0;
    private int append = 0;
    private Hashtable clone = new Hashtable();
    private Hashtable compareTo = new Hashtable();
    private Hashtable contains = new Hashtable();
    private Hashtable containsKey = new Hashtable();
    private Hashtable duplate = new Hashtable();
    private Hashtable elementAt = new Hashtable();

    public CSSHandler(String string) throws JCSSException {
        CSSStyleSheet cSSStyleSheet = CssStyleSheetManager.getCSSStyleSheetManager().getCSSStyleSheet(string);
        CSSRuleList cSSRuleList = null;
        if (cSSStyleSheet != null) {
            cSSRuleList = cSSStyleSheet.getCssRules();
            int n = 0;
            while (n < cSSRuleList.getLength()) {
                CSSRule cSSRule = cSSRuleList.item(n);
                this._mapStringToColor(cSSRule, null);
                JRLog.trace(4, cSSRule.toString());
                ++n;
            }
        }
    }

    public CSSHandler(CSSRuleList cSSRuleList) {
        int n = 0;
        while (n < cSSRuleList.getLength()) {
            CSSRule cSSRule = cSSRuleList.item(n);
            this._mapStringToColor(cSSRule, null);
            ++n;
        }
    }

    private int QOIV(String string) {
        if (string == null) {
            return 0;
        }
        int n = 1;
        while (n < QOIV.length) {
            if (QOIV[n].compareTo(string) == 0) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void _mapStringToColor(CSSRule cSSRule, String string) {
        switch (cSSRule.getType()) {
            case 1: {
                JCSSStyleRule jCSSStyleRule = (JCSSStyleRule)cSSRule;
                SelectorList selectorList = jCSSStyleRule.getSelectors();
                int n = selectorList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    int n3;
                    Vector vector;
                    Selector selector = selectorList.item(n2);
                    CSSMemRule cSSMemRule = new CSSMemRule();
                    this._mapStringToColor = 0;
                    this.add = 0;
                    this.append = 0;
                    cSSMemRule.setKey(this.getAncestor(selector, new CSSRuleKey()));
                    Hashtable hashtable = jCSSStyleRule.getDeclarations();
                    String string2 = cSSMemRule.getKey().I();
                    if (string2.equals("*")) {
                        vector = this.compareTo(string);
                        n3 = 0;
                        while (n3 < vector.size()) {
                            object = (String)vector.elementAt(n3);
                            Vector vector2 = this.containsKey(string, (String)object, cSSMemRule.getKey());
                            int n4 = 0;
                            while (n4 < vector2.size()) {
                                CSSMemRule cSSMemRule2 = (CSSMemRule)vector2.elementAt(n4);
                                this.add(hashtable, cSSMemRule2);
                                if (!cSSMemRule2.isAddUniDec()) {
                                    cSSMemRule2.setAddUniDec(true);
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                        this.append(hashtable, cSSMemRule, string);
                    } else {
                        vector = this.clone(string, "*");
                        n3 = 0;
                        while (n3 < vector.size()) {
                            object = (CSSMemRule)vector.elementAt(n3);
                            if (this.endsWith(cSSMemRule.getKey(), ((CSSMemRule)object).getKey())) {
                                this.add(((CSSMemRule)object).getDecls(), cSSMemRule);
                                this.add(((CSSMemRule)object).getImportantDecls(), cSSMemRule);
                            }
                            ++n3;
                        }
                        cSSMemRule.setAddUniDec(true);
                        this.append(hashtable, cSSMemRule, string);
                    }
                    cSSMemRule.setPrioty(Integer.valueOf(String.valueOf(this._mapStringToColor) + String.valueOf(this.add) + String.valueOf(this.append)));
                    ++n2;
                }
                break;
            }
            case 4: {
                JCSSMediaRule jCSSMediaRule = (JCSSMediaRule)cSSRule;
                MediaList mediaList = jCSSMediaRule.getMedia();
                CSSRuleList cSSRuleList = jCSSMediaRule.getCssRules();
                int n = 0;
                while (n < cSSRuleList.getLength()) {
                    int n5 = 0;
                    while (n5 < mediaList.getLength()) {
                        this._mapStringToColor(cSSRuleList.item(n), mediaList.item(n5));
                        ++n5;
                    }
                    ++n;
                }
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                JCSSPageRule jCSSPageRule = (JCSSPageRule)cSSRule;
                CSSMemRule cSSMemRule = new CSSMemRule();
                CSSRuleKey cSSRuleKey = new CSSRuleKey();
                String string3 = "@page " + jCSSPageRule.getSelectorText();
                cSSRuleKey.I(string3);
                Vector vector = cSSRuleKey.getPseudos();
                if (vector == null) {
                    vector = new Vector();
                }
                cSSRuleKey.setPseudos(vector);
                cSSMemRule.setKey(cSSRuleKey);
                int n = 0;
                if (vector != null) {
                    n = vector.size();
                }
                cSSMemRule.setPrioty(n);
                Object var17_28 = null;
                CSSRule cSSRule2 = jCSSPageRule.getParentRule();
                if (cSSRule2 != null && cSSRule2.getType() == 4) {
                    JCSSMediaRule jCSSMediaRule = (JCSSMediaRule)cSSRule2;
                    MediaList mediaList = jCSSMediaRule.getMedia();
                    int n6 = 0;
                    while (n6 < mediaList.getLength()) {
                        this.append(jCSSPageRule.getDeclarations(), cSSMemRule, mediaList.item(n6));
                        ++n6;
                    }
                    break;
                }
                this.append(jCSSPageRule.getDeclarations(), cSSMemRule, null);
                break;
            }
        }
    }

    private void add(Hashtable hashtable, CSSMemRule cSSMemRule) {
        Hashtable hashtable2 = cSSMemRule.getDecls();
        Hashtable hashtable3 = cSSMemRule.getImportantDecls();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JCSSProperty jCSSProperty = (JCSSProperty)hashtable.get(string);
            JCSSProperty jCSSProperty2 = (JCSSProperty)hashtable2.get(string);
            JCSSProperty jCSSProperty3 = (JCSSProperty)hashtable3.get(string);
            if (jCSSProperty.isImportant()) {
                hashtable3.put(string, jCSSProperty.duplate());
                hashtable2.remove(string);
                continue;
            }
            hashtable2.put(string, jCSSProperty.duplate());
        }
    }

    private void append(Hashtable hashtable, CSSMemRule cSSMemRule, String string) {
        String string2 = cSSMemRule.getKey().I();
        CSSMemRule cSSMemRule2 = this.duplate(string, string2, cSSMemRule.getKey());
        if (cSSMemRule2 == null) {
            this.getAdjSibling(string, string2, cSSMemRule);
            this.add(hashtable, cSSMemRule);
        } else {
            this.add(hashtable, cSSMemRule2);
        }
    }

    private Vector clone(String string, String string2) {
        Vector vector = null;
        int n = this.QOIV(string);
        switch (n) {
            case 1: {
                vector = (Vector)this.compareTo.get(string2);
                break;
            }
            case 2: {
                vector = (Vector)this.contains.get(string2);
                break;
            }
            case 3: {
                vector = (Vector)this.containsKey.get(string2);
                break;
            }
            case 4: {
                vector = (Vector)this.duplate.get(string2);
                break;
            }
            case 5: {
                vector = (Vector)this.elementAt.get(string2);
                break;
            }
            default: {
                vector = (Vector)this.clone.get(string2);
            }
        }
        if (vector == null) {
            return new Vector();
        }
        return vector;
    }

    private Vector compareTo(String string) {
        Vector vector = new Vector();
        Enumeration enumeration = null;
        int n = this.QOIV(string);
        switch (n) {
            case 1: {
                enumeration = this.compareTo.keys();
                break;
            }
            case 2: {
                enumeration = this.contains.keys();
                break;
            }
            case 3: {
                enumeration = this.containsKey.keys();
                break;
            }
            case 4: {
                enumeration = this.duplate.keys();
                break;
            }
            case 5: {
                enumeration = this.elementAt.keys();
                break;
            }
            default: {
                enumeration = this.clone.keys();
                break;
            }
        }
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    private void contains(String string, String string2, Vector vector) {
        int n = this.QOIV(string);
        switch (n) {
            case 1: {
                this.compareTo.put(string2, vector);
                break;
            }
            case 2: {
                this.contains.put(string2, vector);
                break;
            }
            case 3: {
                this.containsKey.put(string2, vector);
                break;
            }
            case 4: {
                this.duplate.put(string2, vector);
                break;
            }
            case 5: {
                this.elementAt.put(string2, vector);
                break;
            }
            default: {
                this.clone.put(string2, vector);
            }
        }
    }

    private Vector containsKey(String string, String string2, CSSRuleKey cSSRuleKey) {
        Vector<CSSMemRule> vector = new Vector<CSSMemRule>();
        Vector vector2 = this.clone(string, string2);
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                CSSMemRule cSSMemRule = (CSSMemRule)vector2.elementAt(n);
                if (this.endsWith(cSSMemRule.getKey(), cSSRuleKey)) {
                    vector.add(cSSMemRule);
                }
                ++n;
            }
        }
        return vector;
    }

    private CSSMemRule duplate(String string, String string2, CSSRuleKey cSSRuleKey) {
        Vector vector = this.clone(string, string2);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                CSSMemRule cSSMemRule = (CSSMemRule)vector.elementAt(n);
                if (this.elementAt(cSSMemRule.getKey(), cSSRuleKey)) {
                    return cSSMemRule;
                }
                ++n;
            }
        }
        return null;
    }

    private boolean elementAt(CSSRuleKey cSSRuleKey, CSSRuleKey cSSRuleKey2) {
        if (cSSRuleKey.I().compareTo(cSSRuleKey2.I()) != 0) {
            return false;
        }
        if (!this.equals(cSSRuleKey.getConditions(), cSSRuleKey2.getConditions())) {
            return false;
        }
        if (cSSRuleKey.getAdjSibling() != null && cSSRuleKey2.getAdjSibling() != null) {
            return this.endsWith(cSSRuleKey.getAdjSibling(), cSSRuleKey2.getAdjSibling());
        }
        if (cSSRuleKey.getAdjSibling() == null && cSSRuleKey2.getAdjSibling() == null) {
            if (cSSRuleKey.getParent() != null && cSSRuleKey2.getParent() != null) {
                return this.endsWith(cSSRuleKey.getParent(), cSSRuleKey2.getParent());
            }
            if (cSSRuleKey.getParent() == null && cSSRuleKey2.getParent() == null) {
                if (cSSRuleKey.getAncestor() != null && cSSRuleKey2.getAncestor() != null) {
                    return this.endsWith(cSSRuleKey.getAncestor(), cSSRuleKey2.getAncestor());
                }
                return cSSRuleKey.getAncestor() == null && cSSRuleKey2.getAncestor() == null;
            }
            return false;
        }
        return false;
    }

    private boolean endsWith(CSSRuleKey cSSRuleKey, CSSRuleKey cSSRuleKey2) {
        if (!cSSRuleKey.I().equals("*") && !cSSRuleKey2.I().equals("*") && cSSRuleKey.I().compareTo(cSSRuleKey2.I()) != 0) {
            return false;
        }
        if (!this.equals(cSSRuleKey.getConditions(), cSSRuleKey2.getConditions())) {
            return false;
        }
        if (cSSRuleKey.getAdjSibling() != null && cSSRuleKey2.getAdjSibling() != null) {
            return this.endsWith(cSSRuleKey.getAdjSibling(), cSSRuleKey2.getAdjSibling());
        }
        if (cSSRuleKey.getAdjSibling() == null && cSSRuleKey2.getAdjSibling() == null) {
            if (cSSRuleKey.getParent() != null && cSSRuleKey2.getParent() != null) {
                return this.endsWith(cSSRuleKey.getParent(), cSSRuleKey2.getParent());
            }
            if (cSSRuleKey.getParent() == null && cSSRuleKey2.getParent() == null) {
                if (cSSRuleKey.getAncestor() != null && cSSRuleKey2.getAncestor() != null) {
                    return this.endsWith(cSSRuleKey.getAncestor(), cSSRuleKey2.getAncestor());
                }
                return cSSRuleKey.getAncestor() == null && cSSRuleKey2.getAncestor() == null;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean equals(Condition condition, Condition condition2) {
        if (condition == null || condition2 == null) return condition == null && condition2 == null;
        if (condition.getConditionType() != condition2.getConditionType()) return false;
        switch (condition.getConditionType()) {
            case 0: {
                return this.equals(((CombinatorCondition)condition).getFirstCondition(), ((CombinatorCondition)condition2).getFirstCondition()) && this.equals(((CombinatorCondition)condition).getSecondCondition(), ((CombinatorCondition)condition2).getSecondCondition());
            }
            case 1: {
                return this.equals(((CombinatorCondition)condition).getFirstCondition(), ((CombinatorCondition)condition2).getFirstCondition()) || this.equals(((CombinatorCondition)condition).getSecondCondition(), ((CombinatorCondition)condition2).getSecondCondition());
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                AttributeCondition attributeCondition2 = (AttributeCondition)condition2;
                return this.get(attributeCondition, attributeCondition2, condition.getConditionType());
            }
            case 6: {
                LangCondition langCondition = (LangCondition)condition;
                LangCondition langCondition2 = (LangCondition)condition2;
                return langCondition.getLang().compareTo(langCondition2.getLang()) == 0;
            }
            case 3: {
                return true;
            }
        }
        JRLogger.getLogger(this.getClass()).warn("condition type = " + condition.getConditionType());
        return true;
    }

    private boolean get(AttributeCondition attributeCondition, AttributeCondition attributeCondition2, int n) {
        String string = attributeCondition.getLocalName();
        String string2 = attributeCondition2.getLocalName();
        if (string != null && string2 != null) {
            if (string.compareTo(string2) == 0) {
                return attributeCondition.getValue().compareTo(attributeCondition2.getValue()) == 0;
            }
            return false;
        }
        return attributeCondition.getValue().compareTo(attributeCondition2.getValue()) == 0;
    }

    private void getAdjSibling(String string, String string2, CSSMemRule cSSMemRule) {
        Vector<CSSMemRule> vector = this.clone(string, string2);
        if (vector.size() == 0) {
            vector = new Vector<CSSMemRule>();
            this.contains(string, string2, vector);
        }
        vector.add(cSSMemRule);
    }

    private CSSRuleKey getAncestor(Selector selector, CSSRuleKey cSSRuleKey) {
        block8: while (true) {
            switch (selector.getSelectorType()) {
                case 11: {
                    DescendantSelector descendantSelector = (DescendantSelector)selector;
                    CSSRuleKey cSSRuleKey2 = new CSSRuleKey();
                    this.getAncestor(descendantSelector.getAncestorSelector(), cSSRuleKey2);
                    this.getAncestor((Selector)descendantSelector.getSimpleSelector(), cSSRuleKey);
                    cSSRuleKey.setParent(cSSRuleKey2);
                    return cSSRuleKey;
                }
                case 10: {
                    DescendantSelector descendantSelector = (DescendantSelector)selector;
                    CSSRuleKey cSSRuleKey3 = new CSSRuleKey();
                    this.getAncestor(descendantSelector.getAncestorSelector(), cSSRuleKey3);
                    this.getAncestor((Selector)descendantSelector.getSimpleSelector(), cSSRuleKey);
                    cSSRuleKey.setAncestor(cSSRuleKey3);
                    return cSSRuleKey;
                }
                case 12: {
                    SiblingSelector siblingSelector = (SiblingSelector)selector;
                    CSSRuleKey cSSRuleKey4 = new CSSRuleKey();
                    this.getAncestor(siblingSelector.getSelector(), cSSRuleKey4);
                    this.getAncestor((Selector)siblingSelector.getSiblingSelector(), cSSRuleKey);
                    cSSRuleKey.setAdjSibling(cSSRuleKey4);
                    return cSSRuleKey;
                }
                case 4: {
                    ElementSelector elementSelector = (ElementSelector)selector;
                    cSSRuleKey.I(elementSelector.toString());
                    if (elementSelector.getLocalName() != null) {
                        ++this.append;
                    }
                    return cSSRuleKey;
                }
                case 0: {
                    ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                    Condition condition = conditionalSelector.getCondition();
                    cSSRuleKey.setConditions(condition);
                    this.getAncestorSelector(condition);
                    selector = conditionalSelector.getSimpleSelector();
                    continue block8;
                }
                case 9: {
                    ElementSelector elementSelector = (ElementSelector)selector;
                    cSSRuleKey.I(elementSelector.getLocalName());
                    return cSSRuleKey;
                }
            }
            break;
        }
        return cSSRuleKey;
    }

    private void getAncestorSelector(Condition condition) {
        switch (condition.getConditionType()) {
            case 0: 
            case 1: {
                this.getAncestorSelector(((CombinatorCondition)condition).getFirstCondition());
                this.getAncestorSelector(((CombinatorCondition)condition).getSecondCondition());
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                ++this.add;
                break;
            }
            case 5: {
                ++this._mapStringToColor;
                break;
            }
            case 6: {
                ++this.add;
                break;
            }
            default: {
                System.out.println("condition type = " + condition.getConditionType());
            }
        }
    }

    public void applyCSS(JetRptObject jetRptObject, boolean bl) {
        this.getCSSStyleSheet(jetRptObject, bl, null, false);
        this.getCSSStyleSheet(jetRptObject, bl, null, true);
    }

    public void applyCSS(JetRptObject jetRptObject, boolean bl, boolean bl2) {
        this.getCSSStyleSheet(jetRptObject, bl, null, bl2);
    }

    private void getCSSStyleSheet(JetRptObject jetRptObject, boolean bl, String string, boolean bl2) {
        Hashtable hashtable = new Hashtable();
        hashtable = this.getCSSStyleSheetManager(jetRptObject, string, bl2);
        this.getCondition(hashtable, jetRptObject);
        if (bl) {
            Vector vector = jetRptObject.getChildren();
            if (vector == null) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                this.getCSSStyleSheet((JetRptObject)vector.elementAt(n), bl, string, bl2);
                ++n;
            }
        }
    }

    public Collection getDeclareations(JetRptObject jetRptObject) {
        Hashtable hashtable = this.getCSSStyleSheetManager(jetRptObject, null, false);
        Hashtable hashtable2 = this.getCSSStyleSheetManager(jetRptObject, null, true);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, hashtable2.get(string));
        }
        return hashtable.values();
    }

    private Hashtable getCSSStyleSheetManager(JetRptObject jetRptObject, String string, boolean bl) {
        String string2 = this.getCssRules(jetRptObject);
        if (string == null) {
            string = QOIV[0];
        }
        int n = 0;
        Vector vector = this.clone(string, string2);
        Vector vector2 = this.clone(string, "*");
        int n2 = 0;
        while (vector2 != null && n2 < vector2.size()) {
            if (!vector.contains(vector2.elementAt(n2))) {
                vector.add(vector2.elementAt(n2));
            }
            ++n2;
        }
        Hashtable hashtable = new Hashtable();
        JetRptObject jetRptObject2 = (JetRptObject)((Object)jetRptObject.getParent());
        if (jetRptObject2 != null) {
            hashtable = jetRptObject2.getProperties();
        }
        Hashtable hashtable2 = new Hashtable();
        int n3 = -1;
        if (vector != null) {
            n = vector.size();
        }
        int n4 = 0;
        while (n4 < n) {
            CSSMemRule cSSMemRule = (CSSMemRule)vector.elementAt(n4);
            CSSRuleKey cSSRuleKey = cSSMemRule.getKey();
            if (this.getCssText(cSSRuleKey, jetRptObject)) {
                if (n3 == -1) {
                    n3 = cSSMemRule.getPrioty();
                    hashtable2 = bl ? (Hashtable)cSSMemRule.getImportantDecls().clone() : (Hashtable)cSSMemRule.getDecls().clone();
                } else if (this.getChildren(hashtable2, cSSMemRule, hashtable, n3, bl)) {
                    n3 = cSSMemRule.getPrioty();
                }
            }
            ++n4;
        }
        return hashtable2;
    }

    private boolean getChildren(Hashtable hashtable, CSSMemRule cSSMemRule, Hashtable hashtable2, int n, boolean bl) {
        boolean bl2 = false;
        Hashtable hashtable3 = hashtable;
        Hashtable hashtable4 = cSSMemRule.getDecls();
        if (bl) {
            hashtable4 = cSSMemRule.getImportantDecls();
        }
        Enumeration enumeration = hashtable4.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JCSSProperty jCSSProperty = (JCSSProperty)hashtable4.get(string);
            if ((!hashtable3.containsKey(string) || cSSMemRule.getPrioty() < n) && hashtable3.containsKey(string)) continue;
            if (jCSSProperty.getValue().getCssText().equals("inherit")) {
                JetProperty jetProperty = (JetProperty)hashtable2.get(string);
                hashtable3.put(string, jetProperty);
            } else {
                hashtable3.put(string, jCSSProperty);
            }
            bl2 = true;
        }
        return bl2;
    }

    private void getClass(Hashtable hashtable) {
        Object v = hashtable.get(PropertyNameConstant.getNameByID(525));
        if (v != null) {
            hashtable.put(PropertyNameConstant.getNameByID(1878), v);
            hashtable.put(PropertyNameConstant.getNameByID(1885), v);
            hashtable.put(PropertyNameConstant.getNameByID(1881), v);
            hashtable.put(PropertyNameConstant.getNameByID(1883), v);
        }
        if ((v = hashtable.get(PropertyNameConstant.getNameByID(522))) != null) {
            hashtable.put(PropertyNameConstant.getNameByID(1877), v);
            hashtable.put(PropertyNameConstant.getNameByID(1884), v);
            hashtable.put(PropertyNameConstant.getNameByID(1880), v);
            hashtable.put(PropertyNameConstant.getNameByID(1882), v);
        }
    }

    private void getCondition(Hashtable hashtable, JetRptObject jetRptObject) {
        this.getClass(hashtable);
        Hashtable hashtable2 = jetRptObject.getProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            JCSSProperty jCSSProperty = null;
            JetProperty jetProperty = null;
            if (v instanceof JCSSProperty) {
                jCSSProperty = (JCSSProperty)v;
            } else {
                jetProperty = (JetProperty)v;
            }
            if (hashtable2.containsKey(string)) {
                object2 = (JetProperty)hashtable2.get(string);
                if (jCSSProperty != null) {
                    object = jCSSProperty.getValue();
                    this.getConditions((JetProperty)object2, (CSSValue)object);
                    continue;
                }
                this.getConditionType((JetProperty)object2, jetProperty);
                continue;
            }
            if (!(jetRptObject instanceof JRObjectTemplate) || (object2 = ((JRObjectTemplate)jetRptObject).getJetRptMode()) == null) continue;
            object = ((JetRptMode)object2).getCurrentRender();
            JetProperty jetProperty2 = object.getRenderPropertyByName(string);
            if (object == null || jetProperty2 == null) continue;
            if (jCSSProperty != null) {
                this.getConditions(jetProperty2, jCSSProperty.getValue());
            } else {
                this.getConditionType(jetProperty2, jetProperty);
            }
            object.setRenderValueByProperty(jetProperty2);
        }
    }

    private void getConditionType(JetProperty jetProperty, JetProperty jetProperty2) {
        jetProperty.setObject(jetProperty2.getValue());
    }

    private void getConditions(JetProperty jetProperty, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
            String string = cSSPrimitiveValue.getStringValue();
            if (string != null && string.length() > 3 && string.startsWith("@") && string.endsWith("@")) {
                jetProperty.setChangeByObject(string.substring(1, string.length() - 1));
                return;
            }
            short s = cSSPrimitiveValue.getPrimitiveType();
            switch (jetProperty.getPropType()) {
                case 6: {
                    jetProperty.setObject(cSSPrimitiveValue.getStringValue());
                    break;
                }
                case 5: {
                    ((JetNumber)jetProperty).set(cSSPrimitiveValue.getFloatValue(cSSPrimitiveValue.getPrimitiveType()));
                    break;
                }
                case 4: {
                    int n = (int)cSSPrimitiveValue.getFloatValue(cSSPrimitiveValue.getPrimitiveType());
                    ((JetUnitNumber)jetProperty).setUnitValue(n);
                    break;
                }
                case 1: {
                    JetBoolean jetBoolean = (JetBoolean)jetProperty;
                    if (cSSPrimitiveValue.getStringValue().compareTo("true") == 0) {
                        jetProperty.setObject(new Boolean(true));
                        break;
                    }
                    if (cSSPrimitiveValue.getStringValue().compareTo("false") != 0) break;
                    jetProperty.setObject(new Boolean(false));
                    break;
                }
                case 2: {
                    if (s == 21) {
                        String string2 = cSSPrimitiveValue.getStringValue();
                        if (!string2.startsWith("#") && !string2.equals("Transparent")) break;
                        jetProperty.setObject(MiscTools._mapStringToColor(string2));
                        break;
                    }
                    if (s != 25) break;
                    RGBColor rGBColor = cSSPrimitiveValue.getRGBColorValue();
                    jetProperty.setObject(MiscTools._mapStringToColor(rGBColor.toString()));
                    break;
                }
                case 3: {
                    JetEnumeration jetEnumeration = (JetEnumeration)jetProperty;
                    jetEnumeration.setValue(cSSPrimitiveValue.getStringValue());
                    break;
                }
                case 9: {
                    String string3 = cSSPrimitiveValue.getStringValue();
                    string3 = string3.replaceAll("'", "\u0007");
                    int n = string3.indexOf("\u0007", 1);
                    string3 = string3.substring(n + 1);
                    ((JetVector)jetProperty).set(string3);
                    break;
                }
            }
            jetProperty.setCanChangeByOthers(false);
        }
    }

    private String getCssRules(JetRptObject jetRptObject) {
        String string = UpgradeName.getInstancePrefixTag(jetRptObject);
        return string;
    }

    private boolean getCssText(CSSRuleKey cSSRuleKey, JetRptObject jetRptObject) {
        if (!cSSRuleKey.I().equals("*") && !cSSRuleKey.I().equals(this.getCssRules(jetRptObject))) {
            return false;
        }
        if (!this.getCurrentRender(cSSRuleKey.getConditions(), jetRptObject)) {
            return false;
        }
        CSSRuleKey cSSRuleKey2 = null;
        if (cSSRuleKey.getAdjSibling() != null) {
            cSSRuleKey2 = cSSRuleKey.getAdjSibling();
            JetRptObject jetRptObject2 = this.getCssValueType(jetRptObject);
            if (jetRptObject2 == null) {
                return false;
            }
            String string = this.getCssRules(jetRptObject2);
            if (cSSRuleKey2.I().equals("*") || cSSRuleKey2.I().equals(string)) {
                return this.getCssText(cSSRuleKey2, jetRptObject2);
            }
            return false;
        }
        if (cSSRuleKey.getAncestor() != null) {
            cSSRuleKey2 = cSSRuleKey.getAncestor();
            JetRptObject jetRptObject3 = (JetRptObject)((Object)jetRptObject.getParent());
            while (jetRptObject3 != null) {
                String string = this.getCssRules(jetRptObject3);
                if (cSSRuleKey2.I().equals("*") || cSSRuleKey2.I().equals(string)) {
                    return this.getCssText(cSSRuleKey2, jetRptObject3);
                }
                jetRptObject3 = (JetRptObject)((Object)jetRptObject3.getParent());
            }
            return false;
        }
        if (cSSRuleKey.getParent() != null) {
            cSSRuleKey2 = cSSRuleKey.getParent();
            JetRptObject jetRptObject4 = (JetRptObject)((Object)jetRptObject.getParent());
            if (jetRptObject4 == null) {
                return false;
            }
            String string = this.getCssRules(jetRptObject4);
            if (cSSRuleKey2.I().equals("*") || cSSRuleKey2.I().equals(string)) {
                return this.getCssText(cSSRuleKey2, jetRptObject4);
            }
            return false;
        }
        return true;
    }

    private JetRptObject getCssValueType(JetRptObject jetRptObject) {
        Vector vector = jetRptObject.getParent().getChildren();
        int n = vector.indexOf(jetRptObject);
        if (n == -1 || n == 0) {
            return null;
        }
        return (JetRptObject)vector.elementAt(n - 1);
    }

    private boolean getCurrentRender(Condition condition, JetRptObject jetRptObject) {
        if (condition == null) {
            return true;
        }
        switch (condition.getConditionType()) {
            case 0: {
                return this.getCurrentRender(((CombinatorCondition)condition).getFirstCondition(), jetRptObject) && this.getCurrentRender(((CombinatorCondition)condition).getSecondCondition(), jetRptObject);
            }
            case 1: {
                return this.getCurrentRender(((CombinatorCondition)condition).getFirstCondition(), jetRptObject) || this.getCurrentRender(((CombinatorCondition)condition).getSecondCondition(), jetRptObject);
            }
            case 4: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                String string = attributeCondition.getLocalName();
                String string2 = attributeCondition.getValue();
                return this.getDeclarations(jetRptObject, string, string2, attributeCondition.getConditionType());
            }
            case 9: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getDeclarations(jetRptObject, "class", attributeCondition.getValue(), attributeCondition.getConditionType());
            }
            case 5: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getDeclarations(jetRptObject, "id", attributeCondition.getValue(), attributeCondition.getConditionType());
            }
            case 8: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getDeclarations(jetRptObject, attributeCondition.getLocalName(), attributeCondition.getValue(), attributeCondition.getConditionType());
            }
            case 6: {
                LangCondition langCondition = (LangCondition)condition;
                return this.getDeclarations(jetRptObject, "lang", langCondition.getLang(), langCondition.getConditionType());
            }
            case 10: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getDeclarations(jetRptObject, attributeCondition.getValue(), "true", attributeCondition.getConditionType());
            }
            case 3: {
                return this.getDecls(jetRptObject);
            }
            case 7: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getDeclarations(jetRptObject, attributeCondition.getLocalName(), attributeCondition.getValue(), attributeCondition.getConditionType());
            }
        }
        System.out.println("condition type = " + condition.getConditionType());
        return true;
    }

    private boolean getDeclarations(JetRptObject jetRptObject, String string, String string2, int n) {
        JetProperty jetProperty = jetRptObject.nameToProperty(string);
        if (jetProperty == null) {
            return false;
        }
        String string3 = jetProperty.toUnitString();
        if (jetProperty != null) {
            switch (n) {
                case 7: {
                    return string3.indexOf(string2) != -1;
                }
                case 8: {
                    return string3.startsWith(string2 + "-");
                }
            }
            return string2.compareTo(string3) == 0;
        }
        return false;
    }

    private boolean getDecls(JetRptObject jetRptObject) {
        Vector vector = jetRptObject.getParent().getChildren();
        int n = vector.indexOf(jetRptObject);
        return n == 0;
    }
}

