/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.atapter;

import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.AAdditionTuple;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.datatypes.JinfonetArrayBaseObject;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.api.DSException;

public class RelationalToolkit {
    private int[] QOIV(JRelationMetaData jRelationMetaData) throws DSException {
        int[] nArray = new int[jRelationMetaData.getColumnCount() + 1];
        int n = 1;
        while (n <= jRelationMetaData.getColumnCount()) {
            nArray[n] = jRelationMetaData.getAttribute(n).getDataType();
            ++n;
        }
        return nArray;
    }

    public void refreshTuple2Record(JRelationMetaData jRelationMetaData, ITuple iTuple, Record record) throws DSException {
        DbValue[] dbValueArray = record.getValueArray();
        int[] nArray = this.QOIV(jRelationMetaData);
        int n = 1;
        while (n <= jRelationMetaData.getColumnCount()) {
            switch (nArray[n]) {
                case -6: {
                    ((DbTinyInt)dbValueArray[n - 1]).set(iTuple.getByte(n));
                    break;
                }
                case -7: {
                    ((DbBit)dbValueArray[n - 1]).set(iTuple.getBoolean(n));
                    break;
                }
                case 5: {
                    ((DbSmallInt)dbValueArray[n - 1]).set(iTuple.getShort(n));
                    break;
                }
                case 4: {
                    ((DbInteger)dbValueArray[n - 1]).set(iTuple.getInt(n));
                    break;
                }
                case -5: {
                    ((DbBigInt)dbValueArray[n - 1]).set(iTuple.getLong(n));
                    break;
                }
                case 6: {
                    ((DbReal)dbValueArray[n - 1]).set(iTuple.getFloat(n));
                    break;
                }
                case 8: {
                    ((DbDouble)dbValueArray[n - 1]).set(iTuple.getDouble(n));
                    break;
                }
                case 3: {
                    ((DbDecimal)dbValueArray[n - 1]).set(iTuple.getBigDecimal(n));
                    break;
                }
                case 91: {
                    ((DbDate)dbValueArray[n - 1]).set(iTuple.getDate(n).getTime());
                    break;
                }
                case 92: {
                    ((DbTime)dbValueArray[n - 1]).set(iTuple.getTime(n).getTime());
                    break;
                }
                case 93: {
                    ((DbTimestamp)dbValueArray[n - 1]).set(iTuple.getTimeStamp(n).getTime());
                    ((DbTimestamp)dbValueArray[n - 1]).setNanos(iTuple.getTimeStamp(n).getNanos());
                    break;
                }
                case 12: {
                    ((DbChar)dbValueArray[n - 1]).set(iTuple.getString(n));
                    break;
                }
                case -2: {
                    ((DbBinary)dbValueArray[n - 1]).set(iTuple.getBytes(n));
                    break;
                }
                case 2003: {
                    ((DbArray)dbValueArray[n - 1]).set(iTuple.getArray(n).getBaseType(), iTuple.getArray(n).getArray());
                    break;
                }
                case 2004: {
                    Blob blob = iTuple.getBlob(n);
                    ((DbBinary)dbValueArray[n - 1]).set(blob.getBytes(1L, (int)blob.length()));
                    break;
                }
                case 2005: {
                    Clob clob = iTuple.getClob(n);
                    ((DbChar)dbValueArray[n - 1]).set(clob.getSubString(1L, (int)clob.length()));
                    break;
                }
                default: {
                    throw new DSException(8668, new Object[]{"not support data type: " + jRelationMetaData.getAttribute(n).getDataType() + " in col: " + jRelationMetaData.getAttribute(n).getAliasName()});
                }
            }
            if (iTuple.wasNull()) {
                dbValueArray[n - 1].setNull();
            }
            ++n;
        }
    }

    public void refreshRecord2Tuple(JRelationMetaData jRelationMetaData, Record record, AAdditionTuple aAdditionTuple) throws DSException {
        DbValue dbValue = null;
        int n = 0;
        while (n < jRelationMetaData.getColumnCount()) {
            dbValue = record.getCell(n);
            if (dbValue.bNull) {
                aAdditionTuple.putNull(0);
            } else if (dbValue.getColDesc().isArray()) {
                aAdditionTuple.putArray(new JinfonetArrayBaseObject(dbValue.getSqlType(), ((DbArray)dbValue).getValue()));
            } else {
                switch (dbValue.getColDesc().getSqlType()) {
                    case -7: {
                        aAdditionTuple.putBoolean(((DbBit)dbValue).get());
                        break;
                    }
                    case -6: {
                        aAdditionTuple.putByte(((DbTinyInt)dbValue).byteValue());
                        break;
                    }
                    case 5: {
                        aAdditionTuple.putShort(((DbSmallInt)dbValue).get());
                        break;
                    }
                    case 4: {
                        aAdditionTuple.putInt(((DbInteger)dbValue).get());
                        break;
                    }
                    case -5: {
                        aAdditionTuple.putLong(((DbBigInt)dbValue).get());
                        break;
                    }
                    case 6: 
                    case 7: {
                        try {
                            aAdditionTuple.putFloat(((DbReal)dbValue).get());
                        }
                        catch (Exception exception) {
                            aAdditionTuple.putFloat(Float.parseFloat(((DbReal)dbValue).toString()));
                        }
                        break;
                    }
                    case 8: {
                        try {
                            aAdditionTuple.putDouble(((DbDouble)dbValue).get());
                        }
                        catch (Exception exception) {
                            aAdditionTuple.putDouble(Double.parseDouble(((DbDouble)dbValue).toString()));
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        aAdditionTuple.putBigDecimal(((DbDecimal)dbValue).get());
                        break;
                    }
                    case 91: {
                        JinfonetDate jinfonetDate = new JinfonetDate();
                        jinfonetDate.setTime(((DbDate)dbValue).get());
                        aAdditionTuple.putDate(jinfonetDate);
                        break;
                    }
                    case 92: {
                        JinfonetTime jinfonetTime = new JinfonetTime();
                        jinfonetTime.setTime(((DbTime)dbValue).get());
                        aAdditionTuple.putTime(jinfonetTime);
                        break;
                    }
                    case 93: {
                        JinfonetTimeStamp jinfonetTimeStamp = new JinfonetTimeStamp();
                        jinfonetTimeStamp.setTime(((DbTimestamp)dbValue).get());
                        jinfonetTimeStamp.setNanos(((DbTimestamp)dbValue).getNanos());
                        aAdditionTuple.putTimeStamp(jinfonetTimeStamp);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        aAdditionTuple.putString(((DbChar)dbValue).get());
                        break;
                    }
                    case -4: 
                    case -2: {
                        aAdditionTuple.putBytes(((DbBinary)dbValue).get());
                        break;
                    }
                    case 2004: {
                        JinfonetBlobBaseBytes jinfonetBlobBaseBytes = new JinfonetBlobBaseBytes(((DbBinary)dbValue).get());
                        aAdditionTuple.putBlob(jinfonetBlobBaseBytes);
                        break;
                    }
                    case 2005: {
                        JinfonetClobBaseString jinfonetClobBaseString = new JinfonetClobBaseString(((DbChar)dbValue).get());
                        aAdditionTuple.putClob(jinfonetClobBaseString);
                        break;
                    }
                    default: {
                        throw new DSException(8668, new Object[]{"not support data type : " + dbValue.getColDesc().getSqlType()});
                    }
                }
            }
            ++n;
        }
    }
}

