/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core.node;

import java.math.BigDecimal;
import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.AggregateException;
import jet.dataengine8.olap.core.node.ACalculator;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.olap.core.node.ICountCalculator;
import jet.dataengine8.olap.core.node.InitValue;
import jet.dataengine8.olap.util.DataValue;
import jet.dataengine8.util.SFT;

public class BigDecimalCalculator
extends ACalculator {
    protected BigDecimalCalculator(ICountCalculator iCountCalculator, int n, int n2) {
        super(iCountCalculator, n, n2);
    }

    protected DataValue max(ANode aNode, DataValue dataValue) throws DSException, AggregateException {
        BigDecimal bigDecimal = this.I(aNode, 0);
        if (bigDecimal == InitValue.maxBigDecimal) {
            dataValue.set(3, null);
            return dataValue;
        }
        dataValue.set(3, bigDecimal);
        return dataValue;
    }

    protected DataValue min(ANode aNode, DataValue dataValue) throws DSException {
        BigDecimal bigDecimal = this.I(aNode, 1);
        if (bigDecimal == InitValue.minBigDecimal) {
            dataValue.set(3, null);
            return dataValue;
        }
        dataValue.set(3, bigDecimal);
        return dataValue;
    }

    protected DataValue squareSum(ANode aNode, DataValue dataValue) throws DSException {
        BigDecimal bigDecimal = this.I(aNode, 3);
        dataValue.set(3, bigDecimal);
        return dataValue;
    }

    protected DataValue sum(ANode aNode, DataValue dataValue) throws DSException {
        BigDecimal bigDecimal = this.I(aNode, 2);
        dataValue.set(3, bigDecimal);
        return dataValue;
    }

    protected DataValue variance(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(0, null);
            return dataValue;
        }
        double d = 1.0 / (double)(l - 1L);
        BigDecimal bigDecimal = this.QOIV(aNode).multiply(new BigDecimal(d));
        dataValue.set(3, bigDecimal);
        return dataValue;
    }

    protected DataValue populationVariance(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(3, SFT.ZERO_BIGDECIMAL);
            return dataValue;
        }
        double d = 1.0 / (double)l;
        BigDecimal bigDecimal = this.QOIV(aNode).multiply(new BigDecimal(d));
        dataValue.set(3, bigDecimal);
        return dataValue;
    }

    protected DataValue stdDev(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(0, null);
            return dataValue;
        }
        BigDecimal bigDecimal = this.QOIV(aNode);
        double d = bigDecimal.divide(new BigDecimal((double)(l - 1L)), bigDecimal.scale(), 3).doubleValue();
        d = Math.sqrt(d);
        dataValue.set(3, new BigDecimal(d));
        return dataValue;
    }

    protected DataValue populationStdDev(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.getCount(aNode);
        if (l <= 1L) {
            dataValue.set(0, null);
            return dataValue;
        }
        BigDecimal bigDecimal = this.QOIV(aNode);
        double d = bigDecimal.divide(new BigDecimal((double)l), bigDecimal.scale(), 3).doubleValue();
        d = Math.sqrt(d);
        dataValue.set(3, new BigDecimal(d));
        return dataValue;
    }

    protected DataValue average(ANode aNode, DataValue dataValue) throws DSException {
        BigDecimal bigDecimal = this.I(aNode, 2);
        long l = this.getCount(aNode);
        BigDecimal bigDecimal2 = bigDecimal.multiply(new BigDecimal(1.0 / (double)l));
        dataValue.set(3, bigDecimal2);
        return dataValue;
    }

    private BigDecimal I(ANode aNode, int n) {
        BigDecimal[] bigDecimalArray = (BigDecimal[])aNode.getValues(this.nodeValueIndex);
        return bigDecimalArray[n];
    }

    private BigDecimal QOIV(ANode aNode) throws DSException {
        BigDecimal[] bigDecimalArray = (BigDecimal[])aNode.getValues(this.nodeValueIndex);
        BigDecimal bigDecimal = bigDecimalArray[2];
        BigDecimal bigDecimal2 = bigDecimalArray[3];
        BigDecimal bigDecimal3 = BigDecimal.valueOf(this.getCount(aNode));
        BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal3, 5);
        return bigDecimal2.subtract(bigDecimal4.multiply(bigDecimal));
    }
}

