/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class LongArrayList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient long[] QOIV;
    private int modCount = 0;
    private int size;

    public LongArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.QOIV = new long[n];
    }

    public LongArrayList() {
        this(30);
    }

    public LongArrayList(long[] lArray) {
        this.QOIV = lArray;
        this.size = this.QOIV.length;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.QOIV.length) {
            long[] lArray = this.QOIV;
            this.QOIV = new long[this.size];
            System.arraycopy(lArray, 0, this.QOIV, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this.QOIV.length) {
            long[] lArray = this.QOIV;
            int n2 = this.QOIV.length * 2 + 1;
            this.QOIV = n2 > n ? new long[n2] : new long[n];
            System.arraycopy(lArray, 0, this.QOIV, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(long l) {
        return this.indexOf(l) >= 0;
    }

    public int indexOf(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            int n = 0;
            while (n < this.size) {
                if (this.QOIV[n] == l) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            int n = this.size - 1;
            while (n >= 0) {
                if (this.QOIV[n] == l) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public long[] toArray() {
        long[] lArray = new long[this.size];
        System.arraycopy(this.QOIV, 0, lArray, 0, this.size);
        return lArray;
    }

    public long[] toArray(long[] lArray) {
        if (lArray.length < this.size) {
            lArray = (long[])Array.newInstance(lArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.QOIV, 0, lArray, 0, this.size);
        if (lArray.length > this.size) {
            lArray[this.size] = 0L;
        }
        return lArray;
    }

    public long get(int n) {
        this.QOIV(n);
        return this.QOIV[n];
    }

    public long set(int n, long l) {
        this.QOIV(n);
        long l2 = this.QOIV[n];
        this.QOIV[n] = l;
        return l2;
    }

    public boolean add(long l) {
        this.ensureCapacity(this.size + 1);
        this.QOIV[this.size++] = l;
        return true;
    }

    public boolean addAll(long[] lArray) {
        long[] lArray2 = lArray;
        int n = lArray2.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(lArray2, 0, this.QOIV, this.size, n);
        this.size += n;
        return n != 0;
    }

    public void add(int n, long l) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.QOIV, n, this.QOIV, n + 1, this.size - n);
        this.QOIV[n] = l;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        int n = 0;
        while (n < this.size) {
            this.QOIV[n] = 0L;
            ++n;
        }
        this.size = 0;
    }

    private void QOIV(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.QOIV.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeLong(this.QOIV[n]);
            ++n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.QOIV = new long[n];
        int n2 = 0;
        while (n2 < this.size) {
            this.QOIV[n2] = objectInputStream.readLong();
            ++n2;
        }
    }

    public LongArrayList merge(LongArrayList longArrayList) {
        int n = 0;
        int n2 = longArrayList.size();
        while (n < n2) {
            if (!this.contains(longArrayList.QOIV[n])) {
                this.add(longArrayList.QOIV[n]);
            }
            ++n;
        }
        return this;
    }

    public LongArrayList sort() {
        LongArrayList longArrayList = (LongArrayList)this.clone();
        Arrays.sort(longArrayList.QOIV);
        return longArrayList;
    }

    public LongArrayList interSectionForDataTeam(LongArrayList longArrayList) {
        int n;
        LongArrayList longArrayList2 = new LongArrayList();
        LongArrayList longArrayList3 = this.size <= longArrayList.size() ? this : longArrayList;
        LongArrayList longArrayList4 = this.size > longArrayList.size() ? this : longArrayList;
        longArrayList3 = longArrayList3.sort();
        longArrayList4 = longArrayList4.sort();
        long l = 0L;
        long l2 = 0L;
        l = longArrayList3.QOIV[0];
        l2 = longArrayList4.QOIV[0];
        int n2 = 0;
        int n3 = 0;
        int n4 = longArrayList3.size();
        do {
            n = longArrayList4.size();
            l = longArrayList3.QOIV[n2];
            l2 = longArrayList4.QOIV[n3];
            if (l == l2) {
                longArrayList2.add(l);
                ++n2;
                ++n3;
                continue;
            }
            if (l > l2) {
                ++n3;
                continue;
            }
            ++n2;
        } while (n2 < n4 && n3 < n);
        return longArrayList2;
    }

    public Object clone() {
        try {
            LongArrayList longArrayList = (LongArrayList)super.clone();
            longArrayList.QOIV = new long[this.size];
            System.arraycopy(this.QOIV, 0, longArrayList.QOIV, 0, this.size);
            longArrayList.modCount = 0;
            return longArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

