/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import guitools.toolkit.Unit;
import java.awt.Font;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.datastream.DSDataStreamable;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.ParagraphTools;
import jet.util.FontSets;

public class DSParagraphText
extends JRVisiableResult {
    private String QOIV;
    private Font UTFLength = null;
    private Font add = null;
    private int addElement = 0;
    private int append = 0;
    private int[] clone;
    private boolean convertPixelToUnit = false;
    private boolean convertUnitToPixel = false;
    private boolean dup = false;
    private DbValue elementAt = null;
    private int getAfterWordWNum = 0;
    private int getBeforeWordWNum = 0;
    private int getErrorWidth = 0;
    private boolean getFont = false;
    private boolean getLeading = false;
    private Vector getText = new Vector();
    private int[] getTextBaseLineY;
    private int getWhiteSpaceNum = -1;
    private int getWidthBeforeFirstDecimalUsePrecision = -1;
    private boolean getWrapPostionUsePrecision = true;
    private int lastBreakPos = -1;

    public DSParagraphText() {
    }

    public DSParagraphText(String string, Font font) {
        this.QOIV = string;
        this.UTFLength = font;
    }

    public DSParagraphText(String string, int n) {
        this.QOIV = string;
        this.UTFLength = this.QOIV(n);
    }

    public void setText(String string) {
        this.QOIV = string;
    }

    public String getText() {
        if (this.append == 0) {
            return this.QOIV.substring(this.addElement);
        }
        return this.QOIV.substring(this.addElement, this.append + this.addElement);
    }

    public String getAllText() {
        return this.QOIV;
    }

    public void setFont(Font font) {
        this.UTFLength = font;
    }

    public void setFontWhenScript(Font font) {
        this.add = font;
    }

    public void setStartCharNum(int n) {
        this.addElement = n;
    }

    public int getStartCharNum() {
        return this.addElement;
    }

    public void setSplitWidth(int n) {
        this.append = n;
    }

    public int getSplitWidth() {
        return this.append;
    }

    public String getSplitText() {
        if (this.append == 0) {
            return this.QOIV.substring(this.addElement);
        }
        return this.QOIV.substring(this.addElement, this.append + this.addElement);
    }

    public int getTextWidth() {
        if (this.add == null) {
            return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(this.getText(), this.UTFLength, this.getWrapPostionUsePrecision));
        }
        return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(this.getText(), this.add, this.getWrapPostionUsePrecision));
    }

    public int getScriptTextH() {
        return Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.add, this.getWrapPostionUsePrecision)));
    }

    public int getTextHeight() {
        if (this.getWhiteSpaceNum == -1 && this.UTFLength != null) {
            this.getWhiteSpaceNum = Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.UTFLength, this.getWrapPostionUsePrecision)));
        }
        return this.getWhiteSpaceNum;
    }

    public int getTextHeightWhenScript() {
        return Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.UTFLength, this.getWrapPostionUsePrecision)));
    }

    public int getBeforeDecimalWidth() {
        if (this.add == null) {
            return Unit.convertPixelToUnit(ParagraphTools.getWidthBeforeFirstDecimalUsePrecision(this.getText(), this.UTFLength, this.getWrapPostionUsePrecision));
        }
        return Unit.convertPixelToUnit(ParagraphTools.getWidthBeforeFirstDecimalUsePrecision(this.getText(), this.add, this.getWrapPostionUsePrecision));
    }

    public int[] getWrapPostion(int n) {
        if (this.add == null) {
            return ParagraphTools.getWrapPostionUsePrecision(this.getText(), this.UTFLength, Unit.convertUnitToPixel(n), this.getWrapPostionUsePrecision);
        }
        return ParagraphTools.getWrapPostionUsePrecision(this.getText(), this.add, Unit.convertUnitToPixel(n), this.getWrapPostionUsePrecision);
    }

    public int getWrapPostion() {
        return ParagraphTools.lastBreakPos(0, this.getText().length(), this.getText());
    }

    private Font QOIV(int n) {
        Font font = FontSets.getFont("Arial", 1, n);
        return font;
    }

    public Font getTextFont() {
        return this.UTFLength;
    }

    public Font getScriptFont() {
        return this.add;
    }

    public int getBeforeWordWNum() {
        return ParagraphTools.getBeforeWordWNum(this.getText());
    }

    public int getAfterWordWNum() {
        return ParagraphTools.getAfterWordWNum(this.getText());
    }

    public int getWhiteSpaceNum() {
        return ParagraphTools.getWhiteSpaceNum(this.getText());
    }

    public int[] getWhiteSpaceWidth() {
        return this.clone;
    }

    public void setWhitSpaceWidth(int[] nArray) {
        this.clone = new int[nArray.length];
        this.clone = nArray;
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        int n2;
        super.readProperties(dataInput, dSDataStreamable);
        this.QOIV = dataInput.readUTF();
        this.addElement = dataInput.readInt();
        this.append = dataInput.readInt();
        this.convertUnitToPixel = dataInput.readBoolean();
        this.getAfterWordWNum = dataInput.readInt();
        this.getBeforeWordWNum = dataInput.readInt();
        this.getErrorWidth = dataInput.readInt();
        this.getFont = dataInput.readBoolean();
        this.getLeading = dataInput.readBoolean();
        if (dataInput.readBoolean() && (n2 = dataInput.readInt()) > 0) {
            this.clone = new int[n2];
            n = 0;
            while (n < n2) {
                this.clone[n] = dataInput.readInt();
                ++n;
            }
        }
        if ((n2 = dataInput.readInt()) > 0) {
            this.getTextBaseLineY = new int[n2];
            n = 0;
            while (n < n2) {
                this.getText.add(dataInput.readUTF());
                ++n;
            }
            int n3 = 0;
            while (n3 < n2) {
                this.getTextBaseLineY[n3] = dataInput.readInt();
                ++n3;
            }
        }
        this.getWhiteSpaceNum = dataInput.readInt();
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.QOIV);
        dataOutput.writeInt(this.addElement);
        dataOutput.writeInt(this.append);
        dataOutput.writeBoolean(this.convertUnitToPixel);
        dataOutput.writeInt(this.getAfterWordWNum);
        dataOutput.writeInt(this.getBeforeWordWNum);
        dataOutput.writeInt(this.getErrorWidth);
        dataOutput.writeBoolean(this.getFont);
        dataOutput.writeBoolean(this.getLeading);
        if (this.clone != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.clone.length);
            n = 0;
            while (n < this.clone.length) {
                dataOutput.writeInt(this.clone[n]);
                ++n;
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        n = this.getText.size();
        dataOutput.writeInt(n);
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                dataOutput.writeUTF((String)this.getText.elementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                dataOutput.writeInt(this.getTextBaseLineY[n3]);
                ++n3;
            }
        }
        dataOutput.writeInt(this.getWhiteSpaceNum);
    }

    protected int propLength() {
        int n = super.propLength();
        n += 2 + JRObjectResult.UTFLength(this.QOIV);
        n += 8;
        ++n;
        n += 4;
        n += 8;
        n += 2;
        if (this.clone != null) {
            ++n;
            n += (this.clone.length + 1) * 4;
        } else {
            ++n;
        }
        int n2 = this.getText.size();
        n += 4;
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                n += 2 + JRObjectResult.UTFLength((String)this.getText.elementAt(n3));
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                n += 4;
                ++n4;
            }
        }
        return n += 4;
    }

    public Object clone() {
        return this.dup(new DSParagraphText());
    }

    public DSParagraphText dup(DSParagraphText dSParagraphText) {
        super.dup(dSParagraphText);
        dSParagraphText.QOIV = this.QOIV;
        dSParagraphText.addElement = this.addElement;
        dSParagraphText.append = this.append;
        dSParagraphText.convertUnitToPixel = this.convertUnitToPixel;
        dSParagraphText.getAfterWordWNum = this.getAfterWordWNum;
        dSParagraphText.getBeforeWordWNum = this.getBeforeWordWNum;
        dSParagraphText.getErrorWidth = this.getErrorWidth;
        dSParagraphText.getLeading = this.getLeading;
        dSParagraphText.getFont = this.getFont;
        dSParagraphText.clone = this.clone == null ? null : (int[])this.clone.clone();
        dSParagraphText.getText = this.getText == null ? null : (Vector)this.getText.clone();
        dSParagraphText.getTextBaseLineY = this.getTextBaseLineY == null ? null : (int[])this.getTextBaseLineY.clone();
        dSParagraphText.getWhiteSpaceNum = this.getWhiteSpaceNum;
        return dSParagraphText;
    }

    public String getFormatText() {
        return this.getText();
    }

    public void setIsField(boolean bl) {
        this.convertPixelToUnit = bl;
    }

    public boolean getIsField() {
        return this.convertPixelToUnit;
    }

    public void setIsTab(boolean bl) {
        this.convertUnitToPixel = bl;
    }

    public boolean getIsTab() {
        return this.convertUnitToPixel;
    }

    public void setIsEnd(boolean bl) {
        this.dup = bl;
    }

    public boolean getIsEnd() {
        return this.dup;
    }

    public DbValue getDbValue() {
        return this.elementAt;
    }

    public void setDbValue(DbValue dbValue) {
        this.elementAt = dbValue;
    }

    public void setLineSpacing(int n) {
        this.getAfterWordWNum = n;
    }

    public int getLineSpacing() {
        return this.getAfterWordWNum;
    }

    public int getTextX() {
        return this.getBeforeWordWNum;
    }

    public int getTextY() {
        return this.getErrorWidth;
    }

    public int getTextBaseLineY() {
        if (this.getWidthBeforeFirstDecimalUsePrecision == -1) {
            this.getWidthBeforeFirstDecimalUsePrecision = (int)Unit.convertPixelToUnit(ParagraphTools.getTextBaseLineY(this.getText(), this.UTFLength));
        }
        return this.getWidthBeforeFirstDecimalUsePrecision;
    }

    public int getScriptBaseLineY() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getTextBaseLineY(this.getText(), this.add));
    }

    public int getTextLeading() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getLeading(this.getText(), this.UTFLength));
    }

    public int getScriptLeading() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getLeading(this.getText(), this.add));
    }

    public void setTextXY(int n, int n2) {
        this.getBeforeWordWNum = n;
        this.getErrorWidth = n2;
    }

    public void setScript(boolean bl, boolean bl2) {
        this.getFont = bl;
        this.getLeading = bl2;
    }

    public boolean getSuperscript() {
        return this.getFont;
    }

    public boolean getSubscript() {
        return this.getLeading;
    }

    public Vector getWords() {
        return this.getText;
    }

    public int[] getWordsPosition() {
        return this.getTextBaseLineY;
    }

    public void calculateJustifyWords() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = this.getText().length();
        Vector<String> vector = new Vector<String>();
        if (this.clone == null || this.clone.length == 0) {
            this.getText.add(this.getText());
            this.getTextBaseLineY = new int[1];
            this.getTextBaseLineY[0] = 0;
        } else {
            int n4;
            int n5;
            int n6;
            char[] cArray = this.getText().toCharArray();
            int n7 = 0;
            while (n7 < n3) {
                int n8;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray[n7]);
                n6 = n7;
                if (cArray[n7] == ' ') {
                    ++n7;
                    n8 = n6 + 1;
                    while (n8 < n3) {
                        if (cArray[n8] == ' ') {
                            if (!bl2) break;
                            stringBuffer.append(cArray[n8]);
                        } else {
                            stringBuffer.append(cArray[n8]);
                            n7 = n8 + 1;
                            bl2 = false;
                        }
                        ++n8;
                    }
                    vector.add(stringBuffer.toString());
                    continue;
                }
                bl2 = false;
                n8 = n6 + 1;
                while (n8 < n3) {
                    if (cArray[n8] == ' ') {
                        if (!bl2) {
                            n7 = n8;
                            break;
                        }
                    } else {
                        stringBuffer.append(cArray[n8]);
                        n7 = n8 + 1;
                        bl2 = false;
                    }
                    ++n8;
                }
                vector.add(stringBuffer.toString());
            }
            int n9 = vector.size();
            n6 = ParagraphTools.getErrorWidth(this.getText(), vector, this.add != null ? this.add : this.UTFLength);
            int[] nArray = new int[n9];
            int n10 = 0;
            while (n10 < n9) {
                int n11 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n10));
                n5 = 0;
                while (n5 < n11) {
                    if (n2 + 1 <= this.clone.length) {
                        n += this.clone[n2];
                    }
                    ++n2;
                    ++n5;
                }
                nArray[n10] = n;
                n = n + this.add((String)vector.elementAt(n10)) - n6;
                ++n10;
            }
            Vector<String> vector2 = new Vector<String>();
            n2 = 0;
            n5 = 0;
            while (n5 < n9) {
                int n12;
                int n13;
                n4 = 0;
                int n14 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                int n15 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n5));
                if (n5 == 0 && n15 > 0) {
                    n13 = 0;
                    while (n13 < n15) {
                        if (n2 + 1 <= this.clone.length) {
                            n4 += this.clone[n2];
                        }
                        ++n2;
                        ++n13;
                    }
                    n14 = Math.round(n4 / this.add(" "));
                    n12 = 0;
                    while (n12 < n14) {
                        stringBuffer.append(' ');
                        ++n12;
                    }
                    vector2.addElement(stringBuffer.toString());
                    if (n9 == 1) {
                        vector2.addElement((String)vector.elementAt(n5));
                    } else {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append((String)vector.elementAt(n5));
                        n15 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n5 + 1));
                        int n16 = 0;
                        while (n16 < n15) {
                            if (n2 + 1 <= this.clone.length) {
                                n4 += this.clone[n2];
                            }
                            ++n2;
                            ++n16;
                        }
                        n14 = Math.round(n4 / this.add(" ")) + 1;
                        int n17 = 0;
                        while (n17 < n14) {
                            stringBuffer.append(' ');
                            ++n17;
                        }
                        vector2.addElement(stringBuffer.toString());
                    }
                } else {
                    n4 = 0;
                    stringBuffer = new StringBuffer();
                    stringBuffer.append((String)vector.elementAt(n5));
                    if (n5 == n9 - 1) {
                        vector2.addElement(stringBuffer.toString());
                        break;
                    }
                    n15 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n5 + 1));
                    n13 = 0;
                    while (n13 < n15) {
                        if (n2 + 1 <= this.clone.length) {
                            n4 += this.clone[n2];
                        }
                        ++n2;
                        ++n13;
                    }
                    n14 = Math.round(n4 / this.add(" ")) + 1;
                    n12 = 0;
                    while (n12 < n14) {
                        stringBuffer.append(' ');
                        ++n12;
                    }
                    vector2.addElement(stringBuffer.toString());
                }
                ++n5;
            }
            if (vector2.size() > vector.size()) {
                this.getTextBaseLineY = new int[vector2.size()];
                this.getTextBaseLineY[0] = 0;
                n4 = 0;
                while (n4 < nArray.length) {
                    this.getTextBaseLineY[n4 + 1] = nArray[n4];
                    ++n4;
                }
                this.getText = (Vector)vector2.clone();
            } else {
                this.getTextBaseLineY = (int[])nArray.clone();
                this.getText = (Vector)vector2.clone();
            }
        }
    }

    private int add(String string) {
        if (this.add == null) {
            return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(string, this.UTFLength, this.getWrapPostionUsePrecision));
        }
        return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(string, this.add, this.getWrapPostionUsePrecision));
    }

    public void isHighPrecision(boolean bl) {
        this.getWrapPostionUsePrecision = bl;
    }

    public boolean getPrecision() {
        return this.getWrapPostionUsePrecision;
    }

    public int getQueryID() {
        return this.lastBreakPos;
    }

    public void setQueryID(int n) {
        this.lastBreakPos = n;
    }
}

