/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbBinary;
import jet.connect.DbChar;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.controls.JetImgProperty;
import jet.controls.JetUnitNumber;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSGroup;
import jet.datastream.DSPage;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubBody;
import jet.datastream.DSSubReport;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.JRVisiableResult;
import jet.datastream.PropertyMapTable;
import jet.datastream.PropertyValue;
import jet.datastream.RecordLocation;
import jet.util.Containable;
import jet.util.JFieldValueNLSManager;
import jet.util.Propertiable;
import jet.util.PropertySetable;
import jet.util.VersionControlable;

public class JRObjectResult
implements PropertySetable,
RecordLocation,
Cloneable {
    protected short modelIndex;
    protected byte flag;
    protected transient DSTemplatible template;
    transient Containable close;
    protected int linkedCommIdx = -1;
    protected int linkedPageIdx = -1;
    protected int linkedCondition = -1;
    protected boolean dirty;
    transient DSSection F = null;

    public short getTemplateIndex() {
        return this.modelIndex;
    }

    public void setTemplateIndex(short s) {
        this.modelIndex = s;
    }

    public DSTemplatible getTemplate() {
        return this.template;
    }

    public String getJetObjInstName() {
        return this.getTemplate().getInstName();
    }

    public void setTemplate(DSTemplatible dSTemplatible) {
        this.template = dSTemplatible;
    }

    public void setParent(Containable containable) {
        this.close = containable;
    }

    public Containable getParent() {
        return this.close;
    }

    public int getObjectType() {
        return this.template.getObjectType();
    }

    public final String getUDOName() {
        return (String)this.template.getPropertyByName("UDOName").getObject();
    }

    public final Hashtable getProperties() {
        return this.template.getProperties();
    }

    public Propertiable getPropertyByName(String string) {
        return this.getPropertyByName(string, null);
    }

    public boolean isChangeByF(Propertiable propertiable) {
        boolean bl = false;
        if (propertiable != null) {
            bl = propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
        }
        return bl;
    }

    public Propertiable getPropertyByName(String string, Record record) {
        Propertiable propertiable;
        block35: {
            propertiable = this.template.getPropertyByName(string);
            if (propertiable != null) {
                boolean bl = propertiable.isChangeByOther();
                boolean bl2 = propertiable.isChagneByFmtt();
                boolean bl3 = propertiable.isChangeByBL();
                if (bl || bl2 || bl3) {
                    boolean bl4 = false;
                    Object object = null;
                    object = bl2 ? propertiable.getUnifiedObject() : (bl ? propertiable.getObject() : propertiable.getChangeByBL());
                    try {
                        if (record == null) {
                            record = Thread.currentThread().getName().indexOf("paging") != -1 ? this.getSynRecord() : this.getRecord();
                        }
                        if (bl2 && record == null) {
                            return propertiable;
                        }
                        DbValue dbValue = null;
                        String string2 = object.toString().toUpperCase();
                        int n = 0;
                        if (this.F == null) {
                            this.F = this.getSection();
                        }
                        if (this.F != null) {
                            n = this.F.getObjectType();
                        }
                        if (n == 517 || n == 514 || n == 2564 || n == 2563) {
                            dbValue = this.getPagelevel(string2, n);
                        }
                        if (dbValue == null) {
                            dbValue = record.getCell(string2);
                        }
                        int n2 = 0;
                        if (propertiable instanceof PropertyValue) {
                            bl4 = true;
                            n2 = ((PropertyValue)propertiable).tag;
                        }
                        Propertiable propertiable2 = propertiable;
                        if ((propertiable = (Propertiable)propertiable.getClass().newInstance()) instanceof JetImgProperty) {
                            ((JetImgProperty)propertiable).setPath(((JetImgProperty)propertiable2).getPath());
                        }
                        if (bl4) {
                            ((PropertyValue)propertiable).tag = n2;
                        }
                        if (dbValue.isNull() && JRLog.isAd()) {
                            JRLog.print("Trace info\nproperty " + string + ", value " + string2 + " is null");
                        }
                        if (!dbValue.isNull() || string.equals("Format")) {
                            if (dbValue instanceof DbBinary) {
                                Image image;
                                block34: {
                                    byte[] byArray = ((DbBinary)dbValue).get();
                                    image = null;
                                    if (byArray != null) {
                                        image = Toolkit.getDefaultToolkit().createImage(byArray);
                                    }
                                    MediaTracker mediaTracker = new MediaTracker(new Canvas());
                                    mediaTracker.addImage(image, 0);
                                    try {
                                        mediaTracker.waitForID(0);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        if (!JRLog.isError(2)) break block34;
                                        JRLog.error(2, interruptedException);
                                    }
                                }
                                propertiable.setObject(image);
                            } else if (string.equals("X") || string.equals("Y") || string.equals("Width") || string.equals("Height")) {
                                propertiable.set(Integer.toString(Unit.convertInchToPixel(Double.valueOf(dbValue.toString()))));
                            } else if (bl2 && string.equalsIgnoreCase("FontSize")) {
                                if (bl4) {
                                    propertiable.set(dbValue.toString());
                                } else {
                                    ((JetUnitNumber)propertiable).setUnitValue(dbValue.toString());
                                }
                            } else if (dbValue instanceof DbChar && (string.equals("DisplayNull") || string.equals("Text"))) {
                                propertiable.set(this.get((DbChar)dbValue));
                            } else if (string.equals("TopLine") || string.equals("BottomLine") || string.equals("LeftLine") || string.equals("RightLine")) {
                                propertiable.setObject(new Integer(dbValue.toString()));
                            } else {
                                propertiable.set(dbValue.toString());
                            }
                        } else {
                            propertiable.setObject(propertiable2.getNormalObject());
                        }
                        propertiable.setChangeByObject(propertiable.getObject());
                        if (bl2) {
                            propertiable.setChangeByFmtt(propertiable.getObject());
                        } else if (bl3) {
                            propertiable.setChangeByBL(propertiable.getObject());
                        }
                    }
                    catch (Exception exception) {
                        if (!JRLog.isError(2)) break block35;
                        JRLog.error(2, exception);
                    }
                }
            }
        }
        return propertiable;
    }

    protected DbValue getPagelevel(String string, int n) {
        Containable containable = this.close;
        if (!(containable instanceof DSPage) && !(containable instanceof DSSubReport)) {
            containable = this.F.getParent();
        }
        if (n == 517 || n == 2564) {
            if (containable instanceof DSPage) {
                return (DbValue)((DSPage)containable).getFLevelValue(string);
            }
            if (containable instanceof DSSubReport) {
                return (DbValue)((DSSubReport)containable).getFLevelValue(string);
            }
        } else if (n == 514 || n == 2563) {
            if (containable instanceof DSPage) {
                return (DbValue)((DSPage)containable).getHLevelValue(string);
            }
            if (containable instanceof DSSubReport) {
                DbValue dbValue = (DbValue)((DSSubReport)containable).getHLevelValue(string);
                return dbValue;
            }
        }
        return null;
    }

    protected String get(DbChar dbChar) {
        return dbChar.toString();
    }

    public final Propertiable getProperty(short s) {
        return this.getPropertyByName(PropertyMapTable.getPropertyName(s));
    }

    public Record getSynRecord() {
        JRObjectResult jRObjectResult = this;
        Containable containable = null;
        while (jRObjectResult != null) {
            int n = jRObjectResult.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getSynRecord();
            }
            if ((n & 0x200) == 512 || (n & 0xA00) == 2560) {
                if (n != 517 && n != 514) {
                    jRObjectResult = this.validateDSSection((DSSection)jRObjectResult);
                    return ((DSSection)jRObjectResult).getSynRecord();
                }
                Containable containable2 = jRObjectResult.getParent();
                if (containable2 instanceof DSPage) {
                    DSBody dSBody = this.searchBodyInPage((DSPage)containable2);
                    return (JRecord)dSBody.getSynRecord();
                }
                DSSubBody dSSubBody = this.searchBodyInSubReport((DSSubReport)containable2);
                return (JRecord)dSSubBody.getSynRecord();
            }
            if ((n & 0x1000000) == 0x1000000) {
                return ((DSTableRow)jRObjectResult).getSynRecord();
            }
            if (n == 262177) {
                return ((DSBody)jRObjectResult).getSynRecord();
            }
            containable = jRObjectResult.getParent();
            if (!(containable instanceof JRObjectResult)) break;
            jRObjectResult = (JRObjectResult)((Object)containable);
        }
        return null;
    }

    protected DSBody searchBodyInPage(DSPage dSPage) {
        int n = dSPage.Z.size();
        int n2 = 0;
        while (n2 < n) {
            JRObjectResult jRObjectResult = (JRObjectResult)dSPage.Z.elementAt(n2);
            if (jRObjectResult.getObjectType() == 262177) {
                return (DSBody)jRObjectResult;
            }
            ++n2;
        }
        return null;
    }

    public JRecord getCalculateRecord() {
        JRObjectResult jRObjectResult = this;
        Containable containable = null;
        while (jRObjectResult != null) {
            int n = jRObjectResult.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getCalculateRecord();
            }
            if ((n & 0x200) == 512 || (n & 0xA00) == 2560) {
                jRObjectResult = this.validateDSSection((DSSection)jRObjectResult);
                return ((DSSection)jRObjectResult).getCalculateRecord();
            }
            if ((n & 0x1000000) == 0x1000000) {
                return ((DSTableRow)jRObjectResult).getCalculateRecord();
            }
            if (n == 262177) {
                return (JRecord)((DSBody)jRObjectResult).getSynRecord();
            }
            containable = jRObjectResult.getParent();
            if (!(containable instanceof JRObjectResult)) break;
            jRObjectResult = (JRObjectResult)((Object)containable);
        }
        return null;
    }

    public JRecord getRecord() {
        JRObjectResult jRObjectResult = this;
        Containable containable = null;
        while (jRObjectResult != null) {
            int n = jRObjectResult.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getRecord();
            }
            if ((n & 0x200) == 512 || (n & 0xA00) == 2560) {
                if (n != 517 && n != 514) {
                    jRObjectResult = this.validateDSSection((DSSection)jRObjectResult);
                    return ((DSSection)jRObjectResult).getRecord();
                }
                Containable containable2 = jRObjectResult.getParent();
                if (containable2 instanceof DSPage) {
                    DSBody dSBody = this.searchBodyInPage((DSPage)containable2);
                    return dSBody.getRecord();
                }
                DSSubBody dSSubBody = this.searchBodyInSubReport((DSSubReport)containable2);
                return dSSubBody.getRecord();
            }
            if ((n & 0x1000000) == 0x1000000) {
                return ((DSTableRow)jRObjectResult).getRecord();
            }
            if (n == 262177) {
                return ((DSBody)jRObjectResult).getRecord();
            }
            containable = jRObjectResult.getParent();
            if (!(containable instanceof JRObjectResult)) break;
            jRObjectResult = (JRObjectResult)((Object)containable);
        }
        return null;
    }

    protected DSSubBody searchBodyInSubReport(DSSubReport dSSubReport) {
        Vector vector = dSSubReport.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(n2);
            if (jRObjectResult.getObjectType() == 262182) {
                return (DSSubBody)jRObjectResult;
            }
            ++n2;
        }
        return null;
    }

    public int getResolution() {
        JRObjectResult jRObjectResult = this.addImage(this);
        if (jRObjectResult != null) {
            if (jRObjectResult instanceof DSSection) {
                this.F = (DSSection)jRObjectResult;
                return this.F.getResolution();
            }
            if (jRObjectResult.getObjectType() == 262177) {
                return ((DSBody)jRObjectResult).getDataStream().getCommunicator().getResolution();
            }
        }
        return Unit.getResolution();
    }

    public Communicator getCommunicator() {
        return ((JRObjectResult)((Object)this.getParent())).getCommunicator();
    }

    private JRObjectResult addImage(JRObjectResult jRObjectResult) {
        while (jRObjectResult != null) {
            if (jRObjectResult.getObjectType() == 262177) {
                return jRObjectResult;
            }
            if (jRObjectResult instanceof DSSection) {
                jRObjectResult = this.validateDSSection((DSSection)jRObjectResult);
                return jRObjectResult;
            }
            if (!(jRObjectResult instanceof JRObjectResult)) {
                return null;
            }
            jRObjectResult = (JRObjectResult)((Object)jRObjectResult.getParent());
        }
        return jRObjectResult;
    }

    protected DSSection validateDSSection(DSSection dSSection) {
        block7: {
            Vector vector;
            int n;
            block8: {
                Containable containable;
                block6: {
                    n = 0;
                    try {
                        n = (Integer)this.getPropertyByName("RecordLocation").getObject();
                    }
                    catch (Exception exception) {
                        if (!JRLog.isError(2)) break block6;
                        JRLog.error(2, exception);
                    }
                }
                if (n == 0 || (containable = dSSection.getParent()) == null || !(containable instanceof DSPage) && !(containable instanceof DSSubReport)) break block7;
                vector = containable.getChildren();
                if (n != 2) break block8;
                int n2 = vector.size() - 1;
                while (n2 >= 0) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(n2);
                    if (jRObjectResult.getObjectType() == 517 || jRObjectResult.getObjectType() == 2564) {
                        dSSection = (DSSection)vector.elementAt(n2);
                        break block7;
                    }
                    --n2;
                }
                break block7;
            }
            if (n != 1) break block7;
            int n3 = 0;
            while (n3 < vector.size()) {
                JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(n3);
                if (jRObjectResult.getObjectType() == 514) {
                    dSSection = (DSSection)jRObjectResult;
                    break;
                }
                ++n3;
            }
        }
        return dSSection;
    }

    public final DSSection getSection() {
        DSSection dSSection = null;
        Object object = this;
        while (object != null) {
            if (object instanceof DSSection) {
                dSSection = (DSSection)object;
                dSSection = this.validateDSSection(dSSection);
                break;
            }
            if (!((object = ((JRObjectResult)object).getParent()) instanceof JRObjectResult)) break;
        }
        return dSSection;
    }

    public final DSTableRow getTableRow() {
        DSTableRow dSTableRow = null;
        Object object = this;
        while (object != null) {
            if (object instanceof DSTableRow) {
                dSTableRow = (DSTableRow)object;
                break;
            }
            if (!((object = ((JRObjectResult)object).getParent()) instanceof JRObjectResult)) break;
        }
        return dSTableRow;
    }

    public final void read(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        if (this instanceof DSReference) {
            this.readProperties(dataInput, dSDataStreamable);
            return;
        }
        this.modelIndex = dataInput.readShort();
        this.template = dSDataStreamable.getTemplate(this.modelIndex);
        this.setNLSManager(dSDataStreamable.getNlsManager());
        this.flag = dataInput.readByte();
        if (this.template.isLinkable()) {
            if (dataInput instanceof VersionControlable) {
                int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
                if (n2 >= 131073 || n2 == 0) {
                    this.linkedCommIdx = dataInput.readInt();
                    this.linkedPageIdx = dataInput.readInt();
                }
                if (n2 >= 131081 || n2 == 0) {
                    this.linkedCondition = dataInput.readInt();
                }
            }
        } else if (this.template.getObjectType() == 41 && ((n = ((VersionControlable)((Object)dataInput)).getVersion()) >= 262416 || n == 0)) {
            this.linkedCommIdx = dataInput.readInt();
            this.linkedPageIdx = dataInput.readInt();
            this.linkedCondition = dataInput.readInt();
        }
        this.readProperties(dataInput, dSDataStreamable);
    }

    public void write(DataOutput dataOutput) throws IOException {
        Object object;
        this.beforeWrite();
        int n = this.getObjectType();
        dataOutput.writeInt(n);
        if (this instanceof DSReference) {
            this.writeProperties(dataOutput);
            return;
        }
        dataOutput.writeShort(this.modelIndex);
        dataOutput.writeByte(this.flag);
        if (this.template.isLinkable()) {
            dataOutput.writeInt(this.linkedCommIdx);
            dataOutput.writeInt(this.linkedPageIdx);
            dataOutput.writeInt(this.linkedCondition);
        } else if (this.template.getObjectType() == 41) {
            dataOutput.writeInt(this.linkedCommIdx);
            dataOutput.writeInt(this.linkedPageIdx);
            dataOutput.writeInt(this.linkedCondition);
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        Object object2 = null;
        if ((n & 0x1000) != 0) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object2 = new DataOutputStream(byteArrayOutputStream);
            object = dataOutput;
            dataOutput = object2;
            object2 = object;
        }
        this.writeProperties(dataOutput);
        if (object2 != null) {
            object = byteArrayOutputStream.toByteArray();
            object2.writeInt(((byte[])object).length);
            object2.write((byte[])object);
        }
    }

    protected int propLength() {
        int n;
        block4: {
            n = 0;
            if ((this.getObjectType() & 0x1000) != 0) {
                n = 4;
                if (!(this instanceof JRVisiableResult)) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        this.writeProperties(dataOutputStream);
                        n += byteArrayOutputStream.size();
                        byteArrayOutputStream.close();
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break block4;
                        JRLog.error(2, iOException);
                    }
                }
            }
        }
        return n;
    }

    int length() {
        int n = 4;
        if (this instanceof DSReference) {
            return n += this.propLength();
        }
        n += 3;
        if (this.template.isLinkable() || this.template.getObjectType() == 41) {
            n += 12;
        }
        return n += this.propLength();
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
    }

    protected void beforeWrite() {
    }

    public void dump(PrintStream printStream) {
    }

    public void setLink(int n, int n2, int n3) {
        this.linkedCommIdx = n;
        this.linkedPageIdx = n2;
        this.linkedCondition = n3;
    }

    public int getLinkCondition() {
        return this.linkedCondition;
    }

    public int getLinkPage() {
        return this.linkedPageIdx;
    }

    public int getLinkComm() {
        return this.linkedCommIdx;
    }

    public Object clone() {
        return this.dup(new JRObjectResult());
    }

    public JRObjectResult dup(JRObjectResult jRObjectResult) {
        jRObjectResult.modelIndex = this.modelIndex;
        jRObjectResult.flag = this.flag;
        jRObjectResult.template = this.template;
        jRObjectResult.close = this.close;
        jRObjectResult.linkedCommIdx = this.linkedCommIdx;
        jRObjectResult.linkedPageIdx = this.linkedPageIdx;
        jRObjectResult.linkedCondition = this.linkedCondition;
        return jRObjectResult;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static int UTFLength(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }

    public void setNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
    }
}

