/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.v7x;

import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import guitools.Painter;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.ExcelParameter;
import jet.datastream.CTGridInfo;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDBField;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterField;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableObject;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextObj;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.excel.ExcelCache;
import jet.export.excel.tool.PD;
import jet.export.excel.tool.PDTable;
import jet.export.excel.v7x.ColorIndex;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.udo.JRObjectRender;
import jet.udos.JHyperLinkRslt;
import jet.util.Containable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExportToXlsBiff8
extends AbstractExporter {
    public static final String EXP = ".xls";
    public static final int ALIGNLEFT = 0;
    public static final int ALIGNCENTER = 1;
    public static final int ALIGNRIGHT = 2;
    public static final int ALIGNJUSTIFY = 3;
    private Stack QOIV;
    private Vector TRUE;
    private Hashtable abs;
    private Hashtable add;
    private HSSFWorkbook addElement;
    private boolean adjustString;
    private boolean append = true;
    private boolean arraycopy = true;
    private int bgRect;
    private ExcelCache black;
    private boolean blue = false;
    private boolean booleanValue = false;
    private boolean canCacheWordWrap = true;
    private short checkFilePathExist = 0;
    private boolean checkOutputStream = false;
    private Hashtable checkStop = new Hashtable();
    private PDTable clear = new PDTable(256);
    private boolean close = true;
    private Hashtable contains = new Hashtable();
    private Hashtable containsKey = new Hashtable();
    private HSSFSheet convertUnitToInch;
    private int createCell = 1;
    private int createCellStyle = 0;
    private short[] createFont;
    private ColorIndex[] createRow = new ColorIndex[46];
    private Hashtable createSheet = new Hashtable();
    private int currentTimeMillis = 0;
    private PDTable cyan = new PDTable(256);

    public ExportToXlsBiff8(Communicator communicator, ExcelParameter excelParameter) {
        this._commu = communicator;
        int n = excelParameter.getWordWrapType();
        if (n == 0) {
            this.blue = true;
        } else if (n == 2) {
            this.booleanValue = true;
        }
        this.adjustString = JRLog.isError(2);
        this.black = new ExcelCache(false, null, "excel2000");
        this.black.setWordWrap(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this.checkFilePathExist(string);
        ArrayList<String> arrayList = null;
        FileOutputStream fileOutputStream = null;
        String string2 = !string.endsWith(EXP) ? string + EXP : string;
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.treatIOException(fileNotFoundException, string2, true);
        }
        try {
            this.exportToStream(fileOutputStream);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.treatIOException(iOException, string2, true);
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, string2, true);
        }
        arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            try {
                this.QOIV(bufferedOutputStream);
                bufferedOutputStream.flush();
            }
            catch (IOException iOException) {
                this.treatIOException(iOException, null, false);
                Object var5_4 = null;
                this.clear();
            }
            Object var5_3 = null;
            this.clear();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clear();
            throw throwable;
        }
    }

    private void clear() {
        this.addElement = null;
        if (this.black != null) {
            this.black.clear();
            this.black = null;
        }
        if (this.contains != null) {
            this.contains.clear();
            this.contains = null;
        }
        this.createRow = null;
        if (this.createSheet != null) {
            this.createSheet.clear();
            this.createSheet = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        if (this.checkStop != null) {
            this.checkStop.clear();
            this.checkStop = null;
        }
        this.createFont = null;
        if (this.containsKey != null) {
            this.containsKey.clear();
            this.containsKey = null;
        }
        if (this.TRUE != null) {
            this.TRUE.clear();
            this.TRUE = null;
        }
        if (this.add != null) {
            this.add.clear();
            this.add = null;
        }
        if (this.cyan != null) {
            this.cyan.clear();
            this.cyan = null;
        }
        if (this.abs != null) {
            this.abs.clear();
            this.abs = null;
        }
    }

    private void QOIV(BufferedOutputStream bufferedOutputStream) throws IOException, ExpException, JRStopEngineException {
        DSPage dSPage;
        long l;
        this.waitCommunicator();
        this.flush();
        this.bgRect = this._commu.getHeaderInfo(0).getRowsPerSheet();
        if (this.bgRect <= 0 || this.bgRect > 32000) {
            this.bgRect = 32000;
        }
        this.black.setPJFVersion(this._commu.getHeaderInfo(0).getPJFVersion());
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl = JRLog.isTrace(4);
        if (bl) {
            JRLog.indent("Export to excel 2000");
            l2 = System.currentTimeMillis();
            JRLog.trace(4, 4402201, new Timestamp(l2));
        }
        if (this.adjustString) {
            JRLog.indent("Export to excel 2000 error element");
        }
        this.TRUE = new Vector();
        this.QOIV = new Stack();
        this.abs = new Hashtable();
        this.add = new Hashtable();
        this.addElement = new HSSFWorkbook();
        this.QOIV.push(new Offset(0, 0));
        String string = this._commu.getEncoding();
        if (string == null || string.length() == 0) {
            string = "UTF-8";
        } else if (string.startsWith("GB") || "MS950".equals(string) || "Big5".equals(string)) {
            this.checkOutputStream = true;
            this.checkFilePathExist = 1;
        }
        CommEnumeration commEnumeration = new CommEnumeration(this._commu);
        while (commEnumeration.hasMoreElements()) {
            ExportUtil.checkStop(this._commu);
            l = System.currentTimeMillis();
            dSPage = (DSPage)commEnumeration.nextElement();
            l3 = System.currentTimeMillis();
            l4 = l4 + l3 - l;
            this._commu(dSPage);
        }
        this.TRUE();
        this.canCacheWordWrap = false;
        commEnumeration = new CommEnumeration(this._commu);
        while (commEnumeration.hasMoreElements()) {
            ExportUtil.checkStop(this._commu);
            l = System.currentTimeMillis();
            dSPage = (DSPage)commEnumeration.nextElement();
            l3 = System.currentTimeMillis();
            l4 = l4 + l3 - l;
            this._commu(dSPage);
            this.deIndent();
        }
        this.dy();
        this.addElement.write((OutputStream)bufferedOutputStream);
        if (this.adjustString) {
            JRLog.deIndent("Export to excel 2000 error element");
        }
        if (bl) {
            l = System.currentTimeMillis();
            JRLog.trace(4, 4402202, new Timestamp(l));
            JRLog.trace(4, 4402203, new Long(l - l2 - l4));
            JRLog.deIndent("Export to excel 2000");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the excel 2000");
        }
    }

    private void TRUE() {
        int n;
        int n2 = this.clear.size();
        if (n2 == 0) {
            return;
        }
        PD[] pDArray = new PD[n2];
        int n3 = 0;
        short s = 0;
        int n4 = 0;
        while (n4 < n2) {
            PD pD = this.clear.get(n4);
            n = 0;
            while (n < n3) {
                if (pD.getPoint() < pDArray[n].getPoint() || pD.getPoint() == pDArray[n].getPoint() && pD.getDimension() < pDArray[n].getDimension()) break;
                ++n;
            }
            System.arraycopy(pDArray, n, pDArray, n + 1, n3 - n);
            pDArray[n] = pD;
            ++n3;
            ++n4;
        }
        n = pDArray[0].getPoint() + pDArray[0].getDimension() / 3;
        int n5 = pDArray[0].getDimension();
        this.checkStop.put(pDArray[0], new Short(s));
        int n6 = 0;
        while (n6 < n3) {
            if (pDArray[n6].getPoint() < n) {
                this.checkStop.put(pDArray[n6], new Short(s));
                if (pDArray[n6].getDimension() < n5) {
                    n = pDArray[n6].getPoint() + pDArray[n6].getDimension() / 3;
                    n5 = pDArray[n6].getDimension();
                }
            } else {
                s = (short)(s + 1);
                this.checkStop.put(pDArray[n6], new Short(s));
                n = pDArray[n6].getPoint() + pDArray[n6].getDimension() / 3;
                n5 = pDArray[n6].getDimension();
            }
            ++n6;
        }
        this.createFont = new short[s + 1];
    }

    private void _commu(DSPage dSPage) {
        int n = dSPage.size();
        int n2 = 0;
        while (n2 < n) {
            this.adjustString(dSPage.getObject(n2), 0);
            ++n2;
        }
    }

    private void abs(DSSection dSSection, int n) {
        this.addElement(dSSection, n);
    }

    private void add(DSSubReport dSSubReport, int n) {
        this.addElement(dSSubReport, n);
    }

    private void addElement(DSContainer dSContainer, int n) {
        this.QOIV.push(new Offset((Offset)this.QOIV.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        int n2 = dSContainer.getStartYPos();
        List list = this.getColorPropertyByName(dSContainer.getChildren());
        int n3 = list.size();
        int n4 = 0;
        while (n4 < n3) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n4);
            this.adjustString(jRObjectResult, n2);
            ++n4;
        }
        this.QOIV.pop();
    }

    private void adjustString(JRObjectResult jRObjectResult, int n) {
        if (this.containsKey(jRObjectResult = this.getClass(jRObjectResult))) {
            int n2 = jRObjectResult.getObjectType();
            if ((n2 & 0x20) == 32) {
                switch (n2) {
                    case 33: 
                    case 37: 
                    case 45: {
                        this.add((DSSubReport)jRObjectResult, n);
                        break;
                    }
                    case 34: {
                        this.append((DSCrossTab)jRObjectResult, n);
                        break;
                    }
                    case 36: {
                        this.close((DSTextObj)jRObjectResult, n);
                        break;
                    }
                    case 262179: {
                        this.clear((DSTableObject)jRObjectResult, n);
                        break;
                    }
                    case 262178: {
                        this.checkOutputStream((DSParagraph)jRObjectResult, n);
                        break;
                    }
                    case 262183: {
                        this.bgRect((DSMultiValueContainer)jRObjectResult);
                        break;
                    }
                    default: {
                        this.addElement((DSContainer)jRObjectResult, n);
                        break;
                    }
                }
            } else if (n2 == 261 && ((DSField)jRObjectResult).getStartLine() == 0) {
                this.booleanValue((DSParameterField)jRObjectResult);
            } else if ((n2 & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() != -1) {
                this.contains((DSField)jRObjectResult, n);
            } else if ((n2 & 0x200) == 512) {
                this.abs((DSSection)jRObjectResult, n);
            } else if (n2 == 4096) {
                this.arraycopy((JRVisiableResult)jRObjectResult, n);
            } else if (jRObjectResult instanceof DSContainer) {
                this.addElement((DSContainer)jRObjectResult, n);
            } else if (JRLog.isAd()) {
                JRLog.print("Now, can not treat this DSObject, it is not a container! " + jRObjectResult + " type is : " + n2);
            }
        }
    }

    private void append(DSCrossTab dSCrossTab, int n) {
        this.addElement(dSCrossTab, n);
    }

    private void arraycopy(JRVisiableResult jRVisiableResult, int n) {
        try {
            JRObjectRender jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
            if (jRObjectRender != null) {
                jRObjectRender.setProperty(jRVisiableResult);
                if (jRVisiableResult instanceof JHyperLinkRslt) {
                    if (this.canCacheWordWrap) {
                        Offset offset = (Offset)this.QOIV.peek();
                        int n2 = jRVisiableResult.getX() + offset.dx;
                        this.clear.put(n2, jRVisiableResult.getWidth());
                    } else {
                        Offset offset = (Offset)this.QOIV.peek();
                        int n3 = jRVisiableResult.getX() + offset.dx;
                        int n4 = this.getY(jRVisiableResult, n) + offset.dy;
                        int n5 = jRVisiableResult.getWidth();
                        int n6 = jRVisiableResult.getHeight();
                        String string = (String)jRVisiableResult.getPropertyByName("displayValue").getObject();
                        if (string == null) {
                            string = "";
                        }
                        HSSFCellStyle hSSFCellStyle = this.createCellStyle(jRVisiableResult);
                        short s = (short)(Unit.convertUnitToInch((Integer)jRVisiableResult.getPropertyByName("fontSize").getObject()) * 72.0);
                        TxtBlock txtBlock = new TxtBlock(this, n3, n4, n5, n6, string, hSSFCellStyle, s);
                        this.TRUE.addElement(txtBlock);
                        Object object = this.getDimension(txtBlock);
                        if (this.abs.get(object) == null) {
                            this.abs.put(object, txtBlock);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            JRLog.error(2, exception);
        }
    }

    private void bgRect(DSMultiValueContainer dSMultiValueContainer) {
        Render render = dSMultiValueContainer.getRender();
        if (render instanceof RenderList) {
            String string = this.blue((RenderList)render);
            if (string != null) {
                this.checkFilePathExist(string, dSMultiValueContainer, true);
            }
        } else {
            String string = null;
            if (render instanceof RenderDropDownList) {
                string = this.black((RenderDropDownList)render);
            } else if (render instanceof RenderText) {
                string = render.getText();
            }
            if (string != null && string.length() != 0) {
                this.checkFilePathExist(string, dSMultiValueContainer, false);
            }
        }
    }

    private String black(RenderDropDownList renderDropDownList) {
        String string = null;
        String string2 = renderDropDownList.getSelectedTexts();
        Vector vector = renderDropDownList.getTexts();
        if (string2 != null && vector != null && vector.size() != 0) {
            string = vector.contains(string2) ? string2 : (String)vector.get(0);
        }
        return string;
    }

    private String blue(RenderList renderList) {
        int n;
        Vector vector = renderList.getSelectedText();
        Vector vector2 = renderList.getTexts();
        AbstractList abstractList = null;
        if (vector == null || vector.size() == 0) {
            abstractList = vector2;
        } else {
            abstractList = new ArrayList(vector.size());
            boolean bl = false;
            n = 0;
            while (n < vector.size()) {
                if (vector2.contains(vector.get(n))) {
                    bl = true;
                    abstractList.add(vector.get(n));
                }
                ++n;
            }
            if (!bl) {
                abstractList = vector2;
            }
        }
        String string = null;
        if (abstractList != null && abstractList.size() != 0) {
            string = (String)abstractList.get(0);
            n = 1;
            while (n < abstractList.size()) {
                string = string + "\n" + abstractList.get(n);
                ++n;
            }
        }
        return string;
    }

    private void booleanValue(DSParameterField dSParameterField) {
        Render render = dSParameterField.getRender();
        if (render != null) {
            if (this.canCacheWordWrap) {
                if (render instanceof RenderList || render instanceof RenderDropDownList || render instanceof RenderText) {
                    Offset offset = (Offset)this.QOIV.peek();
                    int n = dSParameterField.getX() + offset.dx;
                    this.clear.put(n, dSParameterField.getWidth());
                }
            } else if (render instanceof RenderList) {
                String string = this.blue((RenderList)render);
                if (string != null) {
                    this.canCacheWordWrap(string, dSParameterField, true);
                }
            } else {
                String string = null;
                if (render instanceof RenderDropDownList) {
                    string = this.black((RenderDropDownList)render);
                } else if (render instanceof RenderText) {
                    string = dSParameterField.toString();
                }
                if (string != null && string.length() > 0) {
                    this.canCacheWordWrap(string, dSParameterField, false);
                }
            }
        }
    }

    private void canCacheWordWrap(String string, DSParameterField dSParameterField, boolean bl) {
        HSSFCellStyle hSSFCellStyle;
        Offset offset = (Offset)this.QOIV.peek();
        int n = dSParameterField.getX() + offset.dx;
        int n2 = dSParameterField.getY() + offset.dy;
        int n3 = dSParameterField.getWidth();
        int n4 = dSParameterField.getHeight();
        String string2 = this.getHeight(dSParameterField, "FontFace");
        string2 = this.error(string2);
        short s = (short)(Unit.convertUnitToInch(this.getGridInfos(dSParameterField, "FontSize")) * 72.0);
        boolean bl2 = this.getExcelFontName(dSParameterField, "Bold");
        boolean bl3 = this.getExcelFontName(dSParameterField, "Italic");
        Color color = this.getEndLine(dSParameterField, "Foreground");
        Color color2 = this.currentTimeMillis(dSParameterField);
        String string3 = string2 + "*" + s + "*" + (bl2 ? "1" : "0") + (bl3 ? "1" : "0") + this.exportToStream(color, false);
        string3 = string3 + "*" + this.exportToStream(color2, true);
        if (this.add.isEmpty() || !this.add.containsKey(string3)) {
            HSSFFont hSSFFont = this.addElement.createFont();
            hSSFFont.setFontHeightInPoints(s);
            hSSFFont.setFontName(string2);
            hSSFFont.setItalic(bl3);
            hSSFFont.setBoldweight(bl2 ? (short)700 : 190);
            hSSFFont.setColor(this.exportToStream(color, false));
            hSSFCellStyle = this.addElement.createCellStyle();
            hSSFCellStyle.setFillForegroundColor(this.exportToStream(color2, true));
            if (color2 != null) {
                hSSFCellStyle.setFillPattern((short)1);
            }
            if (bl) {
                hSSFCellStyle.setWrapText(this.getChildren(true));
            }
            hSSFCellStyle.setFont(hSSFFont);
            this.add.put(string3, hSSFCellStyle);
        } else {
            hSSFCellStyle = (HSSFCellStyle)this.add.get(string3);
        }
        TxtBlock txtBlock = new TxtBlock(this, n, n2, n3, n4, string, hSSFCellStyle, s);
        this.TRUE.addElement(txtBlock);
        Object object = this.getDimension(txtBlock);
        if (this.abs.get(object) == null) {
            this.abs.put(object, txtBlock);
        }
    }

    private void checkFilePathExist(String string, DSMultiValueContainer dSMultiValueContainer, boolean bl) {
        if (this.canCacheWordWrap) {
            Offset offset = (Offset)this.QOIV.peek();
            int n = dSMultiValueContainer.getX() + offset.dx;
            this.clear.put(n, dSMultiValueContainer.getWidth());
        } else {
            HSSFCellStyle hSSFCellStyle;
            Offset offset = (Offset)this.QOIV.peek();
            int n = dSMultiValueContainer.getX() + offset.dx;
            int n2 = dSMultiValueContainer.getY() + offset.dy;
            int n3 = dSMultiValueContainer.getWidth();
            int n4 = dSMultiValueContainer.getHeight();
            String string2 = this.getHeight(dSMultiValueContainer, "FontFace");
            string2 = this.error(string2);
            short s = (short)(Unit.convertUnitToInch(this.getGridInfos(dSMultiValueContainer, "FontSize")) * 72.0);
            boolean bl2 = this.getExcelFontName(dSMultiValueContainer, "Bold");
            boolean bl3 = this.getExcelFontName(dSMultiValueContainer, "Italic");
            Color color = Color.black;
            Color color2 = this.getEndLine(dSMultiValueContainer, "Background");
            String string3 = string2 + "*" + s + "*" + (bl2 ? "1" : "0") + (bl3 ? "1" : "0") + this.exportToStream(color, false);
            if (!this.add.containsKey(string3 = string3 + "*" + this.exportToStream(color2, true))) {
                HSSFFont hSSFFont = this.addElement.createFont();
                hSSFFont.setFontHeightInPoints(s);
                hSSFFont.setFontName(string2);
                hSSFFont.setItalic(bl3);
                hSSFFont.setBoldweight(bl2 ? (short)700 : 190);
                hSSFFont.setColor(this.exportToStream(color, false));
                hSSFCellStyle = this.addElement.createCellStyle();
                hSSFCellStyle.setFillForegroundColor(this.exportToStream(color2, true));
                if (color2 != null) {
                    hSSFCellStyle.setFillPattern((short)1);
                }
                if (bl) {
                    hSSFCellStyle.setWrapText(this.getChildren(true));
                }
                hSSFCellStyle.setFont(hSSFFont);
                this.add.put(string3, hSSFCellStyle);
            } else {
                hSSFCellStyle = (HSSFCellStyle)this.add.get(string3);
            }
            TxtBlock txtBlock = new TxtBlock(this, n, n2, n3, n4, string, hSSFCellStyle, s);
            this.TRUE.addElement(txtBlock);
            Object object = this.getDimension(txtBlock);
            if (this.abs.get(object) == null) {
                this.abs.put(object, txtBlock);
            }
        }
    }

    private void checkOutputStream(DSParagraph dSParagraph, int n) {
        if (this.append) {
            List list = this.getColorPropertyByName(dSParagraph.getChildren());
            int n2 = list.size();
            String string = "";
            ArrayList<DSParagraphText> arrayList = new ArrayList<DSParagraphText>(2);
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    JRObjectResult jRObjectResult = (JRObjectResult)list.get(n3);
                    if (this.containsKey(jRObjectResult)) {
                        String string2;
                        JRVisiableResult jRVisiableResult;
                        if (jRObjectResult instanceof DSParagraphText) {
                            jRVisiableResult = (DSParagraphText)jRObjectResult;
                            string2 = jRVisiableResult.getText();
                            if (string2 != null) {
                                string = string + string2;
                            }
                        } else if (jRObjectResult instanceof DSField) {
                            jRVisiableResult = (DSField)jRObjectResult;
                            if (this.getFontStyle(jRVisiableResult, "position") == 3) {
                                arrayList.add((DSParagraphText)jRVisiableResult);
                            } else if (((DSField)jRObjectResult).getRender() instanceof RenderText && (string2 = jRObjectResult.toString()) != null) {
                                string = string + string2;
                            }
                        }
                    }
                    ++n3;
                }
            }
            if (string.length() != 0) {
                if (this.canCacheWordWrap) {
                    Offset offset = (Offset)this.QOIV.peek();
                    int n4 = dSParagraph.getX() + offset.dx;
                    this.clear.put(n4, dSParagraph.getWidth());
                } else {
                    Offset offset = (Offset)this.QOIV.peek();
                    int n5 = dSParagraph.getX() + offset.dx;
                    int n6 = this.getY(dSParagraph, n) + offset.dy;
                    int n7 = dSParagraph.getWidth();
                    int n8 = dSParagraph.getHeight();
                    this.checkStop(n5, n6, n7, n8, string, dSParagraph);
                }
            }
            if (arrayList.size() != 0) {
                this.QOIV.push(new Offset((Offset)this.QOIV.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                int n9 = dSParagraph.getStartYPos();
                int n10 = 0;
                while (n10 < arrayList.size()) {
                    this.adjustString((DSField)arrayList.get(n10), n9);
                    ++n10;
                }
                this.QOIV.pop();
            }
        } else {
            this.QOIV.push(new Offset((Offset)this.QOIV.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
            List list = this.getColorPropertyByName(dSParagraph.getChildren());
            int n11 = dSParagraph.getStartYPos();
            int n12 = list.size();
            int n13 = 0;
            while (n13 < n12) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(n13);
                if (this.containsKey(jRObjectResult)) {
                    if (jRObjectResult instanceof DSParagraphText) {
                        DSParagraphText dSParagraphText = (DSParagraphText)jRObjectResult;
                        String string = dSParagraphText.getText();
                        if (string != null && string.length() > 0) {
                            Offset offset = (Offset)this.QOIV.peek();
                            int n14 = dSParagraphText.getX() + offset.dx;
                            int n15 = this.getY(dSParagraphText, n11) + offset.dy;
                            int n16 = dSParagraphText.getWidth();
                            int n17 = dSParagraphText.getHeight();
                            this.convertUnitToInch(n14, n15, n16, n17, string, dSParagraphText);
                        }
                    } else {
                        this.adjustString(jRObjectResult, n11);
                    }
                }
                ++n13;
            }
            this.QOIV.pop();
        }
    }

    private void checkStop(int n, int n2, int n3, int n4, String string, DSParagraph dSParagraph) {
        HSSFCellStyle hSSFCellStyle;
        String string2 = this.getHeight(dSParagraph, "FontFace");
        string2 = this.error(string2);
        short s = (short)(Unit.convertUnitToInch(this.getGridInfos(dSParagraph, "FontSize")) * 72.0);
        boolean bl = this.getExcelFontName(dSParagraph, "Bold");
        boolean bl2 = this.getExcelFontName(dSParagraph, "Italic");
        Color color = this.getEndLine(dSParagraph, "Foreground");
        Color color2 = this.getEndLine(dSParagraph, "Background");
        String string3 = string2 + "*" + s + "*" + (bl ? "1" : "0") + (bl2 ? "1" : "0") + this.exportToStream(color, false);
        if (!this.add.containsKey(string3 = string3 + "*" + this.exportToStream(color2, true))) {
            HSSFFont hSSFFont = this.addElement.createFont();
            hSSFFont.setFontHeightInPoints(s);
            hSSFFont.setFontName(string2);
            hSSFFont.setItalic(bl2);
            hSSFFont.setBoldweight(bl ? (short)700 : 190);
            hSSFFont.setColor(this.exportToStream(color, false));
            hSSFCellStyle = this.addElement.createCellStyle();
            hSSFCellStyle.setFillForegroundColor(this.exportToStream(color2, true));
            if (color2 != null) {
                hSSFCellStyle.setFillPattern((short)1);
            }
            hSSFCellStyle.setWrapText(this.getChildren(true));
            hSSFCellStyle.setFont(hSSFFont);
            this.add.put(string3, hSSFCellStyle);
        } else {
            hSSFCellStyle = (HSSFCellStyle)this.add.get(string3);
        }
        TxtBlock txtBlock = new TxtBlock(this, n, n2, n3, n4, string, hSSFCellStyle, s);
        this.TRUE.addElement(txtBlock);
        Object object = this.getDimension(txtBlock);
        if (this.abs.get(object) == null) {
            this.abs.put(object, txtBlock);
        }
    }

    private void clear(DSTableObject dSTableObject, int n) {
        this.addElement(dSTableObject, n);
    }

    private void close(DSTextObj dSTextObj, int n) {
        if (this.arraycopy) {
            DSField dSField = null;
            String string = "";
            Vector vector = dSTextObj.getChildren();
            int n2 = vector.size();
            if (n2 > 0) {
                if (this.canCacheWordWrap) {
                    Offset offset = (Offset)this.QOIV.peek();
                    int n3 = dSTextObj.getX() + offset.dx;
                    this.clear.put(n3, dSTextObj.getWidth());
                } else {
                    int n4 = 0;
                    while (n4 < n2) {
                        boolean bl;
                        JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n4);
                        int n5 = jRObjectResult.getObjectType();
                        boolean bl2 = bl = !this.getExcelBorderStyle(jRObjectResult, "Invisible");
                        if (bl && (n5 & 0x100) == 256) {
                            DSField dSField2 = (DSField)jRObjectResult;
                            if (dSField == null || dSField instanceof DSDBField) {
                                dSField = dSField2;
                            }
                            string = string + dSField2.toString();
                        }
                        ++n4;
                    }
                    if (string.length() > 0) {
                        Offset offset = (Offset)this.QOIV.peek();
                        int n6 = dSTextObj.getX() + offset.dx;
                        int n7 = this.getY(dSTextObj, n) + offset.dy;
                        int n8 = dSTextObj.getWidth();
                        int n9 = dSTextObj.getHeight();
                        this.createFont(n6, n7, n8, n9, string, dSField);
                    }
                }
            }
        } else {
            this.addElement(dSTextObj, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void contains(DSField dSField, int n) {
        int n2;
        int n3;
        int n4;
        if (!this.black.isTextField(dSField)) return;
        if (this.canCacheWordWrap) {
            Offset offset = (Offset)this.QOIV.peek();
            int n5 = dSField.getX() + offset.dx;
            this.clear.put(n5, dSField.getWidth());
            return;
        }
        String string = dSField.toString();
        if (string == null) return;
        int[][] nArray = dSField.getLineBreakPos();
        if (nArray != null) {
            string = Painter.adjustString(string);
            n4 = dSField.getObjectType();
            if (n4 == 257) {
                n3 = dSField.getStartLine();
                if (n3 < 0) return;
                if (n3 >= nArray.length) return;
                n2 = dSField.getEndLine();
                if (n2 >= 0) {
                    n2 = Math.min(nArray.length - 1, n2) < 0 ? 0 : Math.min(nArray.length - 1, n2);
                    string = string.substring(nArray[n3][0], nArray[n2][0] + nArray[n2][1]);
                }
            } else if (string.length() > 50) {
                n3 = dSField.getStartLine();
                n2 = dSField.getEndLine();
                if (n2 < 0) {
                    JRLog.error(2, 2405109, new Object[]{new Integer(string.length()), new Integer(n2)});
                    return;
                }
                n2 = Math.min(nArray.length - 1, n2) < 0 ? 0 : Math.min(nArray.length - 1, n2);
                string = string.substring(nArray[n3][0], nArray[n2][0] + nArray[n2][1]);
            } else if (dSField.getStartLine() > 0) {
                return;
            }
        }
        Offset offset = (Offset)this.QOIV.peek();
        n4 = dSField.getX() + offset.dx;
        n3 = this.getY(dSField, n) + offset.dy;
        n2 = dSField.getWidth();
        int n6 = dSField.getHeight();
        this.createFont(n4, n3, n2, n6, string, dSField);
    }

    private boolean containsKey(JRObjectResult jRObjectResult) {
        boolean bl = this.black.isExport(jRObjectResult);
        if (bl) {
            switch (jRObjectResult.getObjectType()) {
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 71: 
                case 128: 
                case 129: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private void convertUnitToInch(int n, int n2, int n3, int n4, String string, DSParagraphText dSParagraphText) {
        HSSFCellStyle hSSFCellStyle;
        String string2 = this.getHeight(dSParagraphText, "FontFace");
        string2 = this.error(string2);
        short s = (short)(Unit.convertUnitToInch(this.getGridInfos(dSParagraphText, "FontSize")) * 72.0);
        boolean bl = this.getExcelFontName(dSParagraphText, "Bold");
        boolean bl2 = this.getExcelFontName(dSParagraphText, "Italic");
        Color color = this.getEndLine(dSParagraphText, "Foreground");
        Color color2 = this.getEndLine(dSParagraphText, "Background");
        String string3 = string2 + "*" + s + "*" + (bl ? "1" : "0") + (bl2 ? "1" : "0") + this.exportToStream(color, false);
        string3 = string3 + "*" + this.exportToStream(color2, true);
        if (this.add.isEmpty() || !this.add.containsKey(string3)) {
            HSSFFont hSSFFont = this.addElement.createFont();
            hSSFFont.setFontHeightInPoints(s);
            hSSFFont.setFontName(string2);
            hSSFFont.setItalic(bl2);
            hSSFFont.setBoldweight(bl ? (short)700 : 190);
            hSSFFont.setColor(this.exportToStream(color, false));
            hSSFCellStyle = this.addElement.createCellStyle();
            hSSFCellStyle.setFillForegroundColor(this.exportToStream(color2, true));
            if (color2 != null) {
                hSSFCellStyle.setFillPattern((short)1);
            }
            hSSFCellStyle.setFont(hSSFFont);
            this.add.put(string3, hSSFCellStyle);
        } else {
            hSSFCellStyle = (HSSFCellStyle)this.add.get(string3);
        }
        TxtBlock txtBlock = new TxtBlock(this, n, n2, n3, n4, string, hSSFCellStyle, s);
        this.TRUE.addElement(txtBlock);
        Object object = this.getDimension(txtBlock);
        if (this.abs.get(object) == null) {
            this.abs.put(object, txtBlock);
        }
    }

    private HSSFCellStyle createCell(DSField dSField) {
        Color color;
        short s;
        int n;
        Object object;
        Object object2;
        DSTemplatible dSTemplatible = dSField.getTemplate();
        HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)this.add.get(dSTemplatible);
        if (hSSFCellStyle != null) {
            return hSSFCellStyle;
        }
        HSSFFont hSSFFont = (HSSFFont)this.containsKey.get(dSTemplatible);
        boolean bl = true;
        if (hSSFFont == null) {
            if (this.contains.containsKey(dSTemplatible)) {
                bl = false;
            }
            object2 = this.getHeaderInfo(dSField, "FontFace");
            if (bl) {
                bl = !CCUtil.isChangeByFormularProperty(dSField, "FontFace");
            }
            object = this.black.getExcelFontName((String)object2);
            short s2 = (short)(Unit.convertUnitToInch(this.getFontStyle(dSField, "FontSize")) * 72.0);
            hSSFFont = this.addElement.createFont();
            hSSFFont.setFontHeightInPoints(s2);
            hSSFFont.setFontName((String)object);
            n = this.black.getFontStyle((String)object2);
            if (n != -1) {
                if ((n & 1) == 1) {
                    hSSFFont.setBoldweight((short)700);
                } else {
                    hSSFFont.setBoldweight((short)190);
                }
                if ((n & 2) == 2) {
                    hSSFFont.setItalic(true);
                } else {
                    hSSFFont.setItalic(false);
                }
            } else {
                n = 0;
                boolean color2 = this.getExcelBorderStyle(dSField, "Bold");
                s = this.getExcelBorderStyle(dSField, "Italic") ? 1 : 0;
                if (bl) {
                    boolean bl2 = bl = !CCUtil.isChangeByFormularProperty(dSField, "Bold");
                    if (bl) {
                        bl = !CCUtil.isChangeByFormularProperty(dSField, "Italic");
                    }
                }
                hSSFFont.setItalic(s != 0);
                hSSFFont.setBoldweight(color2 ? (short)700 : 190);
            }
            color = this.getEncoding(dSField, "Foreground");
            hSSFFont.setColor(this.fillColor(color));
            if (bl) {
                boolean bl3 = bl = !CCUtil.isChangeByFormularProperty(dSField, "Foreground");
            }
            if (bl) {
                this.containsKey.put(dSTemplatible, hSSFFont);
            } else {
                this.contains.put(dSTemplatible, Boolean.TRUE);
            }
        } else {
            bl = false;
        }
        object2 = this.currentTimeMillis(dSField);
        if (bl) {
            bl = !CCUtil.isChangeByFormularProperty(dSField, "Background");
        }
        object = this.addElement.createCellStyle();
        object.setFillForegroundColor(this.fillColor((Color)object2));
        if (object2 != null) {
            object.setFillPattern((short)1);
        }
        object.setWrapText(this.black.getWordWrap(dSField));
        if (bl) {
            bl = this.black.canCacheWordWrap(dSField);
        }
        int n2 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        n = CCUtil.getIntPropertyByName(dSField, "VerticalAlignment");
        this.createSheet((HSSFCellStyle)object, n2);
        this.createRow((HSSFCellStyle)object, n);
        color = this.getEncoding(dSField, "BorderColor");
        s = this.exportToStream(color, false);
        object.setTopBorderColor(s);
        object.setBottomBorderColor(s);
        object.setLeftBorderColor(s);
        object.setRightBorderColor(s);
        if (bl) {
            bl = !CCUtil.isChangeByFormularProperty(dSField, "BorderColor");
        }
        short[] sArray = this.black.getExcelBorderStyle(dSField);
        object.setBorderTop(sArray[0]);
        object.setBorderBottom(sArray[2]);
        object.setBorderLeft(sArray[1]);
        object.setBorderRight(sArray[3]);
        object.setFont(hSSFFont);
        if (bl) {
            this.add.put(dSTemplatible, object);
        }
        return object;
    }

    private HSSFCellStyle createCellStyle(JRVisiableResult jRVisiableResult) {
        HSSFCellStyle hSSFCellStyle;
        String string = (String)jRVisiableResult.getPropertyByName("fontFace").getObject();
        int n = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        int n2 = CCUtil.getIntPropertyByName(jRVisiableResult, "VerticalAlignment");
        Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
        boolean bl = this.getExcelBorderStyle(jRVisiableResult, "wordWrap");
        boolean bl2 = (Boolean)jRVisiableResult.getPropertyByName("fontBold").getObject();
        boolean bl3 = (Boolean)jRVisiableResult.getPropertyByName("fontItalic").getObject();
        short s = (short)(Unit.convertUnitToInch((Integer)jRVisiableResult.getPropertyByName("fontSize").getObject()) * 72.0);
        String string2 = string.trim() + "*" + s + "*" + (bl2 ? "1" : "0") + (bl3 ? "1" : "0") + (bl ? "1" : "0") + n + " " + n2 + this.exportToStream(color, false);
        if (!this.add.containsKey(string2)) {
            Color color2 = (Color)jRVisiableResult.getPropertyByName("background").getObject();
            HSSFFont hSSFFont = this.addElement.createFont();
            hSSFFont.setFontHeightInPoints(s);
            hSSFFont.setFontName(string);
            hSSFFont.setItalic(bl3);
            hSSFFont.setBoldweight(bl2 ? (short)700 : 190);
            hSSFFont.setColor(this.exportToStream(color, false));
            hSSFCellStyle = this.addElement.createCellStyle();
            hSSFCellStyle.setFillForegroundColor(this.exportToStream(color2, true));
            if (color2 != null) {
                hSSFCellStyle.setFillPattern((short)1);
            }
            hSSFCellStyle.setWrapText(this.getChildren(bl));
            this.createSheet(hSSFCellStyle, n);
            this.createRow(hSSFCellStyle, n);
            hSSFCellStyle.setFont(hSSFFont);
            this.add.put(string2, hSSFCellStyle);
        } else {
            hSSFCellStyle = (HSSFCellStyle)this.add.get(string2);
        }
        return hSSFCellStyle;
    }

    private void createFont(int n, int n2, int n3, int n4, String string, DSField dSField) {
        HSSFCellStyle hSSFCellStyle = this.createCell(dSField);
        short s = (short)(Unit.convertUnitToInch(this.getFontStyle(dSField, "FontSize")) * 72.0);
        int n5 = 1111;
        n5 = this.darkGray(n5);
        TxtBlock txtBlock = new TxtBlock(this, n, n2, n3, n4, string, hSSFCellStyle, s);
        this.TRUE.add(txtBlock);
        Object object = this.getDimension(txtBlock);
        if (this.abs.get(object) == null) {
            this.abs.put(object, txtBlock);
        }
    }

    private void createRow(HSSFCellStyle hSSFCellStyle, int n) {
        switch (n) {
            case 1: {
                hSSFCellStyle.setVerticalAlignment((short)0);
                break;
            }
            case 2: {
                hSSFCellStyle.setVerticalAlignment((short)2);
                break;
            }
            case 0: {
                hSSFCellStyle.setVerticalAlignment((short)1);
                break;
            }
            default: {
                hSSFCellStyle.setVerticalAlignment((short)3);
            }
        }
    }

    private void createSheet(HSSFCellStyle hSSFCellStyle, int n) {
        switch (n) {
            case 0: {
                hSSFCellStyle.setAlignment((short)1);
                break;
            }
            case 1: {
                hSSFCellStyle.setAlignment((short)3);
                break;
            }
            case 2: {
                hSSFCellStyle.setAlignment((short)2);
                break;
            }
            default: {
                hSSFCellStyle.setAlignment((short)5);
            }
        }
    }

    private Color currentTimeMillis(DSField dSField) {
        Color color = null;
        color = this.getEncoding(dSField, "Background");
        if (color == null) {
            if (((JRObjectResult)((Object)dSField.getParent())).getObjectType() == 34) {
                DSCrossTab dSCrossTab = (DSCrossTab)dSField.getParent();
                Vector vector = dSCrossTab.getGridInfos();
                boolean bl = false;
                int n = 0;
                while (n < vector.size()) {
                    List list = (List)vector.get(n);
                    int n2 = 0;
                    while (n2 < list.size()) {
                        CTGridInfo cTGridInfo = (CTGridInfo)list.get(n2);
                        if (cTGridInfo.bgRect.contains(dSField.getX(), dSField.getY())) {
                            if (cTGridInfo.fillColor != null) {
                                color = cTGridInfo.fillColor;
                            }
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) break;
                    ++n;
                }
                if (color == null) {
                    color = this.cyan(dSField);
                }
            } else {
                color = this.cyan(dSField);
            }
        }
        return color;
    }

    private Color cyan(JRVisiableResult jRVisiableResult) {
        Containable containable;
        DSContainer dSContainer;
        Containable containable2;
        Color color = null;
        if (jRVisiableResult.getParent() != null && (containable2 = jRVisiableResult.getParent()) instanceof DSContainer && (color = this.getEncoding(dSContainer = (DSContainer)containable2, "Background")) == null && dSContainer.getParent() != null && (containable = dSContainer.getParent()) instanceof DSContainer) {
            color = this.getEncoding((JRObjectResult)((Object)containable), "Background");
        }
        return color;
    }

    private int darkGray(int n) {
        int n2 = 1;
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 0;
                break;
            }
            case -7: {
                n2 = 4;
                break;
            }
        }
        return n2;
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n4 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n3 = (n2 = n4) > 0 ? n2 : 0;
        }
        return n3;
    }

    private void deIndent() {
        List list;
        int n;
        int n2 = this.abs.size();
        if (n2 == 0) {
            return;
        }
        if (this.close) {
            this.addElement.createCellStyle();
            this.close = false;
        }
        TxtBlock[] txtBlockArray = new TxtBlock[n2];
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = this.abs.elements();
        while (enumeration.hasMoreElements()) {
            TxtBlock txtBlock = (TxtBlock)enumeration.nextElement();
            n = 0;
            while (n < n3) {
                if (txtBlock.y < txtBlockArray[n].y || txtBlock.y == txtBlockArray[n].y && txtBlock.Z < txtBlockArray[n].Z) break;
                ++n;
            }
            System.arraycopy(txtBlockArray, n, txtBlockArray, n + 1, n3 - n);
            txtBlockArray[n] = txtBlock;
            ++n3;
        }
        n = txtBlockArray[0].y + txtBlockArray[0].Z / 2;
        int n5 = txtBlockArray[0].Z;
        this.abs.put(this.getDimension(txtBlockArray[0]), new Integer(n4));
        int n6 = 0;
        while (n6 < n3) {
            if (txtBlockArray[n6].y < n) {
                this.abs.put(this.getDimension(txtBlockArray[n6]), new Integer(n4));
                if (txtBlockArray[n6].Z < n5) {
                    n = txtBlockArray[n6].y + txtBlockArray[n6].Z / 2;
                    n5 = txtBlockArray[n6].Z;
                }
            } else {
                this.abs.put(this.getDimension(txtBlockArray[n6]), new Integer(++n4));
                n = txtBlockArray[n6].y + txtBlockArray[n6].Z / 2;
                n5 = txtBlockArray[n6].Z;
            }
            ++n6;
        }
        ArrayList arrayList = new ArrayList();
        int n7 = 0;
        while (n7 <= n4) {
            arrayList.add(new Vector());
            ++n7;
        }
        n3 = this.TRUE.size();
        TxtBlock txtBlock = null;
        int n8 = 0;
        while (n8 < n3) {
            txtBlock = (TxtBlock)this.TRUE.get(n8);
            n4 = (Integer)this.abs.get(this.getDimension(txtBlock));
            list = (Vector)arrayList.get(n4);
            list.add(txtBlock);
            ++n8;
        }
        this.abs.clear();
        int n9 = arrayList.size();
        if (this.convertUnitToInch == null) {
            this.dx();
        } else if (this.createCellStyle + n9 + 1 >= this.bgRect) {
            this.dy();
            this.dx();
        }
        int n10 = 0;
        while (n10 < n9) {
            list = (List)arrayList.get(n10);
            if (!list.isEmpty()) {
                HSSFRow hSSFRow = this.convertUnitToInch.createRow((short)(n10 + this.createCellStyle));
                int n11 = 0;
                while (n11 < list.size()) {
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    TxtBlock txtBlock2 = (TxtBlock)list.get(n11);
                    short s = (Short)this.checkStop.get(this.clear.getPD(txtBlock2.x, txtBlock2.I));
                    HSSFCell hSSFCell = hSSFRow.createCell(s);
                    if (this.checkOutputStream) {
                        hSSFCell.setEncoding(this.checkFilePathExist);
                    }
                    this.endsWith(hSSFCell, txtBlock2);
                    hSSFCell.setCellStyle(txtBlock2.D);
                    if (txtBlock2.C.indexOf("\n") == -1) {
                        n16 = txtBlock2.C.length();
                    } else {
                        String string = txtBlock2.C;
                        n15 = 0;
                        n16 = 0;
                        while ((n14 = string.indexOf("\n", n15)) != -1) {
                            if (n14 - n15 > n16) {
                                n16 = n14 - n15;
                            }
                            n15 = n14 + 1;
                        }
                    }
                    if (n16 <= 3) {
                        n16 = 4;
                    }
                    if ((n13 = (int)((double)(n16 * txtBlock2.B) * 1.38 * 21.0)) > Short.MAX_VALUE) {
                        n13 = Short.MAX_VALUE;
                    }
                    n15 = (short)n13;
                    n13 = (int)((double)txtBlock2.I / 1.62);
                    if (n13 > Short.MAX_VALUE) {
                        n13 = Short.MAX_VALUE;
                    }
                    int n17 = n12 = n15 > (n14 = (int)((short)n13)) ? n14 : n15;
                    if (n12 > this.createFont[s]) {
                        this.createFont[s] = n12;
                    }
                    ++n11;
                }
            }
            ++n10;
        }
        this.createCellStyle += n9;
        this.TRUE.removeAllElements();
    }

    private void dx() {
        this.convertUnitToInch = this.addElement.createSheet("" + this.createCell);
        ++this.createCell;
        this.elements();
        this.createCellStyle = 0;
    }

    private void dy() {
        if (this.createFont != null) {
            short s = 0;
            while (s < (short)this.createFont.length) {
                if (this.createFont[s] != -1) {
                    this.convertUnitToInch.setColumnWidth(s, this.createFont[s]);
                }
                s = (short)(s + 1);
            }
        }
    }

    private void elements() {
        int n = 0;
        while (n < this.createFont.length) {
            this.createFont[n] = -1;
            ++n;
        }
    }

    private void endsWith(HSSFCell hSSFCell, TxtBlock txtBlock) {
        this.equals(hSSFCell, txtBlock);
    }

    private void equals(HSSFCell hSSFCell, TxtBlock txtBlock) {
        hSSFCell.setCellValue(txtBlock.C);
        hSSFCell.setCellType(1);
    }

    private String error(String string) {
        return this.black.getExcelFontName(string);
    }

    private short exportToStream(Color color, boolean bl) {
        return this.get(color, bl, true);
    }

    private short fillColor(Color color) {
        if (color == null) {
            return this.fillColor(Color.white);
        }
        ColorIndex colorIndex = (ColorIndex)this.createSheet.get(color);
        if (colorIndex != null) {
            return colorIndex.I();
        }
        colorIndex = new ColorIndex(0, color);
        float f = Float.MAX_VALUE;
        int n = 0;
        while (n < this.createRow.length) {
            float f2;
            ColorIndex colorIndex2 = this.createRow[n];
            float f3 = colorIndex2.Z() - colorIndex.Z();
            f3 = f3 < 0.0f ? -f3 : f3;
            f3 = (double)f3 > 0.4 ? (float)(0.8 - (double)f3) : f3;
            f3 *= f3;
            float f4 = colorIndex2.C() - colorIndex.C();
            f4 *= f4;
            float f5 = colorIndex2.B() - colorIndex.B();
            if ((f2 = (float)Math.sqrt(f3 + f4 + (f5 *= f5))) < f) {
                f = f2;
                colorIndex.setIndex(colorIndex2.I());
            }
            ++n;
        }
        this.createSheet.put(color, colorIndex);
        return colorIndex.I();
    }

    private void flush() {
        short s = 8;
        Color color = Color.black;
        ColorIndex colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 9;
        color = Color.white;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 10;
        color = Color.red;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 11;
        color = Color.green;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 12;
        color = Color.blue;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 13;
        color = Color.yellow;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 14;
        color = Color.magenta;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 15;
        color = Color.cyan;
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 16;
        color = new Color(128, 0, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 17;
        color = new Color(0, 128, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 18;
        color = new Color(0, 0, 128);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 19;
        color = new Color(128, 128, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 20;
        color = new Color(128, 0, 128);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 21;
        color = new Color(0, 128, 128);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 22;
        color = new Color(192, 192, 192);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 23;
        color = new Color(128, 128, 128);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 24;
        color = new Color(153, 153, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 25;
        color = new Color(153, 51, 102);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 26;
        color = new Color(255, 255, 204);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 41;
        color = new Color(204, 255, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 28;
        color = new Color(102, 0, 102);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 29;
        color = new Color(255, 128, 128);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 30;
        color = new Color(0, 102, 204);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 31;
        color = new Color(204, 204, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 40;
        color = new Color(0, 204, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 42;
        color = new Color(204, 255, 204);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 43;
        color = new Color(255, 255, 153);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 44;
        color = new Color(153, 204, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 45;
        color = new Color(255, 153, 204);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 46;
        color = new Color(204, 153, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 47;
        color = new Color(255, 204, 153);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 48;
        color = new Color(51, 102, 255);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 49;
        color = new Color(51, 204, 204);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 50;
        color = new Color(153, 204, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 51;
        color = new Color(255, 204, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 52;
        color = new Color(255, 153, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 53;
        color = new Color(255, 102, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 54;
        color = new Color(102, 102, 153);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 55;
        color = new Color(150, 150, 150);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 56;
        color = new Color(0, 51, 102);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 57;
        color = new Color(51, 153, 102);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 58;
        color = new Color(0, 51, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 59;
        color = new Color(51, 51, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 60;
        color = new Color(153, 51, 0);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 62;
        color = new Color(51, 51, 153);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
        s = 63;
        color = new Color(51, 51, 51);
        colorIndex = new ColorIndex(s, color);
        this.createSheet.put(color, colorIndex);
        this.createRow[this.currentTimeMillis++] = colorIndex;
    }

    private short get(Color color, boolean bl, boolean bl2) {
        bl2 = false;
        if (color != null) {
            int n = color.getRGB();
            if (n == Color.black.getRGB()) {
                return 8;
            }
            if (n == Color.red.getRGB()) {
                return 10;
            }
            if (n == Color.green.getRGB()) {
                return 11;
            }
            if (n == Color.blue.getRGB()) {
                return 12;
            }
            if (n == Color.yellow.getRGB()) {
                return 13;
            }
            if (n == Color.white.getRGB()) {
                return 9;
            }
            if (n == Color.magenta.getRGB()) {
                return 14;
            }
            if (n == Color.cyan.getRGB()) {
                return 15;
            }
            if (n == Color.lightGray.getRGB()) {
                return 22;
            }
            if (n == Color.gray.getRGB()) {
                return 23;
            }
            if (n == Color.orange.getRGB()) {
                return 51;
            }
            if (n == Color.darkGray.getRGB()) {
                return 63;
            }
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n >> 0 & 0xFF;
            if (n2 == 0) {
                if (n3 == 0 && n4 == 128) {
                    return 18;
                }
                if (n3 == 128) {
                    if (n4 == 0) {
                        return 17;
                    }
                    if (n4 == 128) {
                        return 21;
                    }
                }
            }
            if (n2 == 128) {
                if (n3 == 0) {
                    if (n4 == 0) {
                        return 16;
                    }
                    if (n4 == 128) {
                        return 20;
                    }
                }
                if (n3 == 128 && n4 == 0) {
                    return 19;
                }
            }
            if (n2 == 153 && n3 == 153 && n4 == 153) {
                return 24;
            }
            if (n2 == 153 && n3 == 51 && n4 == 102) {
                return 25;
            }
            if (n2 == 255 && n3 == 255 && n4 == 204) {
                return 26;
            }
            if (n2 == 102 && n3 == 0 && n4 == 102) {
                return 28;
            }
            if (n2 == 255 && n3 == 128 && n4 == 128) {
                return 29;
            }
            if (n2 == 0 && n3 == 102 && n4 == 204) {
                return 30;
            }
            if (n2 == 204 && n3 == 204 && n4 == 255) {
                return 31;
            }
            if (n2 == 0 && n3 == 204 && n4 == 255) {
                return 40;
            }
            if (n2 == 204 && n3 == 255 && n4 == 255) {
                return 41;
            }
            if (n2 == 204 && n3 == 255 && n4 == 204) {
                return 42;
            }
            if (n2 == 255 && n3 == 255 && n4 == 153) {
                return 43;
            }
            if (n2 == 153 && n3 == 204 && n4 == 255) {
                return 44;
            }
            if (n2 == 255 && n3 == 153 && n4 == 204) {
                return 45;
            }
            if (n2 == 204 && n3 == 153 && n4 == 255) {
                return 46;
            }
            if (n2 == 255 && n3 == 204 && n4 == 153) {
                return 47;
            }
            if (n2 == 51 && n3 == 102 && n4 == 255) {
                return 48;
            }
            if (n2 == 51 && n3 == 204 && n4 == 204) {
                return 49;
            }
            if (n2 == 153 && n3 == 204 && n4 == 0) {
                return 50;
            }
            if (n2 == 255 && n3 == 204 && n4 == 0) {
                return 51;
            }
            if (n2 == 255 && n3 == 153 && n4 == 0) {
                return 52;
            }
            if (n2 == 255 && n3 == 102 && n4 == 0) {
                return 53;
            }
            if (n2 == 102 && n3 == 102 && n4 == 153) {
                return 54;
            }
            if (n2 == 150 && n3 == 150 && n4 == 150) {
                return 55;
            }
            if (n2 == 0 && n3 == 51 && n4 == 102) {
                return 56;
            }
            if (n2 == 51 && n3 == 153 && n4 == 102) {
                return 57;
            }
            if (n2 == 0 && n3 == 51 && n4 == 0) {
                return 58;
            }
            if (n2 == 51 && n3 == 51 && n4 == 0) {
                return 59;
            }
            if (n2 == 153 && n3 == 51 && n4 == 0) {
                return 60;
            }
            if (n2 == 153 && n3 == 51 && n4 == 102) {
                return 61;
            }
            if (n2 == 51 && n3 == 51 && n4 == 153) {
                return 62;
            }
            if (n2 == 51 && n3 == 51 && n4 == 51) {
                return 63;
            }
            if (bl2) {
                int n5 = (n2 + n3 + n4) / 3;
                double d = (double)Math.abs(n5 - n2) * 1.0 / (double)n5;
                double d2 = (double)Math.abs(n5 - n3) * 1.0 / (double)n5;
                double d3 = (double)Math.abs(n5 - n4) * 1.0 / (double)n5;
                if (d <= 0.08 && d2 <= 0.08 && d3 <= 0.08) {
                    Color color2 = null;
                    if (n5 >= 131 && n5 < 151) {
                        color2 = new Color(150, 150, 150);
                    } else if (n5 < 28) {
                        color2 = Color.black;
                    } else if (n5 > 240) {
                        color2 = Color.white;
                    } else {
                        n5 = this.getBooleanPropertyByName(n5);
                        color2 = new Color(n5, n5, n5);
                    }
                    return this.get(color2, bl, false);
                }
                return this.get(new Color(this.getBooleanPropertyByName(n2), this.getBooleanPropertyByName(n3), this.getBooleanPropertyByName(n4)), bl, false);
            }
            if (bl) {
                return 22;
            }
            return Short.MAX_VALUE;
        }
        return 9;
    }

    private int getBooleanPropertyByName(int n) {
        if (n >= 28 && n < 88) {
            return 51;
        }
        if (n >= 89 && n < 130) {
            return 128;
        }
        if (n >= 131 && n < 151) {
            return 150;
        }
        if (n >= 152 && n < 175) {
            return 153;
        }
        if (n >= 152 && n < 175) {
            return 153;
        }
        if (n <= 240) {
            return 192;
        }
        if (n > 241) {
            return 255;
        }
        return 0;
    }

    private boolean getChildren(boolean bl) {
        if (this.blue) {
            return bl;
        }
        return this.booleanValue;
    }

    private JRObjectResult getClass(JRObjectResult jRObjectResult) {
        int n = jRObjectResult.getObjectType();
        while (n == 8192) {
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
            n = jRObjectResult.getObjectType();
        }
        return jRObjectResult;
    }

    private List getColorPropertyByName(List list) {
        return list;
    }

    private Object getDimension(TxtBlock txtBlock) {
        return this.cyan.getPD(txtBlock.y, txtBlock.Z);
    }

    private Color getEncoding(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    private Color getEndLine(JRObjectResult jRObjectResult, String string) {
        return (Color)jRObjectResult.getPropertyByName(string).getObject();
    }

    private boolean getExcelBorderStyle(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    private boolean getExcelFontName(JRObjectResult jRObjectResult, String string) {
        return (Boolean)jRObjectResult.getPropertyByName(string).getObject();
    }

    private int getFontStyle(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    private int getGridInfos(JRObjectResult jRObjectResult, String string) {
        return ((Number)jRObjectResult.getPropertyByName(string).getObject()).intValue();
    }

    private String getHeaderInfo(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    private String getHeight(JRObjectResult jRObjectResult, String string) {
        return ((String)jRObjectResult.getPropertyByName(string).getObject()).trim();
    }

    class PDList {
        private final ExportToXlsBiff8 this$0;
    }

    private class TxtBlock {
        int x;
        int y;
        int I;
        int Z;
        String C;
        short B;
        HSSFCellStyle D;
        private final ExportToXlsBiff8 this$0;

        public TxtBlock(ExportToXlsBiff8 exportToXlsBiff8, int n, int n2, int n3, int n4, String string, HSSFCellStyle hSSFCellStyle, short s) {
            this.this$0 = exportToXlsBiff8;
            this.x = n;
            this.y = n2;
            this.I = n3;
            this.Z = n4;
            this.C = string;
            this.D = hSSFCellStyle;
            this.B = s;
        }
    }
}

