/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf;

import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import jet.JRStopEngineException;
import jet.JResource;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.rtf.BaseTool;
import jet.export.rtf.RtfCache;
import jet.export.rtf.api.DocPage;
import jet.export.rtf.api.LineInfo;
import jet.export.rtf.api.ObjectFactory;
import jet.export.rtf.api.PageInfo;
import jet.export.rtf.api.RTFDoc;
import jet.export.util.CCUtil;
import jet.export.util.ImageEngine;
import jet.util.Propertiable;

abstract class BaseRtfExport
extends BaseTool {
    private RTFDoc QOIV;
    protected DocPage docPage;
    protected ObjectFactory rtfObjfactory;
    private static final String[] addPage = new String[]{"TopLine", "LeftLine", "BottomLine", "RightLine"};
    protected static final String[] NEWBORDERWIDTH = new String[]{"border-top-width", "border-left-width", "border-bottom-width", "border-right-width"};
    protected static final String[] NEWBORDERCOLOR = new String[]{"border-top-color", "border-left-color", "border-bottom-color", "border-right-color"};
    protected ImageEngine imageEngine = null;
    protected Stack offsets;
    protected static final int NONE_LINE = 0;
    protected static final int TOP = 0;
    protected static final int LEFT = 1;
    protected static final int BOTTOM = 2;
    protected static final int RIGHT = 3;
    private LineInfo append = new LineInfo();
    private LineInfo background = new LineInfo();
    private LineInfo canBeReuse = new LineInfo();
    private LineInfo clear = new LineInfo();
    protected static final int CENTER_X = 2;
    protected static final int CENTER_Y = 1;
    protected static final int DELTA_X = 3;
    protected static final int DELTA_Y = 2;
    protected static final int TOP_LINE = 20;
    protected static final int BOTTOM_LINE = 12;
    protected static final int LINE_SPACEING = 280;
    protected static final String EVAL = "JReport Evaluation Copy";
    protected static final String CONTACT = "to purchase contact " + JResource.getMessage("Sale");
    protected static final String PHONE = JResource.getMessage("SalePhone") + " / " + JResource.getMessage("homeURL");
    protected static final String EVALFONT = "Arial Narrow";
    protected static Font FT = new Font("Arial Narrow", 0, 20);
    protected static Font FB = new Font("Arial Narrow", 0, 12);
    protected static final FontRenderContext FTR = new FontRenderContext(FT.getTransform(), false, true);
    protected static final FontRenderContext FBR = new FontRenderContext(FT.getTransform(), false, true);
    protected static final Color DEF_COLOR = Color.cyan;
    protected static final int TH = (int)(FT.getStringBounds("JReport Evaluation Copy", FTR).getHeight() * 20.0);
    protected static final int BH = (int)(FB.getStringBounds(CONTACT, FBR).getHeight() * 20.0);
    protected static final int TW = (int)(FT.getStringBounds("JReport Evaluation Copy", FTR).getWidth() * 20.0);
    protected static final int BW1 = (int)(FB.getStringBounds(CONTACT, FBR).getWidth() * 20.0) + 500;
    protected static final int BW2 = (int)(FB.getStringBounds(PHONE, FBR).getWidth() * 20.0) + 500;
    protected static final int TEXT_RENDER = 0;
    protected static final int TEXT_FIELD_RENDER = 4;
    protected RtfCache cache;
    private Communicator convertInchToPixel;
    private boolean convertUnitToPixel;
    private int createObjFactory = -1;
    private int createPage = Integer.MAX_VALUE;

    BaseRtfExport(Communicator communicator, boolean bl) {
        this.convertInchToPixel = communicator;
        this.convertUnitToPixel = !bl;
        this.imageEngine = new ImageEngine();
        this.imageEngine.setResolusion(96);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void I(BufferedOutputStream bufferedOutputStream, File file) throws IOException, JRStopEngineException {
        this.BH(file);
        int n = this.convertInchToPixel.getResolution();
        try {
            this.convertInchToPixel.setResolution(96);
            String string = this.convertInchToPixel.getEncoding();
            if (string == null || string.trim().length() == 0) {
                string = "UTF-8";
            }
            this.createObjFactory(string);
            this.QOIV = this.rtfObjfactory.getDoc();
            this.initalValible();
            boolean bl = ((DataStream)this.convertInchToPixel.getDataStream(0)).ie() == 1;
            CommEnumeration commEnumeration = new CommEnumeration(this.convertInchToPixel);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (commEnumeration.hasMoreElements()) {
                if (++n6 < this.createObjFactory) {
                    commEnumeration.nextElement();
                    continue;
                }
                DSPage dSPage = (DSPage)commEnumeration.nextElement();
                Rectangle rectangle = dSPage.getPageArea();
                Rectangle rectangle2 = dSPage.getPrintableArea();
                if (this.convertUnitToPixel) {
                    n2 = this.unitToTwip(rectangle2.x);
                    n3 = this.unitToTwip(rectangle2.y);
                    n4 = this.unitToTwip(rectangle.width - (rectangle2.x + rectangle2.width));
                    n5 = this.unitToTwip(rectangle.height - (rectangle2.y + rectangle2.height));
                }
                int n7 = this.unitToTwip(rectangle.width);
                int n8 = this.unitToTwip(rectangle.height);
                PageInfo pageInfo = new PageInfo(n7, n8, n2, n3, n4, n5, this.convertInchToPixel.getHeaderInfo((int)0).background);
                this.docPage = this.rtfObjfactory.createPage(pageInfo);
                this.writePage(dSPage);
                if (bl) {
                    this.writeEvaluation();
                }
                this.QOIV.addPage(this.docPage);
                if (n6 == this.createPage) break;
            }
            this.QOIV.output(bufferedOutputStream);
            bufferedOutputStream.flush();
            Object var19_18 = null;
            this.convertInchToPixel.setResolution(n);
            if (this.QOIV != null) {
                this.QOIV.free();
                this.QOIV = null;
            }
            this.clear();
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this.convertInchToPixel.setResolution(n);
            if (this.QOIV != null) {
                this.QOIV.free();
                this.QOIV = null;
            }
            this.clear();
            throw throwable;
        }
    }

    protected abstract void createObjFactory(String var1);

    protected abstract void writeEvaluation() throws IOException;

    protected abstract void writePage(DSPage var1) throws IOException;

    protected void initalValible() {
        this.offsets = new Stack();
    }

    protected void clear() {
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }

    protected void deleteFile(File file) {
        if (file != null) {
            if (file.isFile() && file.exists()) {
                file.delete();
            } else if (file.isDirectory() && file.exists()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    int n = 0;
                    while (n < fileArray.length) {
                        this.deleteFile(fileArray[n]);
                        ++n;
                    }
                }
                file.delete();
            }
        }
    }

    private void BH(File file) {
        this.cache = new RtfCache(file, "rtf");
    }

    protected int unitToTwip(int n) {
        return Unit.convertUnitToPixel(n, 1440);
    }

    protected int inchToTwip(int n) {
        return Unit.convertInchToPixel(n, 1440);
    }

    protected LineInfo[] getBorderInfo(JRVisiableResult jRVisiableResult) {
        Color[] colorArray;
        int[] nArray;
        int[] nArray2 = this.getBorderStyle(jRVisiableResult);
        if (jRVisiableResult.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            nArray = this.getBorderWidth(jRVisiableResult, true);
            colorArray = this.getBorderColor(jRVisiableResult, true);
        } else {
            nArray = this.getBorderWidth(jRVisiableResult, false);
            colorArray = this.getBorderColor(jRVisiableResult, false);
        }
        LineInfo lineInfo = this.append.canBeReuse() ? this.append : new LineInfo();
        LineInfo lineInfo2 = this.canBeReuse.canBeReuse() ? this.canBeReuse : new LineInfo();
        LineInfo lineInfo3 = this.background.canBeReuse() ? this.background : new LineInfo();
        LineInfo lineInfo4 = this.clear.canBeReuse() ? this.clear : new LineInfo();
        this.setLineStyle(lineInfo, nArray2[1]);
        this.setLineStyle(lineInfo3, nArray2[0]);
        this.setLineStyle(lineInfo2, nArray2[3]);
        this.setLineStyle(lineInfo4, nArray2[2]);
        lineInfo.setColor(colorArray[1]);
        lineInfo3.setColor(colorArray[0]);
        lineInfo2.setColor(colorArray[3]);
        lineInfo4.setColor(colorArray[2]);
        lineInfo.setLineWidth(this.unitToTwip(nArray[1]));
        lineInfo3.setLineWidth(this.unitToTwip(nArray[0]));
        lineInfo2.setLineWidth(this.unitToTwip(nArray[3]));
        lineInfo4.setLineWidth(this.unitToTwip(nArray[2]));
        LineInfo[] lineInfoArray = new LineInfo[4];
        if (lineInfo.getLineWidth() > 0L) {
            lineInfoArray[1] = lineInfo;
        }
        if (lineInfo3.getLineWidth() > 0L) {
            lineInfoArray[0] = lineInfo3;
        }
        if (lineInfo2.getLineWidth() > 0L) {
            lineInfoArray[3] = lineInfo2;
        }
        if (lineInfo4.getLineWidth() > 0L) {
            lineInfoArray[2] = lineInfo4;
        }
        return lineInfoArray;
    }

    protected int[] getBorderStyle(JRVisiableResult jRVisiableResult) {
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = this.getIntProperty(jRVisiableResult, addPage[n]);
            ++n;
        }
        return nArray;
    }

    protected boolean borderStyleCanBeStrore(JRVisiableResult jRVisiableResult) {
        int n = 0;
        while (n < 4) {
            if (this.isChangeByFormularProperty(jRVisiableResult, addPage[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean isChangeByFormularProperty(JRObjectResult jRObjectResult, String string) {
        return CCUtil.isChangeByFormularProperty(jRObjectResult, string);
    }

    protected boolean isChangeByFormularNewProperty(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getTemplate().getPropertyByName(string);
        return propertiable != null && propertiable.isChangeByOther();
    }

    protected int[] getBorderWidth(JRVisiableResult jRVisiableResult, boolean bl) {
        int[] nArray = new int[4];
        if (bl) {
            int n = 0;
            while (n < 4) {
                nArray[n] = this.getNewIntProperty(jRVisiableResult, NEWBORDERWIDTH[n]);
                ++n;
            }
        } else {
            int n = this.getIntProperty(jRVisiableResult, "BorderWidth");
            int n2 = 0;
            while (n2 < 4) {
                nArray[n2] = n;
                ++n2;
            }
        }
        return nArray;
    }

    protected boolean borderWidthCanBeStore(JRVisiableResult jRVisiableResult, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < 4) {
                if (this.isChangeByFormularNewProperty(jRVisiableResult, NEWBORDERWIDTH[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return !this.isChangeByFormularProperty(jRVisiableResult, "BorderWidth");
    }

    protected Color[] getBorderColor(JRVisiableResult jRVisiableResult, boolean bl) {
        Color[] colorArray = new Color[4];
        if (bl) {
            int n = 0;
            while (n < 4) {
                colorArray[n] = this.getNewColorProperty(jRVisiableResult, NEWBORDERCOLOR[n]);
                ++n;
            }
        } else {
            Color color = this.getColorProperty(jRVisiableResult, "BorderColor");
            int n = 0;
            while (n < 4) {
                colorArray[n] = color;
                ++n;
            }
        }
        return colorArray;
    }

    protected boolean borderColorCanBeStore(JRVisiableResult jRVisiableResult, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < 4) {
                if (this.isChangeByFormularNewProperty(jRVisiableResult, NEWBORDERCOLOR[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return !this.isChangeByFormularProperty(jRVisiableResult, "BorderColor");
    }

    protected void setLineStyle(LineInfo lineInfo, int n) {
        switch (n) {
            case 1: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)6);
                break;
            }
            case 2: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)9);
                break;
            }
            case 3: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)8);
                break;
            }
            case 4: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)10);
                break;
            }
            case 5: {
                lineInfo.setLineStyle((byte)2);
                lineInfo.setDashed((byte)6);
                break;
            }
            default: {
                lineInfo.setLineStyle((byte)0);
            }
        }
    }

    protected int[] drawBackGround(DSContainer dSContainer, int n, int n2) {
        Offset offset = (Offset)this.offsets.peek();
        int n3 = this.unitToTwip(dSContainer.getX() + offset.dx) + n;
        int n4 = this.unitToTwip(this.getY(dSContainer, n2) + offset.dy);
        int n5 = this.unitToTwip(dSContainer.getWidth());
        int n6 = this.unitToTwip(dSContainer.getHeight());
        Color color = this.getColorProperty(dSContainer, "Background");
        if (color != null) {
            this.docPage.fillBackGround(n3, n4, n5, n6, color);
        }
        int[] nArray = new int[]{n3, n4, n5, n6};
        return nArray;
    }

    protected void drawBorder(DSContainer dSContainer, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Color[] colorArray;
        int[] nArray;
        int[] nArray2 = this.getBorderStyle(dSContainer);
        if (dSContainer.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            nArray = this.getBorderWidth(dSContainer, true);
            colorArray = this.getBorderColor(dSContainer, true);
        } else {
            nArray = this.getBorderWidth(dSContainer, false);
            colorArray = this.getBorderColor(dSContainer, false);
        }
        LineInfo lineInfo = new LineInfo();
        if (nArray2[0] != 0 && nArray[0] != 0) {
            n6 = this.unitToTwip(nArray[0]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[0]);
            this.setLineStyle(lineInfo, nArray2[0]);
            this.docPage.drawLine(n, n2 + n5, n + n3, n2 + n5, lineInfo);
        }
        if (nArray2[1] != 0 && nArray[1] != 0) {
            n6 = this.unitToTwip(nArray[1]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[1]);
            this.setLineStyle(lineInfo, nArray2[1]);
            this.docPage.drawLine(n + n5, n2, n + n5, n2 + n4, lineInfo);
        }
        if (nArray2[2] != 0 && nArray[2] != 0) {
            n6 = this.unitToTwip(nArray[2]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[2]);
            this.setLineStyle(lineInfo, nArray2[2]);
            this.docPage.drawLine(n, n2 + n4 - n5, n + n3, n2 + n4 - n5, lineInfo);
        }
        if (nArray2[3] != 0 && nArray[3] != 0) {
            n6 = this.unitToTwip(nArray[3]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[3]);
            this.setLineStyle(lineInfo, nArray2[3]);
            this.docPage.drawLine(n + n3 - n5, n2, n + n3 - n5, n2 + n4, lineInfo);
        }
        lineInfo = null;
    }
}

