/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DSReference;
import jet.datastream.DSShape;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.export.util.ImageTool;

public class ExportUtil {
    public static final int FORMAT_DEFAULT = 0;
    public static final int FORMAT_GIF = 1;
    public static final int FORMAT_JPEG = 2;

    public static JRObjectResult getRealObject(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult2.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    public static List getContainerChildren(DSContainer dSContainer) {
        List list = dSContainer.getChildren();
        if (list == null || list.size() <= 1) {
            return list;
        }
        if (dSContainer instanceof DSSubReport && dSContainer.getObjectType() == 45) {
            list = ExportUtil.reverseElements(list);
        }
        return list;
    }

    public static List getContainerChildren(DSPage dSPage) {
        List list = dSPage.getChildren();
        if (list != null && list.size() > 1) {
            list = ExportUtil.reverseElements(list);
        }
        return list;
    }

    public static List reverseElements(List list) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        int n2 = 0;
        int n3 = list.size();
        while (n2 < n3) {
            arrayList = list.get(n2);
            if (arrayList instanceof DSShape) {
                n = ((JRObjectResult)((Object)arrayList)).getObjectType();
                if (n == 22) {
                    arrayList2.add(arrayList);
                } else {
                    arrayList3.add(arrayList);
                }
            } else if (arrayList instanceof DSTable) {
                arrayList5.add(arrayList);
            } else {
                arrayList4.add(arrayList);
            }
            ++n2;
        }
        arrayList = new ArrayList();
        arrayList.addAll(arrayList2);
        n = arrayList4.size() - 1;
        while (n >= 0) {
            arrayList.add(arrayList4.get(n));
            --n;
        }
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList5);
        return arrayList;
    }

    public static void waitImage(Image image) {
        block3: {
            MediaTracker mediaTracker = new MediaTracker(new Component(){});
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                    mediaTracker.removeImage(image, 0);
                }
                catch (InterruptedException interruptedException) {
                    image = null;
                    mediaTracker.removeImage(image);
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, 2401012, (Throwable)interruptedException);
                }
            }
        }
    }

    public static void checkStop(Communicator communicator) throws JRStopEngineException {
        if (communicator.isBeStopping()) {
            throw new JRStopEngineException();
        }
    }

    public static Rectangle getImagePos(JRVisiableResult jRVisiableResult) {
        int n;
        int n2;
        if (jRVisiableResult instanceof DSChartPlatform) {
            return new Rectangle(0, 0, 0, 0);
        }
        Image image = CCUtil.getImagePropertyByName(jRVisiableResult, "PictureName");
        if (image == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = CCUtil.getIntPropertyByName(jRVisiableResult, "Rotation");
        int n4 = CCUtil.getIntPropertyByName(jRVisiableResult, "VerticalAlignment");
        int n5 = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        int n6 = CCUtil.getIntPropertyByName(jRVisiableResult, "ScalingMode");
        float f = CCUtil.getFloatPropertyByName(jRVisiableResult, "MaxScalingRatio");
        int n7 = jRVisiableResult.getWidth();
        int n8 = jRVisiableResult.getHeight();
        float f2 = ImageTool.getResolutionRatio(Unit.getResolution());
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        Dimension dimension2 = ImageTool.getScalingSize(n7, n8, image.getWidth(null), image.getHeight(null), n6, f);
        if ((double)n3 == 0.0) {
            n2 = dimension2.width > n7 ? n7 : dimension2.width;
            n = dimension2.height > n8 ? n8 : dimension2.height;
        } else {
            n2 = n7;
            n = n8;
        }
        int n9 = ImageTool.transAlignment(n4, n5);
        Point point = ImageTool.getAlignPosition(new Dimension(n7, n8), new Dimension(n2, n), n9);
        return new Rectangle(point);
    }

    public static long cloneRSTFile(String string, String string2) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = new FileInputStream(string);
        if (!string2.endsWith(".rst") && !string2.endsWith(".temp")) {
            string2 = string2 + ".rst";
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
            l += (long)n;
        }
        fileInputStream.close();
        fileOutputStream.close();
        return l;
    }
}

