/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Average;
import jet.formula.CompondAggregation;
import jet.formula.Count;
import jet.formula.Distinctcount;
import jet.formula.Maximum;
import jet.formula.Minimum;
import jet.formula.PopulationStdDev;
import jet.formula.PopulationVariance;
import jet.formula.RecMax;
import jet.formula.RecMin;
import jet.formula.RecNotSatisfy;
import jet.formula.RecSatisfy;
import jet.formula.SQRSUM;
import jet.formula.StdDev;
import jet.formula.Summary;
import jet.formula.Variance;
import jet.log.JRLogger;

public abstract class Aggregation {
    public static final int CNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int DCNT = 5;
    public static final int AVG = 6;
    public static final int SQRSUM = 7;
    public static final int POPSTDDEV = 8;
    public static final int POPVRNCE = 9;
    public static final int STDDV = 10;
    public static final int VRNCE = 11;
    public static final int RECMIN = 12;
    public static final int RECMAX = 13;
    public static final int RECSATISFY = 14;
    public static final int RECNOTSATISFY = 15;
    public static final int[] COUNT = new int[]{1};
    public static final int[] SUMMARY = new int[]{2};
    public static final int[] MINIMUM = new int[]{3};
    public static final int[] MAXIMUM = new int[]{4};
    public static final int[] DISTINCTCOUNT = new int[]{5};
    public static final int[] AVERAGE = new int[]{6, 1, 2};
    public static final int[] POPULATIONSTDDEV = new int[]{8, 1, 2, 7};
    public static final int[] POPULATIONVARIANCE = new int[]{9, 1, 2, 7};
    public static final int[] STDDEV = new int[]{10, 1, 2, 7};
    public static final int[] VARIANCE = new int[]{11, 1, 2, 7};
    public static final int[] RECINDMIN = new int[]{12};
    public static final int[] RECINDMAX = new int[]{13};
    public static final int[] RECSATISFYCON = new int[]{14};
    public static final int[] RECNOTSATISFYCON = new int[]{15};
    AggDesc I;
    protected DbValue agg;
    private static Hashtable QOIV = new Hashtable();
    protected static DbBigInt ZERO = new DbBigInt(new DbColDesc("", 4, 15, 0, 2));
    int Z = -1;
    private static JRLogger aggCode;
    static Class class$jet$formula$Aggregation;

    Aggregation() {
    }

    Aggregation(AggDesc aggDesc) {
        this.I = aggDesc;
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl, String string4) {
        return Aggregation.mapCode(string, string2, string3, bl, string4, false);
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl) {
        return Aggregation.mapCode(string, string2, string3, bl, false);
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        int[] nArray = (int[])QOIV.get(string.toUpperCase());
        Aggregation[] aggregationArray = new Aggregation[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            AggDesc aggDesc = string4 != null ? new AggDesc(string2, string3, nArray[n], bl, string4) : new AggDesc(string2, string3, nArray[n], bl);
            aggregationArray[n] = Aggregation.makeAgg(aggDesc);
            aggDesc.setDynamicSummary(bl2);
            ++n;
        }
        if (aggregationArray.length > 1) {
            ((CompondAggregation)aggregationArray[0]).setUsedAggs(aggregationArray);
        }
        return aggregationArray;
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl, boolean bl2) {
        int[] nArray = (int[])QOIV.get(string.toUpperCase());
        Aggregation[] aggregationArray = new Aggregation[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            AggDesc aggDesc = new AggDesc(string2, string3, nArray[n], bl);
            aggregationArray[n] = Aggregation.makeAgg(aggDesc);
            aggDesc.setDynamicSummary(bl2);
            ++n;
        }
        if (aggregationArray.length > 1) {
            ((CompondAggregation)aggregationArray[0]).setUsedAggs(aggregationArray);
        }
        return aggregationArray;
    }

    public static final Aggregation makeAgg(AggDesc aggDesc) {
        Aggregation aggregation;
        switch (aggDesc.aggCode) {
            case 1: {
                aggregation = new Count(aggDesc);
                break;
            }
            case 2: {
                aggregation = new Summary(aggDesc);
                break;
            }
            case 3: {
                aggregation = new Minimum(aggDesc);
                break;
            }
            case 4: {
                aggregation = new Maximum(aggDesc);
                break;
            }
            case 5: {
                aggregation = new Distinctcount(aggDesc);
                break;
            }
            case 6: {
                aggregation = new Average(aggDesc);
                break;
            }
            case 7: {
                aggregation = new SQRSUM(aggDesc);
                break;
            }
            case 8: {
                aggregation = new PopulationStdDev(aggDesc);
                break;
            }
            case 9: {
                aggregation = new PopulationVariance(aggDesc);
                break;
            }
            case 10: {
                aggregation = new StdDev(aggDesc);
                break;
            }
            case 11: {
                aggregation = new Variance(aggDesc);
                break;
            }
            case 12: {
                aggregation = new RecMin(aggDesc);
                break;
            }
            case 13: {
                aggregation = new RecMax(aggDesc);
                break;
            }
            case 14: {
                aggregation = new RecSatisfy(aggDesc);
                break;
            }
            case 15: {
                aggregation = new RecNotSatisfy(aggDesc);
                break;
            }
            default: {
                throw new Error("error agg type : " + aggDesc.aggCode);
            }
        }
        return aggregation;
    }

    public DbValue getValue() {
        return this.agg;
    }

    public boolean isCountFunc() {
        return this.I.aggCode == 1 || this.I.aggCode == 5;
    }

    public abstract void exec(Record var1);

    public abstract void exec(DbValue var1);

    public void reset() {
        if (this.agg != null) {
            if (this.agg instanceof DbNumber) {
                ((DbNumber)this.agg).setValue(ZERO);
            } else {
                this.agg = null;
            }
        }
    }

    public Object clone() {
        try {
            Aggregation aggregation = (Aggregation)this.getClass().newInstance();
            aggregation.I = this.I;
            aggregation.Z = this.Z;
            if (this.agg != null) {
                aggregation.agg = (DbValue)this.agg.clone();
                aggregation.reset();
            }
            return aggregation;
        }
        catch (Exception exception) {
            if (aggCode.isErrorEnabled()) {
                aggCode.error("", exception);
            }
            return null;
        }
    }

    public Aggregation deepClone() {
        block5: {
            try {
                Aggregation aggregation = (Aggregation)this.getClass().newInstance();
                aggregation.I = (AggDesc)this.I.clone();
                aggregation.Z = this.Z;
                if (this.agg != null) {
                    aggregation.agg = (DbValue)this.agg.clone();
                    aggregation.agg.desc = (DbColDesc)this.agg.desc.clone();
                    aggregation.agg.desc.setColIndex(-1);
                    aggregation.reset();
                }
                return aggregation;
            }
            catch (InstantiationException instantiationException) {
                if (aggCode.isErrorEnabled()) {
                    aggCode.error("", instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!aggCode.isErrorEnabled()) break block5;
                aggCode.error("", illegalAccessException);
            }
        }
        return null;
    }

    public AggDesc getAggDesc() {
        return this.I;
    }

    public boolean equals(Object object) {
        AggDesc aggDesc = ((Aggregation)object).getAggDesc();
        return this.I.equals(aggDesc);
    }

    public void writeDescToStream(DataOutputStream dataOutputStream) throws IOException {
        this.I.writeToStream(dataOutputStream);
    }

    public void readDescFromStream(DataInputStream dataInputStream) throws IOException {
        this.I.readFromStream(dataInputStream);
    }

    public void setBaseGroup(int n) {
        this.Z = n;
    }

    public int getBaseGroup() {
        return this.Z;
    }

    public String getFName() {
        return this.I.fieldname;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        QOIV.put("SUM", SUMMARY);
        QOIV.put("COUNT", COUNT);
        QOIV.put("MAXIMUM", MAXIMUM);
        QOIV.put("MINIMUM", MINIMUM);
        QOIV.put("AVERAGE", AVERAGE);
        QOIV.put("DISTINCTCOUNT", DISTINCTCOUNT);
        QOIV.put("POPULATIONSTDDEV", POPULATIONSTDDEV);
        QOIV.put("POPULATIONVARIANCE", POPULATIONVARIANCE);
        QOIV.put("STDDEV", STDDEV);
        QOIV.put("VARIANCE", VARIANCE);
        QOIV.put("RECMIN", RECINDMIN);
        QOIV.put("RECMAX", RECINDMAX);
        QOIV.put("RECSATISFY", RECSATISFYCON);
        QOIV.put("RECNOTSATISFY", RECNOTSATISFYCON);
        Aggregation.ZERO.bNull = false;
        aggCode = JRLogger.getLogger((class$jet$formula$Aggregation == null ? (class$jet$formula$Aggregation = Aggregation.class$("jet.formula.Aggregation")) : class$jet$formula$Aggregation).getName());
    }
}

