/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.math.BigDecimal;
import jet.connect.DbBigInt;
import jet.connect.DbChar;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;
import jet.formula.fCurrency;

class Minimum
extends Aggregation {
    Minimum() {
    }

    Minimum(AggDesc aggDesc) {
        super(aggDesc);
    }

    public DbValue getValue() {
        int n = DataTypeDef.SqlToFml(this.agg.getSqlType(), this.agg.isCurrency());
        DbValue dbValue = DataTypeDef.makeData(n);
        dbValue.bNull = this.agg.bNull;
        if (!dbValue.bNull) {
            switch (n) {
                case 1: {
                    ((DbBigInt)dbValue).value = ((DbNumber)this.agg).longValue();
                    break;
                }
                case 2: {
                    ((DbDouble)dbValue).value = ((DbNumber)this.agg).doubleValue();
                    break;
                }
                case 3: {
                    ((fCurrency)dbValue).value = new BigDecimal(this.agg.toString());
                    break;
                }
                case 5: {
                    ((DbChar)dbValue).value = this.agg.toString();
                    break;
                }
                default: {
                    dbValue.set(this.agg);
                }
            }
        }
        this.agg = dbValue;
        return this.agg;
    }

    public void exec(Record record) {
        DbValue dbValue;
        try {
            dbValue = record.getCell(this.agg.getColDesc());
        }
        catch (NullPointerException nullPointerException) {
            dbValue = record.getCell(this.I.fieldname);
            if (this.agg == null) {
                this.agg = (DbValue)dbValue.clone();
            }
            this.agg.getColDesc().setColIndex(dbValue.getColDesc().getColIndex());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (!dbValue.bNull && this.agg.compareTo(dbValue) > 0) {
            this.agg.set(dbValue);
        }
        if (!dbValue.bNull && this.agg.bNull) {
            this.agg.set(dbValue);
            this.agg.bNull = false;
        }
    }

    public void exec(DbValue dbValue) {
        if (this.agg == null) {
            this.agg = (DbValue)dbValue.clone();
        }
        if (!dbValue.bNull && this.agg.compareTo(dbValue) > 0) {
            this.agg.set(dbValue);
        }
        if (!dbValue.bNull && this.agg.bNull) {
            this.agg.set(dbValue);
            this.agg.bNull = false;
        }
    }

    public void reset() {
        if (this.agg != null) {
            this.agg = null;
        }
    }
}

