/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.Groupable;
import jet.connect.NDbBuffer;
import jet.dataengine.util.DSLog;
import jet.ie.ResultSetAdapterDbBuffer;
import jet.util.RAFile;

public class LoadCQR2ResultSet {
    public static final String BLOB_FILE_EXTENSION = ".col";
    public static final String DESCRIPTION_FILE_EXTENSION = ".desc";
    private final DSLog QOIV = DSLog.getDSLog(this.getClass().getName());

    public static void main(String[] stringArray) {
    }

    public ResultSet loadCQR(String[] stringArray) throws IOException {
        this.QOIV.debug("load cqr");
        ArrayList arrayList = new ArrayList();
        if (stringArray.length > 0) {
            String string = stringArray[0];
            RAFile rAFile = new RAFile(string + DESCRIPTION_FILE_EXTENSION, "r");
            this.QOIV.debug("data file:" + string);
            File file = new File(string);
            this.QOIV.debug("desc file:" + string + DESCRIPTION_FILE_EXTENSION);
            DbRecordModel dbRecordModel = this.QOIV(rAFile);
            int n = rAFile.readInt();
            Hashtable hashtable = this.Read(string, dbRecordModel);
            DbBuffer dbBuffer = this.append(file, dbRecordModel, hashtable, n);
            ResultSetAdapterDbBuffer resultSetAdapterDbBuffer = new ResultSetAdapterDbBuffer(dbBuffer, arrayList);
            resultSetAdapterDbBuffer.I(true);
            this.QOIV.debug("load cqr over");
            rAFile.close();
            return resultSetAdapterDbBuffer;
        }
        return null;
    }

    private DbRecordModel QOIV(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        DbRecordModel dbRecordModel = null;
        if (n != 0) {
            DbColDesc[] dbColDescArray = new DbColDesc[n];
            int n2 = 0;
            while (n2 < dbColDescArray.length) {
                dbColDescArray[n2] = new DbColDesc(dataInput.readUTF(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt());
                dbColDescArray[n2].setFlag(dataInput.readInt());
                dbColDescArray[n2].setEncodingName(dataInput.readUTF());
                ++n2;
            }
            dbRecordModel = new DbRecordModel(dbColDescArray, (Groupable)null);
        }
        return dbRecordModel;
    }

    private Hashtable Read(String string, DbRecordModel dbRecordModel) {
        Hashtable<DbColDesc, RAFile> hashtable = new Hashtable<DbColDesc, RAFile>();
        try {
            DbColDesc[] dbColDescArray = dbRecordModel.getColDescs();
            int n = 0;
            while (n < dbColDescArray.length) {
                if (dbColDescArray[n].getSqlType() == -1 || dbColDescArray[n].getSqlType() == -4 || dbColDescArray[n].getSqlType() == 2005 || dbColDescArray[n].getSqlType() == 2004 || dbColDescArray[n].isArray()) {
                    String string2 = string + BLOB_FILE_EXTENSION + n;
                    RAFile rAFile = new RAFile(string2, "r");
                    hashtable.put(dbColDescArray[n], rAFile);
                    this.QOIV.debug(" Col Name: " + dbColDescArray[n].getColName() + " Col Idx: " + n + " File Name: " + string2 + " File Length: " + rAFile.length());
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            String string3 = iOException.getMessage();
            this.QOIV.debug("CAT_CQR_EXCP_3.occur error:" + (string3 != null ? string3 : ""));
        }
        return hashtable;
    }

    private DbBuffer append(File file, DbRecordModel dbRecordModel, Hashtable hashtable, int n) throws IOException {
        NDbBuffer nDbBuffer = new NDbBuffer(dbRecordModel, file, hashtable, n);
        nDbBuffer.Read();
        return nDbBuffer;
    }
}

