/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.IOException;
import java.math.BigDecimal;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.ie.PJFAux;
import jet.ie.io.PJFDataInput;

public class ReaderTools {
    public static final void readDbValue(DbValue dbValue, PJFDataInput pJFDataInput) throws IOException {
        int n;
        if (pJFDataInput.getVersion() >= 6) {
            boolean bl;
            n = pJFDataInput.readByte();
            boolean bl2 = bl = n == 1;
            if (bl) {
                int n2 = dbValue.getColDesc().getPrecision();
                byte[] byArray = new byte[n2 >= 0x7FFFFFFD ? 2 : PJFAux.getColLength(dbValue.getColDesc())];
                pJFDataInput.read(byArray);
                return;
            }
        }
        if (dbValue.getColDesc().isArray() && pJFDataInput.getVersion() >= 131092) {
            ReaderTools.readArray(dbValue, pJFDataInput);
            return;
        }
        n = dbValue.getSqlType();
        switch (n) {
            case 5: {
                ((DbSmallInt)dbValue).set(pJFDataInput.readShort());
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(pJFDataInput.readByte());
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(pJFDataInput.readInt());
                break;
            }
            case 91: 
            case 92: {
                ((DbDateTime)dbValue).set(pJFDataInput.readLong());
                break;
            }
            case -5: {
                ((DbBigInt)dbValue).set(pJFDataInput.readLong());
                break;
            }
            case 6: 
            case 7: {
                ((DbReal)dbValue).set(pJFDataInput.readFloat());
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbValue).set(pJFDataInput.readBigDecimal(dbValue.getScale()));
                break;
            }
            case 8: {
                double d = pJFDataInput.readDouble();
                ((DbDouble)dbValue).set(d);
                break;
            }
            case -7: {
                ((DbBit)dbValue).set(pJFDataInput.readBoolean());
                break;
            }
            case 93: {
                ((DbTimestamp)dbValue).set(pJFDataInput.readLong());
                ((DbTimestamp)dbValue).setNanos(pJFDataInput.readInt());
                break;
            }
            case 1: 
            case 12: {
                int n3 = pJFDataInput.getVersion();
                if (n3 == 0 || n3 >= 262145) {
                    ((DbChar)dbValue).setRaw(pJFDataInput.readVariantBinary());
                    break;
                }
                DbColDesc dbColDesc = dbValue.getColDesc();
                ((DbChar)dbValue).set(pJFDataInput.readFixedString(dbColDesc.getPrecision(), dbColDesc.getEncodingName()));
                break;
            }
            case -1: {
                ((DbChar)dbValue).setRaw(pJFDataInput.readVariantBinary());
                break;
            }
            case -3: {
                byte[] byArray = new byte[dbValue.getPrecision()];
                pJFDataInput.readFully(byArray);
                ((DbBinary)dbValue).set(byArray);
                break;
            }
            case -4: {
                ((DbBinary)dbValue).set(pJFDataInput.readVariantBinary());
            }
        }
    }

    public static final void readArray(DbValue dbValue, PJFDataInput pJFDataInput) throws IOException {
        int n = dbValue.getSqlType();
        Object[] objectArray = null;
        int[] nArray = null;
        int n2 = pJFDataInput.readInt();
        switch (n) {
            case -7: {
                objectArray = new boolean[n2];
                int n3 = 0;
                while (n3 < n2) {
                    objectArray[n3] = pJFDataInput.readBoolean();
                    ++n3;
                }
                break;
            }
            case -6: {
                objectArray = new byte[n2];
                int n4 = 0;
                while (n4 < n2) {
                    ((byte[])objectArray)[n4] = pJFDataInput.readByte();
                    ++n4;
                }
                break;
            }
            case 5: {
                objectArray = new short[n2];
                int n5 = 0;
                while (n5 < n2) {
                    ((short[])objectArray)[n5] = pJFDataInput.readShort();
                    ++n5;
                }
                break;
            }
            case 4: {
                objectArray = new int[n2];
                int n6 = 0;
                while (n6 < n2) {
                    ((int[])objectArray)[n6] = pJFDataInput.readInt();
                    ++n6;
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                objectArray = new long[n2];
                int n7 = 0;
                while (n7 < n2) {
                    ((long[])objectArray)[n7] = pJFDataInput.readLong();
                    ++n7;
                }
                break;
            }
            case 93: {
                objectArray = new long[n2];
                nArray = new int[n2];
                int n8 = 0;
                while (n8 < n2) {
                    ((long[])objectArray)[n8] = pJFDataInput.readLong();
                    nArray[n8] = pJFDataInput.readInt();
                    ++n8;
                }
                ((DbArray)dbValue).setNanos(nArray);
                break;
            }
            case 6: 
            case 7: {
                objectArray = new float[n2];
                int n9 = 0;
                while (n9 < n2) {
                    ((float[])objectArray)[n9] = pJFDataInput.readFloat();
                    ++n9;
                }
                break;
            }
            case 8: {
                objectArray = new double[n2];
                int n10 = 0;
                while (n10 < n2) {
                    ((double[])objectArray)[n10] = pJFDataInput.readDouble();
                    ++n10;
                }
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n2];
                int n11 = 0;
                while (n11 < n2) {
                    ((BigDecimal[])objectArray)[n11] = new BigDecimal(pJFDataInput.readUTF());
                    ++n11;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                objectArray = new String[n2];
                int n12 = 0;
                while (n12 < n2) {
                    ((String[])objectArray)[n12] = pJFDataInput.readUTF();
                    ++n12;
                }
                break;
            }
        }
        ((DbArray)dbValue).setValue(objectArray, n2);
    }
}

