/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbBuffer;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine8.util.dataswap.ArrayTool;
import jet.ie.PJFAux;

public class RecordDataTool {
    private int QOIV = 0;
    private int abs = 0;
    private final int append;
    private final int array2Bytes;
    private byte[] arraycopy = null;
    private boolean bytes2Array = false;
    private int dataLength = 0;
    private int[] decimalNeedBytes = null;
    private int[] doubleToRawLongBits = null;
    private int floatToIntBits = 0;

    public RecordDataTool(RecordModelInfo recordModelInfo) {
        this.append = recordModelInfo.getColDescs().length;
        this.QOIV = this.array2Bytes = this.append << 2;
        this.decimalNeedBytes = new int[this.append + 1];
        this.doubleToRawLongBits = new int[this.append + 1];
        int n = 1;
        while (n <= this.append) {
            DbColDesc dbColDesc = recordModelInfo.getColDesc(n - 1);
            this.decimalNeedBytes[n] = Types.sqlTypeToType(dbColDesc.getSqlType());
            this.doubleToRawLongBits[n] = this.QOIV(dbColDesc.isReadOnly(), this.decimalNeedBytes[n]);
            this.floatToIntBits += Types.swapDataLength(this.decimalNeedBytes[n]) + 4;
            ++n;
        }
        this.arraycopy = new byte[this.floatToIntBits];
    }

    private int QOIV(boolean bl, int n) {
        if (bl) {
            return 0;
        }
        int n2 = Types.dataLength(n);
        return n2;
    }

    public byte[] getRecordData() {
        return this.arraycopy;
    }

    public int getRecordSize() {
        return this.QOIV;
    }

    public void resetRecordSize(int n) {
        this.arraycopy = new byte[n];
    }

    public void setDataLength(int n) {
        this.dataLength = n;
        this.reset();
    }

    public void setRecord(byte[] byArray) {
        if (this.arraycopy.length < byArray.length) {
            byte[] byArray2 = new byte[byArray.length];
            this.arraycopy = byArray2;
        }
        System.arraycopy(byArray, 0, this.arraycopy, 0, byArray.length);
    }

    public void putByte(byte by) {
        this.floatToIntBits(1);
        this.get(this.abs++, this.QOIV);
        this.getColLength(-6);
        this.arraycopy[this.QOIV++] = by;
    }

    public byte getByte(int n) {
        return this.abs(-6, n);
    }

    private byte abs(int n, int n2) {
        this.getDate(n, n2);
        int n3 = this.getColDesc(n2);
        this.bytes2Array = this.getColDescs(n2);
        if (this.bytes2Array) {
            return 0;
        }
        return this.arraycopy[n3 + 1];
    }

    public void putBoolean(boolean bl) {
        this.floatToIntBits(1);
        this.get(this.abs++, this.QOIV);
        this.getColLength(-7);
        this.arraycopy[this.QOIV++] = bl ? (byte)1 : 0;
    }

    public boolean getBoolean(int n) {
        return this.abs(-7, n) == 1;
    }

    public void putShort(short s) {
        this.floatToIntBits(2);
        this.get(this.abs++, this.QOIV);
        this.getColLength(5);
        this.arraycopy[this.QOIV++] = (byte)s;
        this.arraycopy[this.QOIV++] = (byte)(s >> 8);
    }

    public short getShort(int n) {
        this.getDate(5, n);
        int n2 = this.getColDesc(n);
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return 0;
        }
        return (short)(this.arraycopy[n2 + 2] << 8 | this.arraycopy[n2 + 1] & 0xFF);
    }

    public void putInt(int n) {
        this.floatToIntBits(4);
        this.get(this.abs++, this.QOIV);
        this.getColLength(4);
        this.arraycopy[this.QOIV++] = (byte)n;
        this.arraycopy[this.QOIV++] = (byte)(n >> 8);
        this.arraycopy[this.QOIV++] = (byte)(n >> 16);
        this.arraycopy[this.QOIV++] = (byte)(n >> 24);
    }

    public int getInt(int n) {
        this.getDate(4, n);
        int n2 = this.getColDesc(n);
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return 0;
        }
        return this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF;
    }

    public void putFloat(float f) {
        this.floatToIntBits(4);
        this.get(this.abs++, this.QOIV);
        this.getColLength(6);
        int n = Float.floatToIntBits(f);
        this.arraycopy[this.QOIV++] = (byte)n;
        this.arraycopy[this.QOIV++] = (byte)(n >> 8);
        this.arraycopy[this.QOIV++] = (byte)(n >> 16);
        this.arraycopy[this.QOIV++] = (byte)(n >> 24);
    }

    public float getFloat(int n) {
        this.getDate(6, n);
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return 0.0f;
        }
        int n2 = this.getColDesc(n);
        return Float.intBitsToFloat(this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF);
    }

    public void putLong(long l) {
        this.floatToIntBits(8);
        this.get(this.abs++, this.QOIV);
        this.getColLength(-5);
        this.arraycopy[this.QOIV++] = (byte)l;
        this.arraycopy[this.QOIV++] = (byte)(l >> 8);
        this.arraycopy[this.QOIV++] = (byte)(l >> 16);
        this.arraycopy[this.QOIV++] = (byte)(l >> 24);
        this.arraycopy[this.QOIV++] = (byte)(l >> 32);
        this.arraycopy[this.QOIV++] = (byte)(l >> 40);
        this.arraycopy[this.QOIV++] = (byte)(l >> 48);
        this.arraycopy[this.QOIV++] = (byte)(l >> 56);
    }

    private final void append(long l, int n) {
        this.floatToIntBits(8);
        this.get(this.abs++, this.QOIV);
        this.getColLength(n);
        this.arraycopy[this.QOIV++] = (byte)l;
        this.arraycopy[this.QOIV++] = (byte)(l >> 8);
        this.arraycopy[this.QOIV++] = (byte)(l >> 16);
        this.arraycopy[this.QOIV++] = (byte)(l >> 24);
        this.arraycopy[this.QOIV++] = (byte)(l >> 32);
        this.arraycopy[this.QOIV++] = (byte)(l >> 40);
        this.arraycopy[this.QOIV++] = (byte)(l >> 48);
        this.arraycopy[this.QOIV++] = (byte)(l >> 56);
    }

    public long getLong(int n) {
        return this.array2Bytes(-5, n);
    }

    private long array2Bytes(int n, int n2) {
        this.getDate(n, n2);
        this.bytes2Array = this.getColDescs(n2);
        if (this.bytes2Array) {
            return 0L;
        }
        int n3 = this.getColDesc(n2);
        return (long)this.arraycopy[n3 + 8] << 56 | ((long)this.arraycopy[n3 + 7] & 0xFFL) << 48 | ((long)this.arraycopy[n3 + 6] & 0xFFL) << 40 | ((long)this.arraycopy[n3 + 5] & 0xFFL) << 32 | ((long)this.arraycopy[n3 + 4] & 0xFFL) << 24 | ((long)this.arraycopy[n3 + 3] & 0xFFL) << 16 | ((long)this.arraycopy[n3 + 2] & 0xFFL) << 8 | (long)this.arraycopy[n3 + 1] & 0xFFL;
    }

    public void putDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        this.append(l, 8);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.array2Bytes(8, n));
    }

    public void putBigDecimal(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        this.floatToIntBits(n + 4);
        this.get(this.abs++, this.QOIV);
        this.getColLength(3);
        int n2 = bigDecimal.scale();
        this.arraycopy[this.QOIV++] = (byte)n2;
        this.arraycopy[this.QOIV++] = (byte)(n2 >> 8);
        this.arraycopy[this.QOIV++] = (byte)(n2 >> 16);
        this.arraycopy[this.QOIV++] = (byte)(n2 >> 24);
        int n3 = 0;
        while (n3 < n) {
            this.arraycopy[this.QOIV++] = byArray[n3];
            ++n3;
        }
    }

    public BigDecimal getBigDecimal(int n) {
        this.getDate(3, n);
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return null;
        }
        int n2 = this.getColDesc(n);
        int n3 = this.getDataTypeName(n2, n);
        int n4 = this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF;
        byte[] byArray = new byte[n3 - 4];
        int n5 = 0;
        int n6 = n2 + 5;
        while (n5 < byArray.length) {
            byArray[n5] = this.arraycopy[n6];
            ++n5;
            ++n6;
        }
        return new BigDecimal(new BigInteger(byArray), n4);
    }

    public void putDate(Date date) {
        this.append(date.getTime(), 91);
    }

    public void putDate(long l) {
        this.append(l, 91);
    }

    public Date getDate(int n) {
        return new JinfonetDate(this.array2Bytes(91, n));
    }

    public void putTimeStamp(Timestamp timestamp) {
        this.append(timestamp.getTime(), 93);
    }

    public void putTimeStamp(long l) {
        this.append(l, 93);
    }

    public Timestamp getTimeStamp(int n) {
        return new JinfonetTimeStamp(this.array2Bytes(93, n));
    }

    public void putTime(Time time2) {
        this.append(time2.getTime(), 92);
    }

    public void putTime(long l) {
        this.append(l, 92);
    }

    public Time getTime(int n) {
        return new JinfonetTime(this.array2Bytes(92, n));
    }

    public void putString(String string) {
        byte[] byArray = null;
        if (string != null) {
            try {
                byArray = string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        this.dataLength(byArray, 12);
    }

    public String getString(int n) {
        byte[] byArray = this.decimalNeedBytes(12, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return byArray == null ? null : new String(byArray);
        }
    }

    public void putBlob(Blob blob) throws DSException {
        if (blob == null) {
            this.putNull(-2);
            return;
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        this.putBytes(byArray);
    }

    public Blob getBlob(int n) {
        this.getDate(2004, n);
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return null;
        }
        byte[] byArray = this.arraycopy(n);
        return new JinfonetBlobBaseBytes(byArray);
    }

    private byte[] arraycopy(int n) {
        int n2 = this.getColDesc(n);
        int n3 = this.getDataTypeName(n2, n);
        if (n3 < 0) {
            this.getDataTypeName(n2, n);
        }
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return null;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.arraycopy, n2 + 1, byArray, 0, n3);
        return byArray;
    }

    public void putClob(Clob clob) throws DSException {
        if (clob == null) {
            this.putNull(12);
            return;
        }
        this.putString(clob.getSubString(1L, (int)clob.length()));
    }

    public Clob getClob(int n) {
        this.getDate(2005, n);
        this.bytes2Array = this.getColDescs(n);
        if (this.bytes2Array) {
            return null;
        }
        String string = this.bytes2Array(n);
        return new JinfonetClobBaseString(string);
    }

    private String bytes2Array(int n) {
        byte[] byArray = this.decimalNeedBytes(2005, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return byArray == null ? null : new String(byArray);
        }
    }

    public void putBytes(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.floatToIntBits(byArray.length);
        this.get(this.abs++, this.QOIV);
        this.getColLength(-2);
        int n = 0;
        while (n < byArray.length) {
            this.arraycopy[this.QOIV++] = byArray[n];
            ++n;
        }
    }

    private void dataLength(byte[] byArray, int n) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.floatToIntBits(byArray.length);
        this.get(this.abs++, this.QOIV);
        this.getColLength(n);
        int n2 = 0;
        while (n2 < byArray.length) {
            this.arraycopy[this.QOIV++] = byArray[n2];
            ++n2;
        }
    }

    public byte[] getBytes(int n) {
        return this.decimalNeedBytes(-2, n);
    }

    private byte[] decimalNeedBytes(int n, int n2) {
        this.getDate(n, n2);
        this.bytes2Array = this.getColDescs(n2);
        if (this.bytes2Array) {
            return null;
        }
        int n3 = this.getColDesc(n2);
        int n4 = this.getDataTypeName(n3, n2);
        byte[] byArray = new byte[n4];
        System.arraycopy(this.arraycopy, n3 + 1, byArray, 0, n4);
        return byArray;
    }

    public int putRecord() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.abs = 0;
        this.QOIV = this.array2Bytes;
        this.bytes2Array = false;
    }

    public void putNull(int n) {
        this.floatToIntBits(0);
        this.get(this.abs++, -this.QOIV);
        this.getColLength(n);
        this.QOIV += this.doubleToRawLongBits[this.abs];
    }

    public boolean wasNull() {
        return this.bytes2Array;
    }

    private int doubleToRawLongBits(int n) {
        if (n <= 500) {
            return (int)(2.0f * (float)n);
        }
        if (n <= 1000) {
            return (int)(1.5f * (float)n);
        }
        return (int)(1.2f * (float)n);
    }

    private void floatToIntBits(int n) {
        if (this.arraycopy.length <= this.QOIV + n) {
            byte[] byArray = new byte[this.doubleToRawLongBits(this.QOIV + n)];
            System.arraycopy(this.arraycopy, 0, byArray, 0, this.arraycopy.length);
            this.arraycopy = byArray;
        }
    }

    private void get(int n, int n2) {
        int n3 = n << 2;
        this.arraycopy[n3] = (byte)n2;
        this.arraycopy[n3 + 1] = (byte)(n2 >> 8);
        this.arraycopy[n3 + 2] = (byte)(n2 >> 16);
        this.arraycopy[n3 + 3] = (byte)(n2 >> 24);
    }

    private int getColDesc(int n) {
        if (n < 1 || n > this.append) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.append);
        }
        int n2 = n - 1 << 2;
        int n3 = this.arraycopy[n2 + 3] << 24 | (this.arraycopy[n2 + 2] & 0xFF) << 16 | (this.arraycopy[n2 + 1] & 0xFF) << 8 | this.arraycopy[n2] & 0xFF;
        return Math.abs(n3);
    }

    private boolean getColDescs(int n) {
        if (n < 1 || n > this.append) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.append);
        }
        int n2 = n - 1 << 2;
        return this.arraycopy[n2 + 3] < 0;
    }

    private void getColLength(int n) {
        this.arraycopy[this.QOIV++] = (byte)n;
    }

    private int getDataTypeName(int n, int n2) {
        if (n2 == this.append) {
            return this.dataLength - n - 1;
        }
        return Math.abs(this.getColDesc(n2 + 1)) - n - 1;
    }

    public Object getObject(int n) throws DSException {
        int n2 = this.decimalNeedBytes[n];
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 93: {
                return this.getTimeStamp(n);
            }
            case 92: {
                return this.getTime(n);
            }
        }
        throw new DSException(5859, new String[]{" Unkonw dataType in getObject(). ColumnIndex: " + n + "; data type: " + n2});
    }

    public boolean isNull(int n) {
        return this.getColDescs(n);
    }

    private void getDate(int n, int n2) {
        if (n2 < 1 || n2 > this.append) {
            throw new IllegalStateException("columnIndex " + n2 + " Out of range , current range is :" + this.append);
        }
        if (n != this.decimalNeedBytes[n2]) {
            throw new IllegalStateException("violation data type. indicate " + Types.getDataTypeName(n) + ", but " + Types.getDataTypeName(this.decimalNeedBytes[n2]));
        }
    }

    public void close() {
        this.arraycopy = null;
        this.decimalNeedBytes = null;
    }

    public void putArray(Array array) throws DSException {
        byte[] byArray = ArrayTool.array2Bytes(array);
        this.dataLength(byArray, 2003);
    }

    public Array getArray(int n) {
        byte[] byArray = this.decimalNeedBytes(2003, n);
        return byArray == null ? null : ArrayTool.bytes2Array(byArray);
    }

    public static final void writeDbValue(DbValue dbValue, DataOutput dataOutput) throws IOException {
        boolean bl = dbValue.isNull();
        dataOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            byte[] byArray = new byte[PJFAux.getColLength(dbValue.getColDesc())];
            dataOutput.write(byArray);
            return;
        }
        if (dbValue.getColDesc().isArray()) {
            RecordDataTool.writeArray(dbValue, dataOutput);
            return;
        }
        int n = dbValue.getSqlType();
        switch (n) {
            case 5: {
                dataOutput.writeShort(((DbSmallInt)dbValue).get());
                break;
            }
            case -6: {
                dataOutput.writeByte(((DbTinyInt)dbValue).get());
                break;
            }
            case 4: {
                dataOutput.writeInt(((DbInteger)dbValue).get());
                break;
            }
            case 91: 
            case 92: {
                dataOutput.writeLong(((DbDateTime)dbValue).get());
                break;
            }
            case -5: {
                dataOutput.writeLong(((DbBigInt)dbValue).get());
                break;
            }
            case 6: 
            case 7: {
                dataOutput.writeFloat(((DbReal)dbValue).get());
                break;
            }
            case 2: 
            case 3: {
                int n2 = DbBuffer.decimalNeedBytes(dbValue.getColDesc());
                RecordDataTool.writeBigDecimal(((DbDecimal)dbValue).get(), dbValue.getScale(), n2, dataOutput);
                break;
            }
            case 8: {
                dataOutput.writeDouble(((DbDouble)dbValue).get());
                break;
            }
            case -7: {
                dataOutput.writeBoolean(((DbBit)dbValue).get());
                break;
            }
            case 93: {
                dataOutput.writeLong(((DbTimestamp)dbValue).get());
                dataOutput.writeInt(((DbTimestamp)dbValue).getNanos());
                break;
            }
            case 1: 
            case 12: {
                String string = ((DbChar)dbValue).get();
                RecordDataTool.writeVariantBinary(string.getBytes("utf-8"), dataOutput);
                break;
            }
            case -1: {
                RecordDataTool.writeVariantBinary(((DbChar)dbValue).get().getBytes("utf-8"), dataOutput);
                break;
            }
            case -3: {
                RecordDataTool.writeFixedBinary(((DbBinary)dbValue).get(), dbValue.getPrecision(), dataOutput);
                break;
            }
            case -4: {
                RecordDataTool.writeVariantBinary(((DbBinary)dbValue).get(), dataOutput);
            }
        }
    }

    public static final void writeArray(DbValue dbValue, DataOutput dataOutput) throws IOException {
        int n = dbValue.getSqlType();
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(blArray.length);
                int n2 = 0;
                while (n2 < blArray.length) {
                    dataOutput.writeBoolean(blArray[n2]);
                    ++n2;
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(byArray.length);
                int n3 = 0;
                while (n3 < byArray.length) {
                    dataOutput.writeByte(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(sArray.length);
                int n4 = 0;
                while (n4 < sArray.length) {
                    dataOutput.writeShort(sArray[n4]);
                    ++n4;
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(nArray.length);
                int n5 = 0;
                while (n5 < nArray.length) {
                    dataOutput.writeInt(nArray[n5]);
                    ++n5;
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(lArray.length);
                int n6 = 0;
                while (n6 < lArray.length) {
                    dataOutput.writeLong(lArray[n6]);
                    ++n6;
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                dataOutput.writeInt(lArray.length);
                int n7 = 0;
                while (n7 < lArray.length) {
                    dataOutput.writeLong(lArray[n7]);
                    dataOutput.writeInt(nArray[n7]);
                    ++n7;
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(fArray2.length);
                int n8 = 0;
                while (n8 < fArray2.length) {
                    dataOutput.writeFloat(fArray2[n8]);
                    ++n8;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(dArray.length);
                int n9 = 0;
                while (n9 < dArray.length) {
                    dataOutput.writeDouble(dArray[n9]);
                    ++n9;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(bigDecimalArray.length);
                int n10 = 0;
                while (n10 < bigDecimalArray.length) {
                    dataOutput.writeUTF(bigDecimalArray[n10].toString());
                    ++n10;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(stringArray.length);
                int n11 = 0;
                while (n11 < stringArray.length) {
                    dataOutput.writeUTF(stringArray[n11]);
                    ++n11;
                }
                break;
            }
        }
    }

    public static void writeBigDecimal(BigDecimal bigDecimal, int n, int n2, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(n2);
        byte[] byArray = new byte[n2];
        if (bigDecimal == null) {
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = 32;
                ++n3;
            }
        } else {
            byte[] byArray2 = bigDecimal.movePointRight(n).toBigInteger().toByteArray();
            int n4 = (byArray2[0] & 0x80) != 128 ? 0 : -1;
            int n5 = 0;
            while (n5 < n2) {
                byArray[n5] = n4;
                ++n5;
            }
            System.arraycopy(byArray2, 0, byArray, n2 - byArray2.length, byArray2.length);
        }
        dataOutput.write(byArray);
    }

    public static void writeVariantBinary(byte[] byArray, DataOutput dataOutput) throws IOException {
        int n = byArray.length;
        dataOutput.writeInt(n);
        dataOutput.write(byArray, 0, n);
    }

    public static void writeFixedBinary(byte[] byArray, int n, DataOutput dataOutput) throws IOException {
        int n2 = byArray.length > n ? n : byArray.length;
        dataOutput.writeShort(n2);
        dataOutput.write(byArray, 0, n2);
        int n3 = 0;
        while (n3 < n - n2) {
            dataOutput.writeByte(0);
            ++n3;
        }
    }

    public static final void readDbValue(DbValue dbValue, DataInput dataInput, int n) throws IOException {
        boolean bl;
        byte by = dataInput.readByte();
        boolean bl2 = bl = by == 1;
        if (bl) {
            byte[] byArray = new byte[PJFAux.getColLength(dbValue.getColDesc())];
            dataInput.readFully(byArray);
            return;
        }
        if (dbValue.getColDesc().isArray()) {
            RecordDataTool.readArray(dbValue, dataInput);
            return;
        }
        int n2 = dbValue.getSqlType();
        switch (n2) {
            case 5: {
                ((DbSmallInt)dbValue).set(dataInput.readShort());
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(dataInput.readByte());
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(dataInput.readInt());
                break;
            }
            case 91: 
            case 92: {
                ((DbDateTime)dbValue).set(dataInput.readLong());
                break;
            }
            case -5: {
                ((DbBigInt)dbValue).set(dataInput.readLong());
                break;
            }
            case 6: 
            case 7: {
                ((DbReal)dbValue).set(dataInput.readFloat());
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbValue).set(RecordDataTool.getFloat(dbValue.getScale(), dataInput));
                break;
            }
            case 8: {
                double d = dataInput.readDouble();
                ((DbDouble)dbValue).set(d);
                break;
            }
            case -7: {
                ((DbBit)dbValue).set(dataInput.readBoolean());
                break;
            }
            case 93: {
                ((DbTimestamp)dbValue).set(dataInput.readLong());
                ((DbTimestamp)dbValue).setNanos(dataInput.readInt());
                break;
            }
            case 1: 
            case 12: {
                if (n >= 262400) {
                    ((DbChar)dbValue).set(new String(RecordDataTool.getDouble(dataInput), "utf-8"));
                    break;
                }
                ((DbChar)dbValue).setRaw(RecordDataTool.getDouble(dataInput));
                break;
            }
            case -1: {
                if (n >= 262400) {
                    ((DbChar)dbValue).set(new String(RecordDataTool.getDouble(dataInput), "utf-8"));
                    break;
                }
                ((DbChar)dbValue).setRaw(RecordDataTool.getDouble(dataInput));
                break;
            }
            case -3: {
                byte[] byArray = new byte[dbValue.getPrecision()];
                dataInput.readFully(byArray);
                ((DbBinary)dbValue).set(byArray);
                break;
            }
            case -4: {
                ((DbBinary)dbValue).set(RecordDataTool.getDouble(dataInput));
            }
        }
    }

    private static byte[] getDouble(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        return byArray;
    }

    private static BigDecimal getFloat(int n, DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        byte[] byArray = new byte[s];
        dataInput.readFully(byArray, 0, s);
        return new BigDecimal(new BigInteger(byArray), n);
    }

    public static final void readArray(DbValue dbValue, DataInput dataInput) throws IOException {
        int n = dbValue.getSqlType();
        Object[] objectArray = null;
        int[] nArray = null;
        int n2 = dataInput.readInt();
        switch (n) {
            case -7: {
                objectArray = new boolean[n2];
                int n3 = 0;
                while (n3 < n2) {
                    objectArray[n3] = dataInput.readBoolean();
                    ++n3;
                }
                break;
            }
            case -6: {
                objectArray = new byte[n2];
                int n4 = 0;
                while (n4 < n2) {
                    ((byte[])objectArray)[n4] = dataInput.readByte();
                    ++n4;
                }
                break;
            }
            case 5: {
                objectArray = new short[n2];
                int n5 = 0;
                while (n5 < n2) {
                    ((short[])objectArray)[n5] = dataInput.readShort();
                    ++n5;
                }
                break;
            }
            case 4: {
                objectArray = new int[n2];
                int n6 = 0;
                while (n6 < n2) {
                    ((int[])objectArray)[n6] = dataInput.readInt();
                    ++n6;
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                objectArray = new long[n2];
                int n7 = 0;
                while (n7 < n2) {
                    ((long[])objectArray)[n7] = dataInput.readLong();
                    ++n7;
                }
                break;
            }
            case 93: {
                objectArray = new long[n2];
                nArray = new int[n2];
                int n8 = 0;
                while (n8 < n2) {
                    ((long[])objectArray)[n8] = dataInput.readLong();
                    nArray[n8] = dataInput.readInt();
                    ++n8;
                }
                ((DbArray)dbValue).setNanos(nArray);
                break;
            }
            case 6: 
            case 7: {
                objectArray = new float[n2];
                int n9 = 0;
                while (n9 < n2) {
                    ((float[])objectArray)[n9] = dataInput.readFloat();
                    ++n9;
                }
                break;
            }
            case 8: {
                objectArray = new double[n2];
                int n10 = 0;
                while (n10 < n2) {
                    ((double[])objectArray)[n10] = dataInput.readDouble();
                    ++n10;
                }
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n2];
                int n11 = 0;
                while (n11 < n2) {
                    ((BigDecimal[])objectArray)[n11] = new BigDecimal(dataInput.readUTF());
                    ++n11;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                objectArray = new String[n2];
                int n12 = 0;
                while (n12 < n2) {
                    ((String[])objectArray)[n12] = dataInput.readUTF();
                    ++n12;
                }
                break;
            }
        }
        ((DbArray)dbValue).setValue(objectArray, n2);
    }
}

