/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.ie.io.RAStreamInput;
import jet.net2.ConnectionListener;
import jet.net2.URL;
import jet.net2.www.protocol.http.HttpURLConnection;
import jet.util.IntVector;
import jet.util.RandomInputable;
import jet.util.TempFile;

public class RAHTTPInput
implements RandomInputable,
Runnable,
ConnectionListener {
    int QOIV;
    byte[] addConnectionListener;
    URL append;
    int arraycopy;
    int charAt = 0;
    int close = -1;
    int communicate = -1;
    File convertEscapes;
    RandomAccessFile createTempFile;
    IntVector delete;
    private int disconnect = 200;
    private String elementAt = null;
    private int get;
    private boolean getContentLength = false;
    private URLConnection getHeaderField = null;
    private boolean getHeaderFieldInt;
    private URL getHost;

    public RAHTTPInput(java.net.URL uRL) {
        this(uRL, 40960);
    }

    public RAHTTPInput(java.net.URL uRL, String string, int n) {
        this(uRL);
        this.elementAt = string;
        this.get = n;
        HttpURLConnection.addConnectionListener(this);
        try {
            this.getHost = new URL(uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + "/?" + "jrs.cmd" + "=" + "jrs.handshake");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.getHeaderFieldInt = true;
    }

    public RAHTTPInput(java.net.URL uRL, int n) {
        this.append = new URL(uRL);
        this.arraycopy = n;
        try {
            this.convertEscapes = new TempFile(ReportEnv.temporaryPath, "raf").createTempFile();
            this.createTempFile = new RandomAccessFile(this.convertEscapes, "rw");
            this.addConnectionListener = new byte[n];
        }
        catch (Throwable throwable) {
            this.convertEscapes = null;
            this.createTempFile = null;
        }
        this.delete = new IntVector(2);
        this.charAt = 0;
        this.close = -1;
        this.QOIV = 0;
        this.communicate = -1;
    }

    public synchronized void close() throws IOException {
        if (this.createTempFile != null) {
            this.createTempFile.close();
            this.convertEscapes.delete();
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HttpURLConnection.removeConnectionListener(this);
    }

    public synchronized int read() throws IOException {
        if (this.QOIV < this.charAt || this.QOIV >= this.charAt + this.close) {
            this.addConnectionListener(this.QOIV);
        }
        if (this.QOIV >= this.communicate) {
            return -1;
        }
        int n = this.createTempFile != null ? this.addConnectionListener[this.QOIV - this.charAt] & 0xFF : this.addConnectionListener[this.QOIV] & 0xFF;
        ++this.QOIV;
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.QOIV < this.charAt || this.QOIV >= this.charAt + this.close) {
            this.addConnectionListener(this.QOIV);
        }
        if (this.close == 0) {
            return -1;
        }
        int n5 = 0;
        while ((n4 = Math.min(n2 - n5, this.close - (n3 = this.QOIV - this.charAt))) > 0) {
            if (this.createTempFile != null) {
                System.arraycopy(this.addConnectionListener, n3, byArray, n + n5, n4);
            } else {
                System.arraycopy(this.addConnectionListener, this.QOIV, byArray, n + n5, n4);
            }
            n5 += n4;
            this.QOIV += n4;
            this.addConnectionListener(this.QOIV);
        }
        return n5;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized void saveTo(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        this.QOIV();
        if (this.createTempFile == null) {
            randomAccessFile.write(this.addConnectionListener, 0, this.addConnectionListener.length);
        } else {
            byte[] byArray = new byte[40960];
            this.createTempFile.seek(0L);
            int n = 0;
            while ((n = this.createTempFile.read(byArray, 0, 40960)) > 0) {
                randomAccessFile.write(byArray, 0, n);
            }
        }
        randomAccessFile.close();
    }

    public synchronized void seek(long l) throws IOException {
        this.QOIV = (int)l;
    }

    public synchronized long getPosition() throws IOException {
        return this.QOIV;
    }

    public synchronized long length() throws IOException {
        if (this.communicate >= 0) {
            return this.communicate;
        }
        URLConnection uRLConnection = this.communicate(this.append, "Range", "bytes=0-0");
        int n = uRLConnection.getContentLength();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        switch (RAHTTPInput.getResponseCode(uRLConnection)) {
            case 200: {
                this.communicate = n;
                if (this.createTempFile != null) {
                    this.createTempFile.seek(0L);
                    int n2 = n / this.arraycopy;
                    int n3 = 0;
                    while (n3 < n2) {
                        dataInputStream.readFully(this.addConnectionListener, 0, this.arraycopy);
                        this.createTempFile.write(this.addConnectionListener, 0, this.arraycopy);
                        ++n3;
                    }
                    int n4 = n % this.arraycopy;
                    if (n4 > 0) {
                        dataInputStream.readFully(this.addConnectionListener, 0, n4);
                        this.createTempFile.write(this.addConnectionListener, 0, n4);
                    }
                } else {
                    this.addConnectionListener = new byte[this.communicate];
                    dataInputStream.readFully(this.addConnectionListener, 0, this.communicate);
                }
                this.append(0, this.communicate);
                this.disconnect(uRLConnection);
                break;
            }
            case 206: {
                String string = uRLConnection.getHeaderField("Content-Range");
                try {
                    this.communicate = Integer.parseInt(string.substring(string.indexOf(47) + 1));
                }
                catch (Throwable throwable) {
                    throw new ProtocolException("Unknown Range field:" + string);
                }
                if (this.createTempFile == null) {
                    this.addConnectionListener = new byte[this.communicate];
                }
                this.disconnect(uRLConnection);
                break;
            }
            default: {
                this.disconnect(uRLConnection);
                throw new ProtocolException(this.charAt(uRLConnection));
            }
        }
        return this.communicate;
    }

    private void QOIV() throws IOException {
        if (this.communicate < 0) {
            this.length();
        }
        if (this.communicate == 0) {
            return;
        }
        this.addConnectionListener(0);
        while (this.delete.elementAt(1) < this.communicate - 1) {
            this.addConnectionListener(this.delete.elementAt(1) + 1);
        }
    }

    private void addConnectionListener(int n) throws IOException {
        int n2;
        if (this.communicate < 0) {
            this.length();
        }
        if (this.charAt == (n2 = n / this.arraycopy * this.arraycopy) && this.close >= 0) {
            return;
        }
        this.charAt = n2;
        if (this.communicate == 0) {
            this.close = 0;
            return;
        }
        if (this.arraycopy(this.charAt)) {
            this.close = Math.min(this.arraycopy, this.communicate - this.charAt);
            if (this.close < 0) {
                this.close = 0;
            }
            if (this.createTempFile != null) {
                this.createTempFile.seek(this.charAt);
                if (this.close > this.createTempFile.read(this.addConnectionListener, 0, this.close)) {
                    throw new IOException("Bad cache file");
                }
            }
            return;
        }
        int n3 = Math.min(this.arraycopy, this.communicate - this.charAt);
        URLConnection uRLConnection = this.communicate(this.append, "Range", "bytes=" + this.charAt + "-" + (this.charAt + n3 - 1));
        switch (RAHTTPInput.getResponseCode(uRLConnection)) {
            case 206: {
                int n4;
                String string = uRLConnection.getHeaderField("Content-Range");
                try {
                    n4 = Integer.parseInt(string.substring(string.indexOf(47) + 1));
                }
                catch (Throwable throwable) {
                    this.disconnect(uRLConnection);
                    throw new ProtocolException("Unknown Range field:" + string);
                }
                if (n4 != this.communicate) {
                    this.disconnect(uRLConnection);
                    throw new ProtocolException("File length changed, old " + this.communicate + " new " + n4);
                }
                int n5 = uRLConnection.getContentLength();
                if (n5 != n3) {
                    this.disconnect(uRLConnection);
                    throw new ProtocolException("Unmatching length for data, wants " + n3 + ", server returns " + n5);
                }
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                if (this.createTempFile != null) {
                    dataInputStream.readFully(this.addConnectionListener, 0, n5);
                    this.createTempFile.seek(this.charAt);
                    this.createTempFile.write(this.addConnectionListener, 0, n5);
                } else {
                    dataInputStream.readFully(this.addConnectionListener, this.charAt, n5);
                }
                this.close = n5;
                this.append(this.charAt, n5);
                this.disconnect(uRLConnection);
                break;
            }
            default: {
                this.disconnect(uRLConnection);
                throw new ProtocolException(this.charAt(uRLConnection));
            }
        }
    }

    private void append(int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2 - 1;
        int n5 = this.delete.size();
        int n6 = n3;
        int n7 = -1;
        boolean bl = true;
        int n8 = 0;
        while (n8 < n5) {
            if (this.delete.elementAt(n8) <= n3 && this.delete.elementAt(n8 + 1) >= n3) {
                bl = false;
                n6 = this.delete.elementAt(n8);
                n7 = this.delete.elementAt(n8 + 1);
                break;
            }
            if (n4 < this.delete.elementAt(n8)) break;
            n8 += 2;
        }
        if (bl) {
            this.delete.insertElementAt(n3, n8);
            this.delete.insertElementAt(n4 + 1, n8 + 1);
            n5 += 2;
        }
        int n9 = n8 + 2;
        while (n9 < n5) {
            if (n4 + 1 < this.delete.elementAt(n8 + 2)) break;
            n7 = this.delete.elementAt(n8 + 3);
            this.delete.removeElementAt(n8 + 3);
            this.delete.removeElementAt(n8 + 2);
            n9 += 2;
            n9 += 2;
        }
        this.delete.setElementAt(Math.min(n3, n6), n8);
        this.delete.setElementAt(Math.max(n4 + 1, n7), n8 + 1);
    }

    private boolean arraycopy(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.delete.size()) {
            if (this.delete.elementAt(n2) <= n && n < this.delete.elementAt(n2 + 1)) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            ((java.net.HttpURLConnection)uRLConnection).setRequestMethod("GET");
        }
        String string = uRL.getHost();
        if (uRL.getPort() != 80) {
            string = string + ":" + uRL.getPort();
        }
        uRLConnection.setRequestProperty("Host", string);
        uRLConnection.setRequestProperty("Accept", "application/x_jreport");
        uRLConnection.setRequestProperty("User-Agent", "JRptClient/1.3");
        if (!this.getContentLength && this.elementAt != null) {
            uRLConnection.setRequestProperty("Cookie", this.elementAt);
        }
        return uRLConnection;
    }

    protected void disconnect(URLConnection uRLConnection) {
        try {
            InputStream inputStream = uRLConnection.getInputStream();
            inputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private String charAt(URLConnection uRLConnection) {
        try {
            int n;
            String string = "Error from server: " + RAHTTPInput.getResponseCode(uRLConnection) + ":" + RAHTTPInput.getResponseMessage(uRLConnection);
            String string2 = uRLConnection.getHeaderField("JRS-MESSAGE");
            if (string2 != null) {
                string = string + ", extra information: " + CSUtil.convertEscapes(string2);
            }
            if ((n = uRLConnection.getContentLength()) > 0) {
                byte[] byArray = new byte[n];
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                dataInputStream.readFully(byArray, 0, n);
                return string + "\n" + new String(byArray);
            }
            return string;
        }
        catch (IOException iOException) {
            return "No detailed information since cannot parse error information";
        }
    }

    public InputStream getInputStream() throws IOException {
        URLConnection uRLConnection = this.communicate(this.append, null);
        return uRLConnection.getInputStream();
    }

    public RandomInputable getRandomInputable() throws IOException {
        if (this.read() == 80 && this.read() == 75) {
            InputStream inputStream = this.getInputStream();
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            long l = zipEntry.getSize();
            this.close();
            return new RAStreamInput(zipInputStream, l);
        }
        this.seek(0L);
        return this;
    }

    protected URLConnection communicate(URL uRL, String string, String string2) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string, string2);
        return this.communicate(uRL, hashtable);
    }

    protected URLConnection communicate(URL uRL, Hashtable hashtable) throws IOException {
        int n;
        URLConnection uRLConnection;
        while (true) {
            uRLConnection = this.openConnection(uRL);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    uRLConnection.setRequestProperty(string, "" + hashtable.get(string));
                }
            }
            if ((n = RAHTTPInput.getResponseCode(uRLConnection)) != 202) break;
            this.disconnect(uRLConnection);
            try {
                this.wait(this.disconnect);
                continue;
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
        switch (n) {
            case 200: 
            case 206: {
                break;
            }
            default: {
                throw new ProtocolException(this.charAt(uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static int getResponseCode(URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            return ((java.net.HttpURLConnection)uRLConnection).getResponseCode();
        }
        try {
            String string = uRLConnection.getHeaderField(0);
            if (string == null) {
                return -1;
            }
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            int n2 = Integer.parseInt(string.substring(n, n + 3));
            return n2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    public static String getResponseMessage(URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            return ((java.net.HttpURLConnection)uRLConnection).getResponseMessage();
        }
        try {
            String string = uRLConnection.getHeaderField(0);
            if (string == null) {
                return "Null, no message";
            }
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            return string.substring(n + 4).trim();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void logout() {
        this.getHeaderFieldInt = false;
    }

    public void unauthorized(URLConnection uRLConnection) {
        this.getContentLength = true;
        this.getHeaderField = uRLConnection;
    }

    public boolean isUnauthorized(URLConnection uRLConnection) {
        return this.getHeaderField == uRLConnection && this.getHeaderField != null;
    }

    public void authorized(URLConnection uRLConnection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.getHeaderFieldInt) {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    this.wait(this.get);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.elementAt == null) continue;
            try {
                object = this.communicate(this.getHost, "JRS-HANDSHAKE-INTERVAL", "" + this.get);
                this.get = ((URLConnection)object).getHeaderFieldInt("JRS-HANDSHAKE-INTERVAL", this.get);
                this.disconnect((URLConnection)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public final synchronized int skipBytes(int n) throws IOException {
        this.QOIV += n;
        return n;
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        throw new RuntimeException("Unsupported mehtod");
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

