/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.io.File;
import java.util.Vector;
import jet.ReportEnv;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.jetc.JetCReader;
import jet.jetc.ReportLoader;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.report.JetRptArea;
import jet.report.JetRptBarcode;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggSpecialField;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptDBField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMap;
import jet.report.JetRptMapDBField;
import jet.report.JetRptMediaField;
import jet.report.JetRptParameterField;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSubReport;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.util.WildcardMatcher;

public class UpgradeName {
    private static JRLogger QOIV = JRLogger.getLogger((class$jet$report$UpgradeName == null ? (class$jet$report$UpgradeName = UpgradeName.class$("jet.report.UpgradeName")) : class$jet$report$UpgradeName).getName());
    static Class class$jet$report$UpgradeName;

    private static String QOIV(JetObject jetObject) {
        String string = null;
        if (jetObject instanceof JetRptCTHdDBField) {
            string = "CTDBField";
        } else if (jetObject instanceof JetRptCTAggSpecialField) {
            string = "CTAggSpecialField";
        } else if (jetObject instanceof JetRptCTAggField) {
            string = "CTAggField";
        } else if (jetObject instanceof JetRptMap) {
            string = "Map";
        } else if (jetObject instanceof JetRptMapDBField) {
            string = "MapDBField";
        } else if (jetObject instanceof JetRptMediaField) {
            string = "MediaField";
        } else if (jetObject instanceof JetRptBarcode) {
            string = "Barcode";
        } else if (jetObject instanceof JetRptDBField) {
            string = "DBField";
        } else if (jetObject instanceof JetRptArea) {
            string = "Area";
        } else if (jetObject instanceof JetRptParameterField) {
            string = "ParameterField";
        } else if (jetObject instanceof JetRptSystemField) {
            string = "SpecialField";
        } else if (jetObject instanceof JetRptSubReport) {
            string = "Subreport";
        }
        return string;
    }

    public static String getInstancePrefix(JetObject jetObject) {
        String string = UpgradeName.QOIV(jetObject);
        if (string == null) {
            string = jetObject.getInstancePrefix();
        }
        return string;
    }

    public static String getInstancePrefixTag(JetObject jetObject) {
        String string = UpgradeName.getInstancePrefix(jetObject);
        if (jetObject instanceof JetRptTextField && string.equals("Label")) {
            string = "TextField";
        }
        return string;
    }

    private static void UPDATENAME(JetObject jetObject, Vector vector) {
        String string = jetObject.getInstName();
        String string2 = string.toUpperCase();
        String string3 = UpgradeName.QOIV(jetObject);
        if (string3 != null && string2.startsWith(string3.toUpperCase()) || jetObject instanceof JetRptSystemField && string2.startsWith("SYSTEMFIELD")) {
            string2 = jetObject.getInstancePrefix();
            if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase(string)) {
                if (vector.contains(string2)) {
                    int n = 1;
                    while (vector.contains(string2 + n)) {
                        ++n;
                    }
                    string2 = string2 + n;
                }
                vector.add(string2);
                if (!string2.equalsIgnoreCase(string)) {
                    if (QOIV.isDebugEnabled()) {
                        QOIV.debug("Upgrade Name\n[" + string + "] upgrade to [" + string2 + "]");
                    }
                    jetObject.setInstName(string2);
                }
            } else if ((string2 == null || string2.length() == 0) && QOIV.isErrorEnabled()) {
                QOIV.error("Upgrade Name\nFail to change the " + string + "!");
            }
        }
        vector.add(string);
    }

    private static void Z(JetContainable jetContainable, Vector vector) {
        UpgradeName.UPDATENAME((JetObject)((Object)jetContainable), vector);
        Vector vector2 = jetContainable.getChildren();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetContainable) {
                UpgradeName.Z((JetContainable)((Object)jetObject), vector);
            } else {
                UpgradeName.UPDATENAME(jetObject, vector);
            }
            ++n2;
        }
    }

    public static void updateName(JetRootable jetRootable) {
        UpgradeName.Z((JetContainable)((Object)jetRootable), new Vector());
        ((JetObject)((Object)jetRootable)).createNamingSystem();
    }

    private static void add() {
        System.out.println("java -Dreporthome=<reportHome> jet.report.UpgradeName [-options] reportfiles");
        System.out.println("Usage: Update the name of DBFields in the report using the field name in catalog for exporting to XML file.");
        System.out.println("\n     <reportHome>\t specify the JReport install path.");
        System.out.println("     reportfiles\t Specify the location of the existing report.\n\t\t\t If the location is not specified, the current user path will be used.");
        System.out.println("If the report file is created by JReport Designer that is higher than build 589, please do not use this program.");
        System.out.println("\nwhere options include:");
        System.out.println("    -help\t\t Print this help message.");
        System.out.println("    -vDebug\t\t Enable output debug message.");
        System.out.println("    -vError\t\t Enable output error message.");
        System.out.println("    -log[:<file>] \t Output debug message to .\\UpgradeName.log or .\\<file>.");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-help")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            UpgradeName.add();
            return;
        }
        boolean bl2 = true;
        Object object4 = null;
        boolean bl3 = false;
        String string = "UpgradeName.log";
        int n2 = 0;
        boolean bl4 = false;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < stringArray.length && bl2) {
            block34: {
                if (stringArray[n3].equalsIgnoreCase("-vError")) {
                    n2 |= 4;
                    bl4 = true;
                } else if (stringArray[n3].equalsIgnoreCase("-vDebug")) {
                    n2 |= 1;
                    bl4 = true;
                } else if (stringArray[n3].toUpperCase().startsWith("-log".toUpperCase())) {
                    if (!stringArray[n3].equalsIgnoreCase("-log")) {
                        try {
                            if (stringArray[n3].charAt("-log".length()) == ':') {
                                string = stringArray[n3].substring("-log".length() + 1);
                                bl3 = true;
                                break block34;
                            }
                            bl2 = false;
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                    } else {
                        bl3 = true;
                    }
                } else {
                    object3 = stringArray[n3];
                    object2 = new File((String)object3);
                    if (object2.exists()) {
                        if (object2.isFile() && ((String)object3).endsWith(".cls".toLowerCase())) {
                            vector.add(object2.getAbsolutePath());
                        } else if (object4 == null && vector.isEmpty()) {
                            object4 = object3;
                        }
                    } else {
                        bl2 = false;
                    }
                }
            }
            ++n3;
        }
        if (!bl2) {
            UpgradeName.add();
            System.exit(1);
        }
        object3 = ReportEnv.checkEnv(new Object(), null, 0);
        if (ReportEnv.ie()) {
            System.out.println("This is an evaluation version.");
            System.exit(1);
        }
        if (bl3) {
            object2 = new File(string);
            if (object2.exists()) {
                object2.delete();
            }
            JRLoggingUtil.configLog(string);
        }
        JRLogger.setDebugLevel(n2);
        boolean bl5 = vector.isEmpty();
        if (object4 == null && bl5) {
            object4 = System.getProperty("user.dir");
        }
        if (bl5 && !((File)(object = new File((String)object4))).isFile()) {
            object2 = ((File)object).list(new WildcardMatcher("*.cls", false));
            int n4 = 0;
            while (n4 < ((String[])object2).length) {
                vector.addElement(object2[n4]);
                ++n4;
            }
        }
        if (!vector.isEmpty()) {
            int n5 = 0;
            JetObject.UPDATENAME = true;
            int n6 = 0;
            while (n6 < vector.size()) {
                block35: {
                    String string2 = null;
                    string2 = (String)vector.elementAt(n6);
                    if (object4 != null) {
                        string2 = new File((String)object4, string2).getAbsolutePath();
                    }
                    try {
                        File file = new File(string2);
                        JetCReader jetCReader = new JetCReader(file.getPath());
                        JetObject jetObject = new ReportLoader(file.getAbsolutePath()).loadNoInit();
                        if (jetObject instanceof JetRptReportPanel) {
                            object = (JetRptReportPanel)jetObject;
                            UpgradeName.updateName((JetRootable)object);
                            ((JetObject)object).createNamingSystem();
                            ReportLoader.save((JetObject)object, ((JetRptGroupPanel)object).getInstName(), string2);
                            ++n5;
                        }
                    }
                    catch (Exception exception) {
                        if (!QOIV.isErrorEnabled()) break block35;
                        QOIV.error("", exception);
                    }
                }
                ++n6;
            }
        } else {
            System.exit(0);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

