/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.properties.ChartAxisProperties;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.chart.JetChartGroupedProperties;
import jet.report.chart.JetChartPenStyle;
import jet.report.chart.JetChartTextStyle;

public class JetChartCategoryAxisProperties
extends JetChartGroupedProperties {
    public JetChartPenStyle axisPen;
    public JetBoolean showGrid;
    public JetChartPenStyle gridPen;
    public JetBoolean showTickMarkLabels;
    public JetChartPenStyle tickMarkPen;
    public JetEnumeration tickMarkType;
    public JetUnitNumber tickMarkLength;
    public JetChartTextStyle labelTextStyle;
    public JetNumber labelEveryNTickMarks;
    public JetNumber numOfLabels;
    public JetBoolean isBestEffort;
    public JetUnitNumber labelAxisGap;
    public JetEnumeration placement;
    public JetEnumeration minorTickMarkType;
    public JetUnitNumber minorTickMarkLength;
    public JetBoolean labelFontAutomaticOrientation;
    public JetBoolean showLabelTips;
    public JetEnumeration labelPosition;

    JetChartCategoryAxisProperties(JetObject jetObject, String string) {
        super(jetObject, "Axis" + string);
        this.axisPen = new JetChartPenStyle(jetObject, this.prefix);
        this.showGrid = new JetBoolean(jetObject, this.prefix + "ShowGrid", false);
        this.gridPen = new JetChartPenStyle(jetObject, this.prefix + "Grid");
        this.showTickMarkLabels = new JetBoolean(jetObject, this.prefix + "ShowTickMarkLabels", true);
        this.tickMarkPen = new JetChartPenStyle(jetObject, this.prefix + "TickMark");
        this.tickMarkType = new JetEnumeration(jetObject, this.prefix + "TickMarkType", 97);
        this.tickMarkLength = new JetUnitNumber(jetObject, this.prefix + "TickMarkLength", JRObjectTemplate.convertSize(5));
        this.minorTickMarkType = new JetEnumeration(jetObject, this.prefix + "MinorTickMarkType", 97);
        this.minorTickMarkLength = new JetUnitNumber(jetObject, this.prefix + "MinorTickMarkLength", JRObjectTemplate.convertSize(3));
        this.labelTextStyle = new JetChartTextStyle(jetObject, this.prefix + "Label");
        this.labelEveryNTickMarks = new JetNumber(jetObject, this.prefix + "LabelEveryNTickMarks", 1);
        this.numOfLabels = new JetNumber(jetObject, this.prefix + "NumOfLabels", -1);
        this.isBestEffort = new JetBoolean(jetObject, this.prefix + "IsBestEffort", true);
        this.labelAxisGap = new JetUnitNumber(jetObject, this.prefix + "LabelAxisGap", JRObjectTemplate.convertSize(5));
        this.placement = new JetEnumeration(jetObject, this.prefix + "Placement", 19);
        this.tickMarkType.set("Outside");
        this.minorTickMarkType.set("None");
        this.placement.set("Bottom");
        this.labelFontAutomaticOrientation = new JetBoolean(jetObject, this.prefix + "LabelFontAutomaticOrientation", true);
        this.showLabelTips = new JetBoolean(jetObject, this.prefix + "ShowLabelTips", true);
        this.labelPosition = new JetEnumeration(jetObject, this.prefix + "LabelPosition");
        this.labelPosition.add("outside", new Integer(0));
        this.labelPosition.add("inside", new Integer(1));
        this.labelPosition.set("outside");
    }

    public String getGroupName() {
        return "Axis";
    }

    public void addToGroup(String string) {
        if (string != null) {
            this.axisPen.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "ShowGrid", string);
            this.gridPen.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "ShowTickMarkLabels", string);
            this.tickMarkPen.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "TickMarkType", string);
            this.owner.addPropertyToGroup(this.prefix + "TickMarkLength", string);
            this.owner.addPropertyToGroup(this.prefix + "MinorTickMarkType", string);
            this.owner.addPropertyToGroup(this.prefix + "MinorTickMarkLength", string);
            this.labelTextStyle.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "LabelEveryNTickMarks", string);
            this.owner.addPropertyToGroup(this.prefix + "NumOfLabels", string);
            this.owner.addPropertyToGroup(this.prefix + "IsBestEffort", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelAxisGap", string);
            this.owner.addPropertyToGroup(this.prefix + "Placement", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelPosition", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelFontAutomaticOrientation", string);
            this.owner.addPropertyToGroup(this.prefix + "ShowLabelTips", string);
        }
    }

    public ChartAxisProperties getChartAxisProperties() {
        ChartAxisProperties chartAxisProperties = new ChartAxisProperties();
        this.toChartAxisProperties(chartAxisProperties);
        return chartAxisProperties;
    }

    protected void toChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        chartAxisProperties.setAxisPen(this.axisPen.getChartPenStyle());
        chartAxisProperties.setShowGrid(this.showGrid.booleanValue());
        chartAxisProperties.setGridPen(this.gridPen.getChartPenStyle());
        chartAxisProperties.setShowTickMarkLabels(this.showTickMarkLabels.booleanValue());
        chartAxisProperties.setTickMarkPen(this.tickMarkPen.getChartPenStyle());
        chartAxisProperties.setTickMarkType(this.tickMarkType.intValue());
        chartAxisProperties.setTickMarkLength(this.tickMarkLength.intValue());
        chartAxisProperties.setMinorTickMarkType(this.minorTickMarkType.intValue());
        chartAxisProperties.setMinorTickMarkLength(this.minorTickMarkLength.intValue());
        chartAxisProperties.setLabelTextStyle(this.labelTextStyle.getChartTextStyle());
        chartAxisProperties.setLabelEveryNTickMarks(this.labelEveryNTickMarks.intValue());
        chartAxisProperties.setNumOfLabels(this.numOfLabels.intValue());
        chartAxisProperties.setBestEffort(this.isBestEffort.booleanValue());
        chartAxisProperties.setLabelAxisGap(this.labelAxisGap.intValue());
        chartAxisProperties.setPlacement(this.placement.intValue());
        chartAxisProperties.setLabelFontAutomaticOrientation(this.labelFontAutomaticOrientation.booleanValue());
        chartAxisProperties.setShowLabelTips(this.showLabelTips.booleanValue());
        chartAxisProperties.setLabelPosition(this.labelPosition.intValue());
    }

    public void setChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        this.fromChartAxisProperties(chartAxisProperties);
    }

    protected void fromChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        this.axisPen.setChartPenStyle(chartAxisProperties.getAxisPen());
        this.showGrid.set(chartAxisProperties.isShowGrid());
        this.gridPen.setChartPenStyle(chartAxisProperties.getGridPen());
        this.showTickMarkLabels.set(chartAxisProperties.isShowTickMarkLabels());
        this.tickMarkPen.setChartPenStyle(chartAxisProperties.getTickMarkPen());
        this.tickMarkType.set((String)JetChartPropertyValues.AXIS_TICKMARKTYPE_INTEGERS.get(new Integer(chartAxisProperties.getTickMarkType())));
        this.tickMarkLength.set((int)chartAxisProperties.getTickMarkLength());
        this.minorTickMarkType.set((String)JetChartPropertyValues.AXIS_TICKMARKTYPE_INTEGERS.get(new Integer(chartAxisProperties.getMinorTickMarkType())));
        this.minorTickMarkLength.set((int)chartAxisProperties.getMinorTickMarkLength());
        this.labelTextStyle.setChartTextStyle(chartAxisProperties.getLabelTextStyle());
        this.labelEveryNTickMarks.set(chartAxisProperties.getLabelEveryNTickMarks());
        this.numOfLabels.set(chartAxisProperties.getNumOfLabels());
        this.isBestEffort.set(chartAxisProperties.isBestEffort());
        this.labelAxisGap.set((int)chartAxisProperties.getLabelAxisGap());
        this.placement.set((String)JetChartPropertyValues.AXIS_PLACEMENT_INTEGERS.get(new Integer(chartAxisProperties.getPlacement())));
        this.labelFontAutomaticOrientation.set(chartAxisProperties.IsLabelFontAutomaticOrientation());
        this.showLabelTips.set(chartAxisProperties.IsShowLabelTips());
        this.labelPosition.set(new Integer(chartAxisProperties.getLabelPosition()));
    }
}

