/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.cube;

import com.jinfonet.util.JRLog;
import jet.dataengine.api.DSException;
import jet.dataengine.api.JDataEngine;
import jet.dataengine.api.query.CubeQueryOption;
import jet.dataengine.api.query.Dimension;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.MeasureMember;
import jet.dataengine.api.query.NormalKey;
import jet.dataengine.api.schema.olap.AggregationType;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.accessor.cube.CubeModel;
import jet.rptservice.engine.accessor.cube.subject.RptDimension;
import jet.rptservice.engine.accessor.cube.subject.RptMeasure;

public class CubeQueryBuilder {
    public static final JCubeQuery buildCubeQuery(JDataEngine jDataEngine, int n, int n2, CubeModel cubeModel) throws DSException, JRScheduleException {
        Object object;
        Object object2;
        JRLog.trace(6, "CubeQueryBuilder.buildCubeQuery(..).. rawDataQueryId: " + n + "  CubeModel: " + cubeModel);
        JCubeQuery jCubeQuery = null;
        jCubeQuery = jDataEngine.createCubeQuery(n2);
        jCubeQuery.setBaseID(n);
        RptDimension[] rptDimensionArray = cubeModel.getDimensions();
        int n3 = rptDimensionArray == null ? 0 : rptDimensionArray.length;
        Dimension[] dimensionArray = new Dimension[n3];
        int n4 = 0;
        while (n4 < n3) {
            object2 = rptDimensionArray[n4].getName();
            String string = rptDimensionArray[n4].getmappingName();
            try {
                dimensionArray[n4] = new Dimension((String)object2, new NormalKey(string), null);
            }
            catch (DSException dSException) {
                JRLog.trace(5, "dimension name: " + (String)object2 + " mapping name: " + string);
                throw dSException;
            }
            ++n4;
        }
        object2 = cubeModel.getMeasures();
        int n5 = object2 == null ? 0 : ((RptMeasure[])object2).length;
        MeasureMember[] measureMemberArray = new MeasureMember[n5];
        int n6 = 0;
        while (n6 < n5) {
            object = CubeQueryBuilder.AVERAGE(object2[n6].getFunctionType());
            String string = object2[n6].getName();
            String string2 = object2[n6].getmappingName();
            try {
                measureMemberArray[n6] = new MeasureMember(string, string2, (AggregationType)object);
            }
            catch (DSException dSException) {
                JRLog.trace(5, "measure name: " + string + " mapping name: " + string2);
                throw dSException;
            }
            ++n6;
        }
        jCubeQuery.setMeasureMembers(measureMemberArray);
        jCubeQuery.setDimensions(dimensionArray);
        object = new CubeQueryOption();
        ((CubeQueryOption)object).setPushdownGroup(false);
        ((CubeQueryOption)object).setValueChange(false);
        ((CubeQueryOption)object).setPushdownOrder(false);
        jCubeQuery.setOption((CubeQueryOption)object);
        return jCubeQuery;
    }

    private static AggregationType AVERAGE(int n) throws JRScheduleException {
        AggregationType aggregationType = null;
        switch (n) {
            case 0: {
                aggregationType = AggregationType.COUNT;
                break;
            }
            case 1: {
                aggregationType = AggregationType.SUM;
                break;
            }
            case 2: {
                aggregationType = AggregationType.MIN;
                break;
            }
            case 3: {
                aggregationType = AggregationType.MAX;
                break;
            }
            case 4: {
                aggregationType = AggregationType.DISTINCTCOUNT;
                break;
            }
            case 5: {
                aggregationType = AggregationType.AVERAGE;
                break;
            }
            case 6: {
                aggregationType = AggregationType.POPULATIONSTDDEV;
                break;
            }
            case 7: {
                aggregationType = AggregationType.POPULATIONVARIANCE;
                break;
            }
            case 8: {
                aggregationType = AggregationType.STDDEV;
                break;
            }
            case 9: {
                aggregationType = AggregationType.VARIANCE;
                break;
            }
            default: {
                throw new JRScheduleException(220027, new String[]{String.valueOf(n)}, null);
            }
        }
        return aggregationType;
    }
}

