/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.swingviewer.MouseWheelHandler;
import jet.thinviewer.JReportViewer;

public class DesignerViewerPane
extends JPanel {
    private final int I = 1;
    private final int QOIV = 3;
    private final int add = 4;
    private final int addAdjustmentListener = 5;
    private final int convertUnitToPixel = 5;
    protected JViewport viewPort = new JViewport();
    protected JReportViewer viewer;
    protected Communicator communicator;
    private JPanel firstViewReport = new JPanel();
    private Rectangle getCurrentPage;
    JScrollBar Z = new JScrollBar(1);
    JScrollBar C = new JScrollBar(0);
    int getPageArea = 0;
    int getResolution = 0;

    public DesignerViewerPane(Communicator communicator) {
        this.communicator = communicator;
        this.run();
    }

    public void run() {
        this.setLayout(new ViewerLayout(this));
        this.viewer = new JReportViewer(this, this.communicator){
            private final DesignerViewerPane this$0;
            {
                this.this$0 = designerViewerPane;
                super(communicator);
            }

            public Insets getInsets() {
                return new Insets(1, 1, 5, 5);
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                int n = 0;
                while (n < 1) {
                    graphics.drawRect(n, n, dimension.width - 4 - 2 - n * 2, dimension.height - 4 - 2 - n * 2);
                    ++n;
                }
                graphics.setColor(Color.black);
                graphics.fillRect(3, dimension.height - 4 - 1, dimension.width - 3 - 1, 4);
                graphics.fillRect(dimension.width - 4 - 1, 3, 4, dimension.height - 3 - 1);
            }

            public void setLocation(int n, int n2) {
                super.setLocation(n, n2);
            }
        };
        int n = 100;
        this.setZoom(n);
        this.setBackground(Color.gray);
        this.firstViewReport.setLayout(null);
        this.firstViewReport.setBackground(Color.gray);
        this.firstViewReport.add(this.viewPort);
        this.add((Component)this.firstViewReport, "Center");
        this.add((Component)this.Z, "East");
        this.add((Component)this.C, "South");
        this.addMouseWheelListener(new MouseWheelHandler(this.Z));
        this.addMouseWheelListener(new MouseWheelHandler(this.C));
        this.validate();
        this.viewer.firstViewReport(0, 0, this.getCurrentPage.width, this.getCurrentPage.height);
        this.Z.addAdjustmentListener(new AdjustmentListener(this){
            private final DesignerViewerPane this$0;
            {
                this.this$0 = designerViewerPane;
            }

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Point point = this.this$0.viewPort.getViewPosition();
                point.y = this.this$0.Z.getValue();
                this.this$0.viewPort.setViewPosition(point);
                point = this.this$0.viewPort.getViewPosition();
            }
        });
        this.C.addAdjustmentListener(new AdjustmentListener(this){
            private final DesignerViewerPane this$0;
            {
                this.this$0 = designerViewerPane;
            }

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Point point = this.this$0.viewPort.getViewPosition();
                point.x = this.this$0.C.getValue();
                this.this$0.viewPort.setViewPosition(point);
                point = this.this$0.viewPort.getViewPosition();
            }
        });
    }

    public void setZoom(int n) {
        if (this.communicator != null) {
            int n2 = (int)((double)Unit.getResolution() * ((double)n / 100.0));
            this.communicator.setResolution(n2);
            this.viewer.setUsingThread(false);
            this.viewer.setDataStream(null);
            CommEnumeration commEnumeration = new CommEnumeration(this.communicator);
            Rectangle rectangle = null;
            if (commEnumeration.hasMoreElements()) {
                DSPage dSPage = (DSPage)commEnumeration.nextElement();
                rectangle = dSPage.getPageArea();
                this.getCurrentPage = new Rectangle(rectangle.x, rectangle.y, 0, 0);
            }
            this.getCurrentPage.width = Unit.convertUnitToPixel(rectangle.width, n2) + 2 + 4;
            this.getCurrentPage.height = Unit.convertUnitToPixel(rectangle.height, n2) + 2 + 4;
            this.viewer.setSize(this.getCurrentPage.width, this.getCurrentPage.height);
            this.viewPort.setView(this.viewer);
            this.viewPort.setBounds(5, 5, this.getCurrentPage.width, this.getCurrentPage.height);
            this.viewPort.setBackground(Color.gray);
            this.Z.setValue(0);
            this.C.setValue(0);
        }
    }

    public void _setZoom() {
        if (this.communicator != null) {
            int n = Unit.getResolution();
            this.communicator.setResolution(n);
            this.viewer.setUsingThread(false);
            this.viewer.setDataStream(null);
            this.getCurrentPage = this.viewer.getCurrentPage().getPageArea();
            Rectangle rectangle = new Rectangle(this.getCurrentPage.x, this.getCurrentPage.y, this.getCurrentPage.width, this.getCurrentPage.height);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n) + 2 + 4;
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n) + 2 + 4;
            this.viewer.setSize(rectangle.width, rectangle.height);
            this.viewPort.setView(this.viewer);
            this.viewPort.setBounds(5, 5, rectangle.width, rectangle.height);
            this.viewPort.setBackground(Color.gray);
            this.Z.setValue(0);
            this.C.setValue(0);
        }
    }

    static JPanel access$000(DesignerViewerPane designerViewerPane) {
        return designerViewerPane.firstViewReport;
    }

    class ViewerLayout
    implements LayoutManager {
        private final DesignerViewerPane this$0;

        ViewerLayout(DesignerViewerPane designerViewerPane) {
            this.this$0 = designerViewerPane;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            Dimension dimension2 = this.this$0.viewer.getSize();
            int n2 = this.this$0.Z.getPreferredSize().width;
            int n3 = this.this$0.C.getPreferredSize().height;
            if (dimension.width >= dimension2.width + 10 && dimension.height >= dimension2.height + 10) {
                this.this$0.C.setVisible(false);
                this.this$0.Z.setVisible(false);
                n2 = 0;
                n3 = 0;
            } else {
                if (dimension.width < dimension2.width + 10) {
                    if (!this.this$0.C.isVisible()) {
                        this.this$0.C.setVisible(true);
                    }
                    if (dimension.height >= dimension2.height + 10 + n3) {
                        n2 = 0;
                        this.this$0.Z.setVisible(false);
                    } else if (!this.this$0.Z.isVisible()) {
                        this.this$0.Z.setVisible(true);
                    }
                }
                if (dimension.height < dimension2.height + 10) {
                    if (!this.this$0.Z.isVisible()) {
                        this.this$0.Z.setVisible(true);
                    }
                    if (dimension.width >= dimension2.width + 10 + n2) {
                        n3 = 0;
                        this.this$0.C.setVisible(false);
                    } else if (!this.this$0.C.isVisible()) {
                        this.this$0.C.setVisible(true);
                    }
                }
            }
            int n4 = dimension.width - n2;
            int n5 = dimension.height - n3;
            DesignerViewerPane.access$000(this.this$0).setBounds(0, 0, n4, n5);
            if (this.this$0.Z.isVisible()) {
                n = Math.min(this.this$0.Z.getValue(), dimension2.height + 10 + n3 - dimension.height);
                this.this$0.Z.setBounds(n4, 0, n2, n5);
                this.this$0.Z.setValue(n);
                this.this$0.Z.setMaximum(dimension2.height + 10);
                this.this$0.Z.setVisibleAmount(n5);
                this.this$0.Z.setBlockIncrement(n5);
                this.this$0.Z.setUnitIncrement(n5 / 10);
            }
            if (this.this$0.C.isVisible()) {
                n = Math.min(this.this$0.C.getValue(), dimension2.width + 10 + n2 - dimension.width);
                this.this$0.C.setBounds(0, n5, n4, n3);
                this.this$0.C.setValue(n);
                this.this$0.C.setMaximum(dimension2.width + 10);
                this.this$0.C.setVisibleAmount(n4);
                this.this$0.C.setBlockIncrement(n4);
                this.this$0.C.setUnitIncrement(n4 / 10);
            }
            Point point = this.this$0.viewPort.getViewPosition();
            if (point.x != this.this$0.C.getValue()) {
                point.x = this.this$0.C.getValue();
                this.this$0.viewPort.setViewPosition(point);
            }
            if (point.y != this.this$0.Z.getValue()) {
                point.y = this.this$0.Z.getValue();
                this.this$0.viewPort.setViewPosition(point);
            }
        }
    }
}

