/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUDSField;
import jet.universe.JetUUDSParamFormatInfo;
import jet.universe.JetUUniverse;
import jet.universe.UniverseUtil;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.util.HashVector;
import toolkit.db.ColumnInfo;
import toolkit.db.ColumnInfoTree;
import toolkit.db.DataSourceInfo;
import toolkit.db.EnhancedDataSourceInfo;

public class JetUUserDataSource
extends JetUResourceContainer
implements JetUQueriable {
    private static JRLogger InitAfterCreate;
    public static final String strParameterDelimiter = ";";
    public JetString className = new JetString(this, "ClassName");
    public JetString parameter = new JetString(this, "Parameter");
    public JetBoolean specifyMetaData = new JetBoolean(this, "SpecifyMetadata");
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    DataSourceInfo IsMappingNameOK = null;
    private JetUUDSParamFormatInfo QOIV;
    private static final HashMap add;
    private static final HashVector addColumn;
    static Class class$jet$universe$JetUUserDataSource;
    static final boolean $assertionsDisabled;

    public JetUUserDataSource() {
    }

    public Hashtable getNameFormatPair() {
        if (this.QOIV != null) {
            return this.QOIV.getNameFormatPair();
        }
        int n = 0;
        while (n < this.B.size()) {
            if (this.B.elementAt(n) instanceof JetUUDSParamFormatInfo) {
                this.QOIV = (JetUUDSParamFormatInfo)this.B.elementAt(n);
                return this.QOIV.getNameFormatPair();
            }
            ++n;
        }
        return new Hashtable();
    }

    public void setNameFormatPair(Hashtable hashtable) {
        if (this.QOIV != null) {
            this.remove(this.QOIV);
        }
        this.QOIV = new JetUUDSParamFormatInfo();
        this.QOIV.setNameFormatPair(hashtable);
        this.add(this.QOIV);
    }

    private JetUUserDataSource(String string, String string2) {
        super(string, string2);
    }

    public JetUUserDataSource(DataSourceInfo dataSourceInfo) {
        super(dataSourceInfo.getDSName(), dataSourceInfo.getDescription());
        this.className.set(dataSourceInfo.getClassName());
        this.parameter.set(dataSourceInfo.getParameter());
        this.IsMappingNameOK = dataSourceInfo;
        this.setSpecifyMetaData(dataSourceInfo.isSpecifyMetaData());
    }

    public JetUUserDataSource(EnhancedDataSourceInfo enhancedDataSourceInfo) {
        super(enhancedDataSourceInfo.getDSName(), enhancedDataSourceInfo.getDescription());
        this.className.set(enhancedDataSourceInfo.getClassName());
        this.parameter.set(enhancedDataSourceInfo.getParameter());
        this.IsMappingNameOK = enhancedDataSourceInfo;
    }

    public int getTransactionIsolation() {
        return 0;
    }

    public int getReadOnly() {
        return 1;
    }

    public void setMaxRows(int n) {
        this.maxRows.set(n);
    }

    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int n) {
        this.maxDuration.set(n);
    }

    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    public Vector getAutoGroupFields() {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetUUDSField jetUUDSField = null;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Object e = vector2.elementAt(n2);
            if (e instanceof JetUUDSField && (n3 = (jetUUDSField = (JetUUDSField)e).getAutoGroupIndex()) != -1) {
                vector.addElement(jetUUDSField.getResourceName());
            }
            ++n2;
        }
        return vector;
    }

    public void InitAfterCreate() {
        super.InitAfterCreate();
        if (this.IsMappingNameOK == null) {
            return;
        }
        Vector vector = this.IsMappingNameOK.getColumns();
        int n = vector.size();
        JetUUDSField jetUUDSField = null;
        ColumnInfoTree columnInfoTree = null;
        if (this.IsMappingNameOK instanceof EnhancedDataSourceInfo) {
            columnInfoTree = ((EnhancedDataSourceInfo)this.IsMappingNameOK).getColumnInfoTree();
        }
        if (columnInfoTree != null) {
            ColumnInfoTree columnInfoTree2 = null;
            int n2 = 0;
            while (n2 < n) {
                columnInfoTree2 = columnInfoTree.getChildByColumnIndex(n2);
                jetUUDSField = new JetUUDSField(columnInfoTree2.getColumnMappingName(), "", columnInfoTree2.getParentString(), columnInfoTree2.getColumnInfo());
                jetUUDSField.setColMappingIndex(columnInfoTree2.getMappingColumnIndex());
                jetUUDSField.setAutoGroupIndex(columnInfoTree2.getAutoGroupIndex());
                this.addColumn(jetUUDSField);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                ColumnInfo columnInfo = (ColumnInfo)vector.elementAt(n3);
                String string = this.getMappingName(columnInfo.strName);
                jetUUDSField = new JetUUDSField(string, "", ColumnInfoTree.strRoot, columnInfo);
                this.addColumn(jetUUDSField);
                ++n3;
            }
        }
        this.setNameFormatPair(this.IsMappingNameOK.getParamNameFormatPair());
        this.IsMappingNameOK = null;
    }

    public String getMappingName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        JetUDatabase jetUDatabase = this.getDatabase();
        String string2 = null;
        String string3 = string;
        boolean bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        int n = 1;
        if (!bl) {
            string3 = this.getResourceName() + "_" + string;
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        }
        string2 = string3;
        while (!bl) {
            string3 = string2 + n++;
            bl = jetUDatabase.IsMappingNameOK(string3, stringBuffer);
        }
        return string3;
    }

    public void addColumn(JetUUDSField jetUUDSField) {
        this.add(jetUUDSField);
        jetUUDSField.InitAfterCreate();
    }

    public JetUUserDataSource cloneEntity() {
        Object object;
        JetUUserDataSource jetUUserDataSource = new JetUUserDataSource(this.getResourceName(), this.getDesc());
        jetUUserDataSource.setUDSClassName(this.getUDSClassName());
        jetUUserDataSource.setParameter(this.getParameter());
        Vector vector = this.getColumns();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUUDSField jetUUDSField = (JetUUDSField)vector.elementAt(n2);
            object = jetUUDSField.cloneEntity();
            jetUUserDataSource.addColumn((JetUUDSField)object);
            ++n2;
        }
        jetUUserDataSource.setNameFormatPair(this.getNameFormatPair());
        JetObject.copyProperties(jetUUserDataSource, this);
        jetUUserDataSource.removeBL();
        object = this.getBL();
        jetUUserDataSource.add((JetObject)((Object)(object == null ? null : object.copy())));
        return jetUUserDataSource;
    }

    public String getUDSClassName() {
        return this.className.get();
    }

    public void setUDSClassName(String string) {
        this.className.set(string);
    }

    public String getParameter() {
        return this.parameter.get();
    }

    public void setParameter(String string) {
        this.parameter.set(string);
    }

    public boolean isSpecifyMetaData() {
        return this.specifyMetaData.get();
    }

    public void setSpecifyMetaData(boolean bl) {
        this.specifyMetaData.set(bl);
    }

    public String getUDSName() {
        return this.getResourceName();
    }

    public JetUConnection getConnection() {
        return (JetUConnection)this.getParent();
    }

    public Vector getColumns() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUUDSField) {
                vector.addElement(jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public Vector getFields() {
        return this.getColumns();
    }

    public String[] parseParameter() {
        String[] stringArray = null;
        if (this.parameter != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.parameter.get(), strParameterDelimiter);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            int n = vector.size();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        return stringArray;
    }

    public JetUResourceEntity getFieldByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUUDSField && ((JetUUDSField)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUUDSField)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public String getSQLString() {
        return null;
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(jetUUniverse, string, "");
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string, String string2) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string2, this.getResourceName(), string);
        if (jetUResourceEntity == null) {
            throw new CannotFindEntity(string);
        }
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity, string2);
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity, "");
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bl = false;
        if (!$assertionsDisabled && jetUResourceEntity == null) {
            throw new AssertionError((Object)"entity can not be null");
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            bl = true;
        } else if (jetUResourceEntity instanceof JetUFormula) {
            bl = this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse, string);
        } else if (jetUResourceEntity instanceof JetUQueriableField && jetUResourceEntity instanceof JetUUDSField) {
            bl = ((JetUUDSField)jetUResourceEntity).getUDS() == this;
        }
        return bl;
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(jetUFormula, jetUUniverse, "");
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector vector = jetUFormula.getRefDbFld();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)vector.elementAt(n2);
                try {
                    if (!this.isFieldValidToQuery(jetUUniverse, string2, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string2);
                }
                ++n2;
            }
        }
        Vector vector2 = jetUFormula.getRefFormuFld();
        int n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            String string3 = (String)vector2.elementAt(n3);
            try {
                if (!this.isFieldValidToQuery(jetUUniverse, string3, string)) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string3);
            }
            ++n3;
        }
        Vector vector3 = jetUFormula.getGroupByVector();
        n = vector3.size();
        int n4 = 0;
        while (n4 < n) {
            String string4 = (String)vector3.elementAt(n4);
            if (!(jetUFormula instanceof JetUSummary) || !JetUDatabase.I(string4)) {
                try {
                    if (!string4.equalsIgnoreCase("Report") && !this.isFieldValidToQuery(jetUUniverse, string4, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string4);
                }
            }
            ++n4;
        }
        return true;
    }

    public JetUUDSField getFieldByMappingIndex(int n) {
        Vector vector = this.getColumns();
        int n2 = vector.size();
        JetUUDSField jetUUDSField = null;
        int n3 = 0;
        while (n3 < n2) {
            jetUUDSField = (JetUUDSField)vector.elementAt(n3);
            if (jetUUDSField.getColMappingIndex() == n) {
                return jetUUDSField;
            }
            ++n3;
        }
        return null;
    }

    public JetUUDSField getFieldByPathString(String string) {
        Vector vector = this.getColumns();
        int n = vector.size();
        JetUUDSField jetUUDSField = null;
        int n2 = 0;
        while (n2 < n) {
            jetUUDSField = (JetUUDSField)vector.elementAt(n2);
            String string2 = jetUUDSField.getPathString() + jetUUDSField.getFldName();
            if (string2.equals(string)) {
                return jetUUDSField;
            }
            ++n2;
        }
        return null;
    }

    public String getInstancePrefix() {
        return "UserDataSource";
    }

    public boolean isSimilar(JetUResourceContainer jetUResourceContainer) {
        JBusinessLogic jBusinessLogic;
        if (!this.className.equal(((JetUUserDataSource)jetUResourceContainer).className)) {
            return false;
        }
        if (!super.isSimilar(jetUResourceContainer)) {
            return false;
        }
        JBusinessLogic jBusinessLogic2 = this.getBL();
        if (jBusinessLogic2 == (jBusinessLogic = ((JetUUserDataSource)jetUResourceContainer).getBL())) {
            return true;
        }
        if (jBusinessLogic2 == null) {
            return jBusinessLogic == null;
        }
        return jBusinessLogic2.isSimilar(jBusinessLogic);
    }

    public boolean replaceParameterName(String string, String string2) {
        String string3 = UniverseUtil.replaceString(this.parameter.get(), "@" + string, "@" + string2);
        if (string3 != null) {
            this.parameter.set(string3);
            return true;
        }
        return false;
    }

    public JBusinessLogic newBL(String string) throws BLIlegalNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic businessLogic = new BusinessLogic();
        try {
            businessLogic.setName(string);
        }
        catch (BLDupleNameException bLDupleNameException) {
            bLDupleNameException.printStackTrace();
        }
        this.add(businessLogic);
        return businessLogic;
    }

    public void removeBL() {
        JBusinessLogic jBusinessLogic = this.getBL();
        if (jBusinessLogic != null) {
            this.remove((JetObject)((Object)jBusinessLogic));
        }
    }

    public JBusinessLogic getBL() {
        Vector vector = this.getChildren();
        JBusinessLogic jBusinessLogic = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            JetObject jetObject = (JetObject)iterator.next();
            if (!(jetObject instanceof JBusinessLogic)) continue;
            jBusinessLogic = (JBusinessLogic)((Object)jetObject);
        }
        return jBusinessLogic;
    }

    public HashMap getIndecialMap() {
        return add;
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return addColumn;
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUUserDataSource == null ? (class$jet$universe$JetUUserDataSource = JetUUserDataSource.class$("jet.universe.JetUUserDataSource")) : class$jet$universe$JetUUserDataSource).desiredAssertionStatus();
        InitAfterCreate = JRLogger.getLogger((class$jet$universe$JetUUserDataSource == null ? (class$jet$universe$JetUUserDataSource = JetUUserDataSource.class$("jet.universe.JetUUserDataSource")) : class$jet$universe$JetUUserDataSource).getName());
        add = new HashMap(7);
        add.put("Description", new Integer(0));
        add.put("maxRows", new Integer(1));
        add.put("Parameter", new Integer(2));
        add.put("ClassName", new Integer(3));
        add.put("Name", new Integer(4));
        add.put("maxDuration", new Integer(5));
        add.put("SpecifyMetadata", new Integer(6));
        addColumn = new HashVector(1);
        String string = "anonymous";
        Vector<String> vector = new Vector<String>(7);
        vector.add("Description");
        vector.add("maxRows");
        vector.add("Parameter");
        vector.add("ClassName");
        vector.add("Name");
        vector.add("maxDuration");
        vector.add("SpecifyMetadata");
        addColumn.put(string, vector);
    }
}

