/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.impl.BLContainerImpl;
import jet.universe.businesslogic.impl.BLNodeImpl;

public class HierarchyContainerImpl
extends BLContainerImpl
implements HierarchyContainer {
    public HierarchyContainerImpl() {
        this.setElementType(15);
    }

    public HierarchyInfo[] getAllHierarchies() {
        BLNode[] bLNodeArray = this.getBLChildren();
        int n = bLNodeArray.length;
        HierarchyInfo[] hierarchyInfoArray = new HierarchyInfo[n];
        int n2 = 0;
        while (n2 < n) {
            hierarchyInfoArray[n2] = (HierarchyInfo)bLNodeArray[n2];
            ++n2;
        }
        return hierarchyInfoArray;
    }

    public void addHierarchy(HierarchyInfo hierarchyInfo) throws BLDupleNameException {
        this.addChild(hierarchyInfo);
    }

    public HierarchyInfo removeHierarchy(String string) {
        HierarchyInfo hierarchyInfo = (HierarchyInfo)this.removeChildByName(string);
        return hierarchyInfo;
    }

    public HierarchyInfo getHierarchy(String string) {
        HierarchyInfo hierarchyInfo = (HierarchyInfo)this.getChildByName(string);
        return hierarchyInfo;
    }

    public HierarchyInfo[] getHierarchies(String string) {
        HierarchyInfo[] hierarchyInfoArray = this.getAllHierarchies();
        HierarchyInfo[] hierarchyInfoArray2 = new HierarchyInfo[hierarchyInfoArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < hierarchyInfoArray.length) {
            if (hierarchyInfoArray[n2].containsDimension(string)) {
                hierarchyInfoArray2[n] = hierarchyInfoArray[n2];
                ++n;
            }
            ++n2;
        }
        HierarchyInfo[] hierarchyInfoArray3 = new HierarchyInfo[n];
        System.arraycopy(hierarchyInfoArray2, 0, hierarchyInfoArray3, 0, n);
        return hierarchyInfoArray3;
    }

    public boolean isSimilar(BLNode bLNode) {
        if (!super.isSimilar(bLNode)) {
            return false;
        }
        HierarchyContainer hierarchyContainer = (HierarchyContainer)bLNode;
        BLNode[] bLNodeArray = this.getAllHierarchies();
        BLNode[] bLNodeArray2 = hierarchyContainer.getAllHierarchies();
        return BLNodeImpl.isSimilar(bLNodeArray, bLNodeArray2);
    }

    public String getInstancePrefix() {
        return "HierarchyContainerImpl";
    }
}

