/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import java.util.Vector;
import jet.controls.JetObject;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptChartPlatform;
import jet.report.JetRptDataSource;
import jet.report.JetRptHDSDataSource;
import jet.report.JetRptObject;
import jet.report.JetRptQueryComponent;
import jet.report.JetRptQueryFloat;
import jet.report.JetRptSectionObject;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ReportSetLogic;
import jet.reportLogic.objectLogic.SectionObjectLogic;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.universe.JetUUniverse;
import jet.upgrade.UpgradeChartToV8Impls;
import jet.upgrade.UpgradeDataObjUtil;
import jet.upgrade.UpgradeRpt;
import jet.upgrade.UpgradeToV8Util;

class UpgradeDataObjToV8Impl
implements UpgradeRpt {
    private ReportSetLogic GetCurrentUniverse = ObjectLogicFactory.getReportSetLogic();
    private SectionObjectLogic QOIV = ObjectLogicFactory.getSectionObjectLogic();

    UpgradeDataObjToV8Impl() {
    }

    public JetRptObject upgrade(JetRptObject jetRptObject) {
        JetRptQueryComponent jetRptQueryComponent = null;
        if (!(jetRptObject instanceof JetRptQueryComponent)) {
            return null;
        }
        jetRptQueryComponent = (JetRptQueryComponent)jetRptObject;
        DataSet dataSet = this.append(jetRptQueryComponent);
        if (this.add(jetRptQueryComponent)) {
            JetRptSectionObject jetRptSectionObject = this.QOIV.createSectionObject();
            UpgradeToV8Util.copyProperties(jetRptQueryComponent, jetRptSectionObject);
            jetRptSectionObject.setInstNameDirectly(jetRptObject.getInstName());
            if (dataSet != null) {
                jetRptSectionObject.dataInherit.set(false);
                jetRptSectionObject.dataSet.setObject(dataSet);
            }
            jetRptSectionObject.compressIfNoRecord.set(jetRptQueryComponent.suppressEmpty.get());
            return jetRptSectionObject;
        }
        JetRptChartPlatform jetRptChartPlatform = this.QOIV(jetRptQueryComponent);
        if (jetRptChartPlatform != null) {
            jet.report.chart.JetRptChartPlatform jetRptChartPlatform2 = null;
            jetRptChartPlatform2 = (jet.report.chart.JetRptChartPlatform)new UpgradeChartToV8Impls().upgrade(jetRptChartPlatform);
            if (jetRptChartPlatform2 != null && dataSet != null) {
                jetRptChartPlatform2.dataInherit.set(false);
                jetRptChartPlatform2.dataSet.setObject(dataSet);
            }
            jetRptChartPlatform2.x.setUnitValue(jetRptQueryComponent.x.getUnit() + jetRptChartPlatform.x.getUnit());
            jetRptChartPlatform2.y.setUnitValue(jetRptQueryComponent.y.getUnit() + jetRptChartPlatform.y.getUnit());
            return jetRptChartPlatform2;
        }
        JetRptCTCrossTab jetRptCTCrossTab = this.GetCurrentUniverse(jetRptQueryComponent);
        if (jetRptCTCrossTab != null && dataSet != null) {
            jetRptCTCrossTab.dataInherit.set(false);
            jetRptCTCrossTab.dataSet.setObject(dataSet);
        }
        return jetRptCTCrossTab;
    }

    private JetRptCTCrossTab GetCurrentUniverse(JetRptQueryComponent jetRptQueryComponent) {
        return UpgradeDataObjUtil.getCrosstab((JetRptQueryFloat)jetRptQueryComponent);
    }

    private JetRptChartPlatform QOIV(JetRptQueryComponent jetRptQueryComponent) {
        return UpgradeDataObjUtil.getChart((JetRptQueryFloat)jetRptQueryComponent);
    }

    private boolean add(JetRptQueryComponent jetRptQueryComponent) {
        int n = UpgradeDataObjUtil.getTemplateType((JetRptQueryFloat)jetRptQueryComponent);
        return n == 16385 || n == 45;
    }

    private DataSet append(JetRptQueryComponent jetRptQueryComponent) {
        JetRptDataSet jetRptDataSet = null;
        JetRptDataSource jetRptDataSource = jetRptQueryComponent.getDataSource();
        if (jetRptDataSource == null) {
            return null;
        }
        JetUUniverse jetUUniverse = jetRptDataSource.getUniverse();
        if (jetUUniverse == null) {
            jetUUniverse = JetUUniverse.GetCurrentUniverse();
        }
        String string = jetUUniverse == null ? null : jetUUniverse.getName();
        String string2 = jetRptDataSource.sourceName.get();
        String string3 = jetRptDataSource.uQueryName.get();
        JetRptHDSDataSource jetRptHDSDataSource = jetRptDataSource.getHDSDS();
        jetRptDataSet = jetRptHDSDataSource != null ? this.GetCurrentUniverse.createHDSDataSet(string, string2, string3) : this.GetCurrentUniverse.createQueryDataSet(string, string2, string3, null);
        jetRptDataSet.setMappingListType(1);
        JetRptDataSet jetRptDataSet2 = jetRptDataSet;
        jetRptDataSet2.setInstNameDirectly(jetRptQueryComponent.getInstName() + "_" + "convert_dataset");
        UpgradeToV8Util.setProperty(jetRptDataSet2, jetRptQueryComponent.recordsPerPage);
        UpgradeToV8Util.setProperty(jetRptDataSet2, jetRptQueryComponent.maxPageNumber);
        UpgradeToV8Util.copyProperties(jetRptDataSource, jetRptDataSet2);
        Vector vector = jetRptDataSource.getChildren();
        int n = 0;
        while (n < vector.size()) {
            JetObject jetObject = (JetObject)vector.get(n);
            if (jetObject instanceof JetRptHDSDataSource) {
                UpgradeToV8Util.copyProperties((JetRptObject)jetObject, jetRptDataSet2);
            } else {
                JetObject jetObject2 = jetObject.deepDupWithName();
                jetRptDataSet2.add(jetObject2);
            }
            ++n;
        }
        return jetRptDataSet2;
    }
}

