/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import guitools.swing.dialog.CheckOptionPanel;
import guitools.swing.dialog.ShowMessageDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import jet.JDesgResource;
import jet.JResource;
import jet.ReportEnv;
import jet.util.Filter;

public class FileUtil {
    public static int BUFFER_SIZE = 262140;

    public static void copy(File file, File file2) throws IOException {
        int n;
        if (file == null || file2 == null) {
            throw new NullPointerException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void copyFile(String string, String string2, String string3) throws IOException {
        if (string.equalsIgnoreCase(string2 + File.separator)) {
            return;
        }
        FileUtil.copy(new File(string, string3), new File(string2, string3));
    }

    public static void copyFile(String string, String string2) throws IOException {
        if (string.equalsIgnoreCase(string2)) {
            return;
        }
        FileUtil.copy(new File(string), new File(string2));
    }

    public static void copyFiles(String string, String string2, Vector vector) throws IOException {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)vector.elementAt(n2);
            FileUtil.copyFile(string, string2, string3);
            ++n2;
        }
    }

    public static void copyFiles(Vector vector, String string) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            File file = new File((String)vector.elementAt(n));
            FileUtil.copyFile(file.getParent(), string, file.getName());
            ++n;
        }
    }

    public static boolean copyFilesPromptly(Frame frame, String string, String string2, Vector vector) {
        Object[] objectArray;
        Object object;
        CharSequence charSequence;
        int n;
        int n2 = n = vector == null ? 0 : vector.size();
        if (n <= 0) {
            return true;
        }
        Vector<File> vector2 = new Vector<File>(n);
        Vector<Object[]> vector3 = new Vector<Object[]>(n);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < n) {
            charSequence = (String)vector.elementAt(n3);
            File file = new File(string, (String)charSequence);
            if (file.exists() && file.isFile()) {
                object = new File(string2, (String)charSequence);
                if (object.exists()) {
                    if (!bl2 && !bl3) {
                        objectArray = CheckOptionPanel.showMessage(frame, JResource.getMessage("FileUtil_CopyFilesTitle"), JResource.getMessage("FileUtil_FileExists", new Object[]{string2, charSequence}), JResource.getMessage("FileUtil_ApplyToAll"), 3);
                        if ((Integer)objectArray[0] == 1) {
                            if (((Boolean)objectArray[1]).booleanValue()) {
                                bl3 = true;
                            }
                        } else {
                            if ((Integer)objectArray[0] == 2) {
                                return false;
                            }
                            vector2.addElement(file);
                            vector3.addElement((Object[])object);
                            if (((Boolean)objectArray[1]).booleanValue()) {
                                bl2 = true;
                            }
                        }
                    } else if (bl2) {
                        vector2.addElement(file);
                        vector3.addElement((Object[])object);
                    }
                } else {
                    vector2.addElement(file);
                    vector3.addElement((Object[])object);
                }
            } else if (!bl) {
                object = CheckOptionPanel.showMessage(frame, JResource.getMessage("FileUtil_CopyFilesTitle"), JResource.getMessage("FileUtil_SourceNotExists", new Object[]{charSequence, string}), JResource.getMessage("FileUtil_IgnoreAllSrvFile"), 1);
                if ((Integer)object[0] == 1) {
                    return false;
                }
                if (((Boolean)object[1]).booleanValue()) {
                    bl = true;
                }
            }
            ++n3;
        }
        n = vector2.size();
        charSequence = new StringBuffer();
        int n4 = 0;
        while (n4 < n) {
            object = (Object[])vector2.elementAt(n4);
            objectArray = (Object[])vector3.elementAt(n4);
            try {
                FileUtil.copy((File)object, (File)objectArray);
            }
            catch (IOException iOException) {
                ((StringBuffer)charSequence).append("    " + object.getName() + "\n");
            }
            ++n4;
        }
        if (((StringBuffer)charSequence).length() > 0) {
            ShowMessageDialog.showMessageDialog(frame, JResource.getMessage("FileUtil_FailedFiles"), JDesgResource.getDlgText("MsgBox", "Warning"), 2);
        }
        return true;
    }

    public static void transferFile(File file, OutputStream outputStream) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = fileInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        outputStream.close();
    }

    public static String[] getStyleGroups() {
        String string = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        File file = new File(string);
        Filter filter = new Filter(file, "_stl.xsd");
        File[] fileArray = file.listFiles(filter);
        String[] stringArray = new String[fileArray.length + 1];
        stringArray[0] = "None";
        int n = 0;
        while (n < fileArray.length) {
            String string2;
            String string3 = fileArray[n].getName();
            stringArray[n + 1] = string2 = string3.substring(0, string3.lastIndexOf("_"));
            ++n;
        }
        return stringArray;
    }
}

