/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.query.parser;

import toolkit.db.query.parser.Node;
import toolkit.db.query.parser.QueryParser;
import toolkit.db.query.parser.QueryParserTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected String image;
    protected QueryParser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(QueryParser queryParser, int n) {
        this(n);
        this.parser = queryParser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public int jjtIndexOf(Node node) {
        return this.jjtIndexOf(node, 0);
    }

    public int jjtIndexOf(Node node, int n) {
        int n2 = n;
        while (n2 < this.children.length) {
            if (node.equals(this.children[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void jjtRemoveChild(int n) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + 0);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n + " < " + 0);
        }
        if (n >= this.children.length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.children.length);
        }
        this.children[n].jjtSetParent(null);
        if (this.children.length == 1) {
            this.children = null;
            return;
        }
        Node[] nodeArray = new Node[this.children.length - 1];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = this.children[n2];
            ++n2;
        }
        int n3 = n;
        while (n3 < this.children.length - 1) {
            nodeArray[n3] = this.children[n3 + 1];
            ++n3;
        }
        this.children = nodeArray;
    }

    public boolean jjtRemoveChild(Node node) {
        int n = this.jjtIndexOf(node);
        if (n == -1) {
            return false;
        }
        this.jjtRemoveChild(n);
        return true;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return QueryParserTreeConstants.jjtNodeName[this.id] + " : " + this.C();
    }

    public String toString(String string) {
        return string + this.toString();
    }

    void Z() {
    }

    String C() {
        if (this.image == null) {
            this.Z();
        }
        return this.image;
    }

    final String C(String string) {
        if (string != null && (string.charAt(0) == '\"' || string.charAt(0) == '`')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        SimpleNode simpleNode = null;
        SimpleNode simpleNode2 = null;
        simpleNode = new SimpleNode(0);
        System.out.println("0 " + simpleNode.children);
        simpleNode2 = new SimpleNode(1);
        simpleNode.jjtAddChild(simpleNode2, 0);
        simpleNode2 = new SimpleNode(2);
        simpleNode.jjtAddChild(simpleNode2, 1);
        System.out.println("1 " + simpleNode.children + " : " + simpleNode.children.length);
        simpleNode.jjtRemoveChild(0);
        System.out.println("2.1 " + simpleNode.children + " : " + simpleNode.children.length);
        simpleNode.jjtRemoveChild(0);
        System.out.println("2.2 " + simpleNode.children);
    }
}

