/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import com.jinfonet.jdbc.obj.ObjectConnection;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUJdbcSupportInfo;
import toolkit.config.PoolConfig;
import toolkit.db.version2.CallTrace;
import toolkit.db.version2.ConnectionInfo;

public class JdbcPool {
    int QOIV;
    ConnectionInfo[] append;
    PoolConfig I;
    private JetUJdbcSupportInfo arraycopy = null;
    private static JRLogger class$ = JRLogger.getLogger((class$toolkit$db$version2$JdbcPool == null ? (class$toolkit$db$version2$JdbcPool = JdbcPool.class$("toolkit.db.version2.JdbcPool")) : class$toolkit$db$version2$JdbcPool).getName());
    private static DSLog close = DSLog.getDSLog((class$toolkit$db$version2$JdbcPool == null ? (class$toolkit$db$version2$JdbcPool = JdbcPool.class$("toolkit.db.version2.JdbcPool")) : class$toolkit$db$version2$JdbcPool).getName());
    static Class class$toolkit$db$version2$JdbcPool;

    JdbcPool(PoolConfig poolConfig) {
        this.I = poolConfig;
        int n = poolConfig.getMaxCount();
        this.append = new ConnectionInfo[n <= 0 ? 10 : n];
    }

    public synchronized boolean checkValidity(Connection connection) {
        if (close.isDebugEnabled()) {
            close.debug("Validity connection H:[" + connection.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "]", new CallTrace());
        }
        boolean bl = true;
        ConnectionInfo connectionInfo = null;
        try {
            connectionInfo = (ConnectionInfo)connection;
            DatabaseMetaData databaseMetaData = connectionInfo.getMetaData();
            if (databaseMetaData.getDatabaseProductName().startsWith("ACCESS")) {
                return true;
            }
            ResultSet resultSet = connection.getMetaData().getSchemas();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            block11: {
                if (class$.isErrorEnabled()) {
                    class$.error("check connection validity: invalid");
                }
                try {
                    this.QOIV(connectionInfo);
                    connectionInfo.Z();
                }
                catch (SQLException sQLException2) {
                    if (!class$.isErrorEnabled()) break block11;
                    class$.error("close connection failed");
                }
            }
            bl = false;
        }
        catch (Exception exception) {
            block12: {
                try {
                    this.QOIV(connectionInfo);
                    connectionInfo.Z();
                }
                catch (SQLException sQLException) {
                    if (!class$.isErrorEnabled()) break block12;
                    class$.error("close connection failed");
                }
            }
            if (class$.isErrorEnabled()) {
                class$.error("check connection validity: invalid");
            }
            bl = false;
        }
        return bl;
    }

    public synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        if (string == null) {
            string = "";
        }
        int n = this.I.getMaxCount();
        int n2 = this.I.getIdleExpire();
        int n3 = this.I.getShare();
        int n4 = this.I.getAttempt();
        int n5 = this.I.getInterval();
        int n6 = n5 * n4;
        int n7 = n4;
        while (--n7 >= 0) {
            block30: {
                Object object;
                ConnectionInfo connectionInfo;
                int n8 = this.QOIV;
                while (--n8 >= 0) {
                    int n9;
                    connectionInfo = this.append[n8];
                    object = connectionInfo.getCatalog();
                    if (!connectionInfo.I.equals(string) || !(connectionInfo.getPassword() == null ? string2 == null : connectionInfo.getPassword().equals(string2)) || n3 != 0 && (connectionInfo.getIdleTime() >= n2 || connectionInfo.getLockNumber() >= n3) || (string3 == null || object == null || ((String)object).length() <= 0 || !string3.equals(object)) && string3 != null) continue;
                    if (close.isDebugEnabled()) {
                        close.debug("Befor get connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                        n9 = 0;
                        while (n9 < this.append.length) {
                            if (this.append[n9] != null) {
                                close.debug("\tJDBC POOL [" + n9 + "] connection H:[" + this.append[n9].hashCode() + "] ShareCount:[" + this.append[n9].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            }
                            ++n9;
                        }
                    }
                    connectionInfo.I();
                    if (close.isDebugEnabled()) {
                        close.debug("End get connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] ShareCount:[" + connectionInfo.getLockNumber() + "] Pool H:[" + this.hashCode() + "]", new CallTrace());
                        n9 = 0;
                        while (n9 < this.append.length) {
                            if (this.append[n9] != null) {
                                close.debug("\tJDBC POOL [" + n9 + "] connection H:[" + this.append[n9].hashCode() + "] ShareCount:[" + this.append[n9].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            }
                            ++n9;
                        }
                    }
                    return connectionInfo;
                }
                if (n != 0 && this.QOIV == n) {
                    int n10 = this.QOIV;
                    while (--n10 >= 0) {
                        connectionInfo = this.append[n10];
                        if (connectionInfo.isLock() || connectionInfo.I.equals(string)) continue;
                        connectionInfo.Z();
                        this.QOIV(connectionInfo);
                    }
                }
                if (n == 0 || n == 0 || this.QOIV < n) {
                    try {
                        Connection connection = DriverManager.getConnection(this.I.getURL(), string, string2);
                        if (connection instanceof ObjectConnection) {
                            return connection;
                        }
                        connectionInfo = new ConnectionInfo(this, connection, string, string2);
                        if (this.arraycopy == null && connection != null) {
                            if (class$.isDebugEnabled()) {
                                class$.debug("Fetch Support info from Connection url:[" + this.I.getURL() + "]");
                            }
                            object = new JetUJdbcSupportInfo();
                            ((JetUJdbcSupportInfo)object).fetchJDBCSupportInfo(connection);
                            this.arraycopy = object;
                        }
                        if (string3 != null) {
                            try {
                                connection.setCatalog(string3);
                            }
                            catch (SQLException sQLException) {
                                DSLog.getDSLog(this.getClass().getName()).debug(sQLException.getMessage());
                            }
                        }
                        if (close.isDebugEnabled()) {
                            close.debug("Befor create connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            int n11 = 0;
                            while (n11 < this.append.length) {
                                if (this.append[n11] != null) {
                                    close.debug("\tBefor create connection JDBC POOL [" + n11 + "] connection H:[" + this.append[n11].hashCode() + "] ShareCount:[" + this.append[n11].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                                }
                                ++n11;
                            }
                        }
                        this.add(connectionInfo);
                        if (close.isDebugEnabled()) {
                            close.debug("End create connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]", new CallTrace());
                            int n12 = 0;
                            while (n12 < this.append.length) {
                                if (this.append[n12] != null) {
                                    close.debug("\tEnd create connection JDBC POOL [" + n12 + "] connection H:[" + this.append[n12].hashCode() + "] ShareCount:[" + this.append[n12].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                                }
                                ++n12;
                            }
                            close.debug("Get create connection H:[" + connectionInfo.hashCode() + "] ShareCount:[" + connectionInfo.getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "]");
                        }
                        return connectionInfo;
                    }
                    catch (SQLException sQLException) {
                        if (n7 == 0 || this.QOIV == 0) {
                            throw sQLException;
                        }
                    }
                    catch (Throwable throwable) {
                        if (n7 != 0 && this.QOIV != 0) break block30;
                        SQLException sQLException = new SQLException(throwable.getMessage());
                        sQLException.setStackTrace(throwable.getStackTrace());
                        throw sQLException;
                    }
                }
            }
            if (n5 <= 0) continue;
            try {
                this.wait(n6);
                n6 -= n5;
            }
            catch (InterruptedException interruptedException) {
                DSLog.getDSLog(this.getClass().getName()).debug(interruptedException.getMessage());
            }
        }
        this.notifyAll();
        throw new SQLException("JReport connection pool: Can not establish more than  " + this.QOIV + " connections with URL " + this.I.getURL());
    }

    synchronized void I(String string) throws SQLException {
        SQLException sQLException = null;
        if (string == null) {
            string = "";
        }
        int n = this.QOIV;
        while (--n >= 0) {
            ConnectionInfo connectionInfo = this.append[n];
            if (!connectionInfo.I.equals(string)) continue;
            try {
                connectionInfo.Z();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (n < this.QOIV - 1) {
                System.arraycopy(this.append, n + 1, this.append, n, this.QOIV - n - 1);
            }
            --this.QOIV;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized void I() throws SQLException {
        SQLException sQLException = null;
        int n = this.QOIV;
        while (--n >= 0) {
            try {
                this.append[n].Z();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.QOIV = 0;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized void I(int n) throws SQLException {
        SQLException sQLException = null;
        int n2 = this.QOIV;
        while (--n2 >= 0) {
            ConnectionInfo connectionInfo = this.append[n2];
            if (connectionInfo.hashCode() != n) continue;
            try {
                connectionInfo.Z();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (n2 < this.QOIV - 1) {
                System.arraycopy(this.append, n2 + 1, this.append, n2, this.QOIV - n2 - 1);
            }
            --this.QOIV;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public ConnectionInfo[] getConnectionInfos() {
        ConnectionInfo[] connectionInfoArray = new ConnectionInfo[this.QOIV];
        if (this.append != null) {
            System.arraycopy(this.append, 0, connectionInfoArray, 0, this.QOIV);
        }
        return connectionInfoArray;
    }

    public PoolConfig getConfig() {
        return this.I;
    }

    void add(ConnectionInfo connectionInfo) {
        if (this.QOIV == this.append.length) {
            ConnectionInfo[] connectionInfoArray = new ConnectionInfo[this.QOIV + this.QOIV];
            System.arraycopy(this.append, 0, connectionInfoArray, 0, this.QOIV);
            this.append = connectionInfoArray;
        }
        this.append[this.QOIV++] = connectionInfo;
    }

    boolean QOIV(ConnectionInfo connectionInfo) {
        return this.append(this.arraycopy(connectionInfo));
    }

    boolean append(int n) {
        if (n >= 0 && n < this.QOIV) {
            if (n < this.QOIV - 1) {
                System.arraycopy(this.append, n + 1, this.append, n, this.QOIV - n - 1);
            }
            --this.QOIV;
            if (this.I.getMaxCount() == 0 && this.append.length > 10 && this.QOIV + this.QOIV < this.append.length) {
                ConnectionInfo[] connectionInfoArray = new ConnectionInfo[this.QOIV < 10 ? 11 : this.QOIV + 1];
                System.arraycopy(this.append, 0, connectionInfoArray, 0, this.QOIV);
                this.append = connectionInfoArray;
            }
            return true;
        }
        return false;
    }

    int arraycopy(ConnectionInfo connectionInfo) {
        int n = this.QOIV;
        while (--n >= 0) {
            if (this.append[n] != connectionInfo) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws SQLException {
        boolean bl = false;
        int n = this.I.getIdleExpire();
        int n2 = this.I.getExpire();
        SQLException sQLException = null;
        int n3 = this.QOIV;
        while (--n3 >= 0) {
            ConnectionInfo connectionInfo;
            ConnectionInfo connectionInfo2 = this.append[n3];
            if (connectionInfo2.getIdleTime() >= n) {
                if (!this.append(n3)) continue;
                bl = true;
                connectionInfo = connectionInfo2;
                synchronized (connectionInfo) {
                    if (connectionInfo2.getLockNumber() > 0) {
                        if (class$.isDebugEnabled()) {
                            class$.debug("", new Exception("release Connection [" + connectionInfo2.hashCode() + "]  lock[" + connectionInfo2.getLockNumber() + "] continue"));
                        }
                        continue;
                    }
                    try {
                        connectionInfo2.Z();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                    }
                    continue;
                }
            }
            if (n2 == 0 || connectionInfo2.getStartTime() < n2 || !this.append(n3)) continue;
            bl = true;
            connectionInfo = connectionInfo2;
            synchronized (connectionInfo) {
                if (connectionInfo2.getLockNumber() > 0) {
                    if (class$.isDebugEnabled()) {
                        class$.debug("", new Exception("release Connection [" + connectionInfo2.hashCode() + "]  lock[" + connectionInfo2.getLockNumber() + "] continue"));
                    }
                    continue;
                }
                try {
                    connectionInfo2.Z();
                }
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                }
            }
        }
        if (bl) {
            this.notifyAll();
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public synchronized void dispose() throws SQLException {
        int n = this.I.getMaxCount();
        SQLException sQLException = null;
        int n2 = this.QOIV;
        while (--n2 >= 0) {
            try {
                this.append[n2].Z();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        this.append = new ConnectionInfo[n <= 0 ? 10 : n];
        this.QOIV = 0;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void I(Writer writer) throws IOException {
        writer.write("\tURL: " + this.I.getURL() + "\r\n");
        int n = this.QOIV;
        while (--n >= 0) {
            this.append[n].I(writer);
        }
        writer.write("\tend URL: " + this.I.getURL() + "\r\n");
    }

    JetUJdbcSupportInfo Z() {
        return this.arraycopy;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

