/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms;

import java.io.IOException;
import java.io.Reader;

final class CharBuffer {
    char[] buf;
    int length = 0;

    public CharBuffer(int length) {
        this.buf = new char[length + 1];
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int fill(Reader in) throws IOException {
        int d;
        while (this.length < this.buf.length && (d = in.read()) != -1) {
            this.buf[this.length] = (char)d;
            ++this.length;
        }
        return this.length;
    }

    public void drop(int n) {
        for (int i = n; i < this.buf.length; ++i) {
            this.buf[i - n] = this.buf[i];
        }
        this.length -= n;
    }

    public char pop() {
        char ret = this.buf[0];
        this.drop(1);
        return ret;
    }

    public boolean startsWith(char[] match) {
        for (int i = 0; i <= this.length && i < match.length; ++i) {
            if (this.buf[i] == match[i]) continue;
            return false;
        }
        return true;
    }
}

