/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Dates {
    private Dates() {
    }

    public static Date now() {
        return new Date();
    }

    public static String format(Date date) {
        return Dates.format(date, null);
    }

    public static String format(String dateString) {
        return Dates.format(dateString, null);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
        return df.format(date);
    }

    public static String format(String dateString, String pattern) {
        return "";
    }

    public static Date toDate(String dateString) {
        return new Date();
    }

    public static Date toDate(long dateMillis) {
        return new Date(dateMillis);
    }

    public static int dateDiff(char unit, Date testDate, Date refDate) throws IllegalArgumentException {
        long testDateMillis = testDate.getTime();
        long refDateMillis = refDate.getTime();
        if ((unit = Character.toUpperCase(unit)) != 'D') {
            throw new IllegalArgumentException("Invalid date unit specified. Currently only 'D' (days) allowed");
        }
        return (int)((testDateMillis - refDateMillis) / 1000L / 60L / 60L / 24L);
    }

    public static int dateDiff(char unit, String testDate, Date refDate) throws IllegalArgumentException {
        return Dates.dateDiff(unit, Dates.toDate(testDate), refDate);
    }

    public static int dateDiff(char unit, Date testDate, String refDate) throws IllegalArgumentException {
        return Dates.dateDiff(unit, testDate, Dates.toDate(refDate));
    }

    public static int dateDiff(char unit, String testDate, String refDate) throws IllegalArgumentException {
        return Dates.dateDiff(unit, Dates.toDate(testDate), Dates.toDate(refDate));
    }

    public static void main(String[] args) {
    }
}

