/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Debug {
    public static void showErrorDialog(Component parent, Throwable t) {
        if (t instanceof RuntimeException) {
            Debug.showStackTraceDialog(parent, t);
        } else {
            JOptionPane.showMessageDialog(parent, t.toString(), "An error occured", 0);
        }
    }

    public static void showStackTraceDialog(Component parent, Throwable t) {
        t.printStackTrace(System.out);
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println("An unexpected error occured. Please see detailed description below:");
        err.println("");
        t.printStackTrace(err);
        err.close();
        JTextArea ta = new JTextArea(sw.toString());
        ta.setEditable(false);
        sp.getViewport().add((Component)ta, null);
        JOptionPane.showMessageDialog(parent, sp, "Unexpected error occured", 0);
    }

    public static void showCopyableError(Component parent, Throwable t, String title) {
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println(t.getMessage());
        err.close();
        JTextArea ta = new JTextArea(sw.toString());
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setColumns(80);
        ta.setRows(15);
        sp.getViewport().add((Component)ta, null);
        JOptionPane.showMessageDialog(parent, sp, title, 0);
    }

    public static void printClassInfo(Class c) {
        System.out.println("Class info:");
        do {
            System.out.println(c.getName() + " Loader: " + c.getClassLoader());
        } while ((c = c.getSuperclass()) != null);
    }
}

