/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms;

import com.ericsson.scac.cms.CharBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;

public class Replacer {
    private Vector search = new Vector();
    private Vector replace = new Vector();
    String firstSearchChars = "";
    CharBuffer buffer;

    public void add(String search, String replace) {
        char[] chars = search.toCharArray();
        this.search.add(chars);
        this.replace.add(replace);
        if (this.firstSearchChars.indexOf(chars[0]) == -1) {
            this.firstSearchChars = this.firstSearchChars + chars[0];
        }
    }

    private void initBuffer() {
        int maxSize = 0;
        for (int i = 0; i < this.search.size(); ++i) {
            int length = ((char[])this.search.get(i)).length;
            if (length <= maxSize) continue;
            maxSize = length;
        }
        this.buffer = new CharBuffer(maxSize);
    }

    public void processStreams(Reader in2, Writer out2) throws IOException {
        this.initBuffer();
        char[][] find = new char[this.search.size()][];
        for (int i = 0; i < find.length; ++i) {
            find[i] = (char[])this.search.get(i);
        }
        while (this.buffer.fill(in2) > 0) {
            int indexOfLargestMatch = -1;
            int lengthOfLargestMatch = 0;
            for (int i = 0; i < find.length; ++i) {
                if (this.buffer.buf[0] != find[i][0] || !this.buffer.startsWith(find[i]) || find[i].length <= lengthOfLargestMatch) continue;
                lengthOfLargestMatch = find[i].length;
                indexOfLargestMatch = i;
            }
            if (indexOfLargestMatch != -1) {
                this.buffer.drop(lengthOfLargestMatch);
                out2.write((String)this.replace.get(indexOfLargestMatch));
                continue;
            }
            out2.write(this.buffer.pop());
        }
        out2.flush();
    }

    public String replace(String s) {
        char[] chars = s.toCharArray();
        StringBuffer out = new StringBuffer(chars.length);
        this.initBuffer();
        char[][] find = new char[this.search.size()][];
        for (int i = 0; i < find.length; ++i) {
            find[i] = (char[])this.search.get(i);
        }
        int base = 0;
        for (int index = 0; index < chars.length; ++index) {
            int indexOfLargestMatch = -1;
            int lengthOfLargestMatch = 0;
            if (this.firstSearchChars.indexOf(chars[index]) != -1) {
                for (int fi = 0; fi < find.length; ++fi) {
                    if (chars[index] != find[fi][0] || find[fi].length <= lengthOfLargestMatch || !this.startsWith(chars, index, find[fi])) continue;
                    lengthOfLargestMatch = find[fi].length;
                    indexOfLargestMatch = fi;
                }
            }
            if (indexOfLargestMatch == -1) continue;
            out.append(chars, base, index - base);
            base = (index += lengthOfLargestMatch - 1) + 1;
            out.append(this.replace.get(indexOfLargestMatch));
        }
        out.append(chars, base, chars.length - base);
        return out.toString();
    }

    private final boolean startsWith(char[] chars, int start, char[] match) {
        for (int i = 0; i < match.length; ++i) {
            if (start + i == chars.length) {
                return false;
            }
            if (chars[start + i] == match[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Replacer replacer = new Replacer();
        replacer.add("$style", "[This is an exanded style variable]");
        replacer.add("$styleFile", "[This is an exanded styleFile variable]");
        String s = "This is a simple text with a $style and a $styleFile variable. Here comes a $style variable again.$styleFil";
        System.out.println(replacer.replace(s));
    }
}

