/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.edgeware.utils;

import com.ericsson.scac.cms.edgeware.model.TitleList;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class OriginUtils {
    public static String format(Time time) {
        String formatted = null;
        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        formatted = df.format(time);
        return formatted;
    }

    public static String format(Date date) {
        String formatted = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        formatted = df.format(date);
        return formatted;
    }

    public static String formatDateTime(Date date) {
        String formatted = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'-'HHmmss");
        formatted = df.format(date);
        return formatted;
    }

    public static String formatUTC(Date date) {
        String formatted = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatted = df.format(date);
        return formatted;
    }

    public static Date parseUTC(String s) throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        date = df.parse(s);
        return date;
    }

    public static Date parseDateTime(String s) throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'-'HHmmss");
        date = df.parse(s);
        return date;
    }

    public static void setTime(Calendar cal, String timeStr) {
        String[] parts = timeStr.split(":");
        cal.set(11, Integer.parseInt(parts[0]));
        cal.set(12, Integer.parseInt(parts[1]));
        cal.set(13, Integer.parseInt(parts[2]));
    }

    public static String getPlayoutNamePrefix(TitleList tl) {
        String name = "PO_" + tl.getChannelId();
        return name;
    }

    public static String getPlaylistNamePrefix(TitleList tl) {
        String name = "PL_" + tl.getChannelId() + "_";
        return name;
    }

    public static String getPlaylistNamePrefixForDefault(TitleList tl) {
        String name = "PL_" + tl.getChannelId() + "_" + tl.getBarkerType();
        return name;
    }

    public static String getScheduleNamePrefix(TitleList tl) {
        String name = "SC_" + tl.getChannelId() + "_";
        return name;
    }

    public static String getPlayoutNamePrefixLong(TitleList tl) {
        String name = "PO_" + tl.getChannelId();
        return name;
    }

    public static String getPlaylistNamePrefixLong(TitleList tl) {
        String name = "PL_" + tl.getChannelId() + "_" + tl.getBarkerType() + "_" + tl.getAlternatingType() + "_";
        return name;
    }

    public static String getScheduleNamePrefixLong(TitleList tl) {
        String name = "SC_" + tl.getChannelId() + "_" + tl.getBarkerType() + "_" + tl.getAlternatingType() + "_";
        return name;
    }
}

