/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.edgeware.utils;

import com.ericsson.scac.cms.edgeware.model.OriginWFSResponseFileWrapper;
import com.ericsson.scac.cms.edgeware.model.RestTO;
import com.ericsson.scac.cms.edgeware.utils.JSON;
import com.ericsson.scac.cms.edgeware.utils.OriginWFSResponseFile;
import com.google.gson.JsonParseException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class OriginWFSMessageHandler {
    private static Logger logger = Logger.getLogger(OriginWFSMessageHandler.class);
    private static final int WFS_MAX_MESSAGE_SIZE = 4000;

    public static String process(RestTO rto, String type) throws IOException {
        logger.debug((Object)"called");
        String json = rto.getJsonString();
        return OriginWFSMessageHandler.process(json, type);
    }

    public static String process(String json, String type) throws IOException {
        logger.debug((Object)"called");
        String retJSON = null;
        logger.debug((Object)("input-size: " + json.length()));
        if (json.length() >= 4000) {
            if (json.length() >= 4000) {
                logger.debug((Object)"character limit exceeded, persistence to filesystem required");
                OriginWFSResponseFile rf = new OriginWFSResponseFile(json, type);
                rf.write();
                String filepath = rf.getFilePath();
                OriginWFSResponseFileWrapper rfw = new OriginWFSResponseFileWrapper();
                rfw.setOriginWFSResponseFilepath(filepath);
                retJSON = JSON.marshall(rfw);
                logger.debug((Object)("persisted-json: " + retJSON));
            } else {
                retJSON = json;
            }
        } else {
            logger.debug((Object)"no modification of input required");
            retJSON = json;
        }
        logger.debug((Object)("output-size: " + retJSON.length()));
        return retJSON;
    }

    public static String retreive(String json) throws IOException {
        logger.debug((Object)"called");
        String retJSON = null;
        try {
            OriginWFSResponseFileWrapper rfw = JSON.unmarshall(json, OriginWFSResponseFileWrapper.class);
            String filepath = rfw.getOriginWFSResponseFilepath();
            if (filepath != null) {
                retJSON = new String(OriginWFSMessageHandler.read(new File(filepath)));
            } else {
                logger.debug((Object)"FILEPATH NULL: Input not a ResponseFileWrapper, returning input");
                retJSON = json;
            }
        }
        catch (JsonParseException e) {
            logger.error((Object)"JSON-PARSE ERROR: Input not a ResponseFileWrapper, returning input");
            logger.error((Object)e);
            retJSON = json;
            logger.error((Object)retJSON);
        }
        return retJSON;
    }

    private static String zapWhiteSpace(String s) {
        return s.replaceAll("\\s+", "");
    }

    private static byte[] read(File f) throws IOException {
        byte[] data = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        long len = f.length();
        int lenInt = (int)len;
        data = new byte[lenInt];
        bis.read(data, 0, lenInt);
        bis.close();
        return data;
    }
}

