/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.edgeware.utils;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class OriginWFSResponseFile {
    private static Logger logger = Logger.getLogger(OriginWFSResponseFile.class);
    private static final String TEMP_DIR = "/content/temp/";
    private static final String PREFIX = "origin_";
    private String json;
    private String type;
    private String tmpDir;
    private String name;
    private String filepath;

    public OriginWFSResponseFile(String json, String type) {
        this(json, type, TEMP_DIR);
    }

    public OriginWFSResponseFile(String json, String type, String tmpDir) {
        this.json = json;
        this.type = type;
        this.tmpDir = tmpDir;
        this.initialize();
    }

    private void initialize() {
        String stamp = OriginWFSResponseFile.formatNano(new Date());
        this.name = PREFIX + this.type + "_" + stamp + ".json";
        this.filepath = this.tmpDir + this.name;
    }

    public String getFilePath() {
        return this.filepath;
    }

    public void write() throws FileNotFoundException, IOException {
        OriginWFSResponseFile.write(new File(this.filepath), this.json);
    }

    private static void write(File outputFile, String input) throws FileNotFoundException, IOException {
        outputFile.createNewFile();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(outputFile));
        byte[] data = input.getBytes("utf-8");
        dos.write(data);
        dos.close();
    }

    public static String formatNano(Date date) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'_'HHmmss");
        long nano = System.nanoTime();
        if (nano < 0L) {
            nano *= -1L;
        }
        String nanoStr = OriginWFSResponseFile.trimNano(nano);
        sb.append(df.format(date)).append(".").append(nanoStr);
        return sb.toString();
    }

    private static String trimNano(long nano) {
        String nanoStr = String.valueOf(nano);
        int len = nanoStr.length();
        if (len > 9) {
            int offset = len - 9;
            nanoStr = nanoStr.substring(offset);
        }
        return nanoStr;
    }
}

