/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.errorwidget;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ErrorWidget {
    private static final String MESSAGE = "message";
    private static final String ACTION = "action";
    private static final String CODE = "code";
    private static final String ERROR = "error";
    private static final String NOT_FOUND = "Error: Message not Found.";
    private static final String FILE_NOT_FOUND = "Error: XML Error Code Reference File not Found.";
    private static final String PARSER_ERROR = "Error: Error parsing file.";
    private static final String XML_FAILURE = "Error: XML sax library error.";

    public static synchronized String getErrorMessage(String errorCode) throws Exception {
        return ErrorWidget.searchXML(MESSAGE, errorCode);
    }

    public static synchronized String getErrorAction(String errorCode) throws Exception {
        return ErrorWidget.searchXML(ACTION, errorCode);
    }

    private static NodeList prepareReading() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("ErrorList.xml");
        Document doc = docBuilder.parse(in);
        doc.getDocumentElement().normalize();
        NodeList listOfErrors = doc.getElementsByTagName(ERROR);
        in.close();
        return listOfErrors;
    }

    private static String searchXML(String messageType, String errorCode) {
        NodeList listOfErrors;
        try {
            listOfErrors = ErrorWidget.prepareReading();
        }
        catch (ParserConfigurationException e) {
            return PARSER_ERROR;
        }
        catch (SAXException e) {
            return XML_FAILURE;
        }
        catch (IOException e) {
            return FILE_NOT_FOUND;
        }
        for (int s = 0; s < listOfErrors.getLength(); ++s) {
            Element firstErrorElement;
            NodeList codes;
            Element code;
            NodeList textFNList;
            Node node = listOfErrors.item(s);
            if (node.getNodeType() != 1 || !errorCode.equals((textFNList = (code = (Element)(codes = (firstErrorElement = (Element)node).getElementsByTagName(CODE)).item(0)).getChildNodes()).item(0).getNodeValue().trim())) continue;
            NodeList messages = firstErrorElement.getElementsByTagName(messageType);
            Element message = (Element)messages.item(0);
            NodeList textLNList = message.getChildNodes();
            return textLNList.item(0).getNodeValue().trim();
        }
        return NOT_FOUND;
    }
}

