/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.io;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AppendableFile {
    private static Logger logger = Logger.getLogger(AppendableFile.class);
    private static final String TEMP_DIR = "/content/temp/";
    private String data = "";
    private String type;
    private String name;
    private String filepath;
    private String extension;

    private AppendableFile(String type, String extension) {
        this.type = type;
        this.extension = extension;
        this.initialize();
    }

    public static String create(String prefix, String extension) throws IOException {
        AppendableFile report = new AppendableFile(prefix, extension);
        String filepath = report.getFilePath();
        report.write();
        return filepath;
    }

    public static void appendReport(String filepath, String data) throws IOException {
        AppendableFile.append(filepath, data);
    }

    public static String read(String filepath) throws IOException {
        File file = new File(filepath);
        byte[] data = AppendableFile.read(file);
        return new String(data);
    }

    private static byte[] read(File f) throws IOException {
        byte[] data = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        long len = f.length();
        int lenInt = (int)len;
        data = new byte[lenInt];
        bis.read(data, 0, lenInt);
        bis.close();
        return data;
    }

    private void initialize() {
        String stamp = AppendableFile.formatNano(new Date());
        this.name = this.type + stamp + "." + this.extension;
        this.filepath = TEMP_DIR + this.name;
    }

    public String getFilePath() {
        return this.filepath;
    }

    private void write() throws FileNotFoundException, IOException {
        AppendableFile.append(new File(this.filepath), this.data);
    }

    public static void append(String filepath, String data) throws FileNotFoundException, IOException {
        File file = new File(filepath);
        AppendableFile.append(file, data);
    }

    private static void write(File outputFile, String input) throws FileNotFoundException, IOException {
        outputFile.createNewFile();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(outputFile));
        byte[] data = input.getBytes("utf-8");
        dos.write(data);
        dos.close();
    }

    private static void append(File outputFile, String input) throws FileNotFoundException, IOException {
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FileWriter fw = new FileWriter(outputFile, true);
        BufferedWriter buffer = new BufferedWriter(fw);
        buffer.write(input);
        buffer.close();
    }

    private static String formatNano(Date date) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'_'HHmmss");
        long nano = System.nanoTime();
        if (nano < 0L) {
            nano *= -1L;
        }
        String nanoStr = AppendableFile.trimNano(nano);
        sb.append(df.format(date)).append(".").append(nanoStr);
        return sb.toString();
    }

    private static String trimNano(long nano) {
        String nanoStr = String.valueOf(nano);
        int len = nanoStr.length();
        if (len > 9) {
            int offset = len - 9;
            nanoStr = nanoStr.substring(offset);
        }
        return nanoStr;
    }
}

