/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.io;

import com.ericsson.scac.cms.EncodingUtil;
import com.ericsson.scac.cms.Replacer;
import com.ericsson.scac.cms.StringCodec;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import org.apache.log4j.Logger;

public class IO {
    static final Logger logger = Logger.getLogger(IO.class);
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String baseName(String fullName) {
        logger.debug((Object)"compress()");
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex != -1 ? fullName.substring(0, dotIndex) : fullName;
    }

    public static void checkFile(File file) throws IOException {
        IO.checkFile(file, false);
    }

    public static void checkFile(File file, boolean strict) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is <NULL> !!!");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("FILENOTFOUND !!!   PATH->" + file.getAbsolutePath());
        }
        if (!(!strict || file.isFile() && file.canRead())) {
            throw new IOException("ERROR on File TYPE / PERMISSIONS !!!   PATH->" + file.getAbsolutePath());
        }
    }

    public static void close(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        closable = null;
    }

    public static String combinePaths(String part1, String part2, char separator) {
        int start;
        int end;
        logger.debug((Object)"combinePaths()");
        if (part1.length() == 0) {
            return part2;
        }
        if (part2.length() == 0) {
            return part1;
        }
        for (end = part1.length(); end > 0 && part1.charAt(end - 1) == separator; --end) {
        }
        if (part1.endsWith("" + separator + separator)) {
            ++end;
        }
        for (start = 0; start < part2.length() && part2.charAt(start) == separator; ++start) {
        }
        return part1.substring(0, end) + separator + part2.substring(start, part2.length());
    }

    public static String compress(String str) {
        logger.debug((Object)"compress()");
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        byte[] serObj = str.getBytes();
        compressor.setInput(serObj);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(serObj.length);
        byte[] buf = new byte[1096];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        IO.close(bos);
        return new String(bos.toByteArray());
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static void copyDirectory(File srcDir, File destDir, boolean forceCopy) throws IOException {
        File[] files;
        logger.debug((Object)("copyDirectory()  SRC->" + srcDir.getAbsolutePath() + "   DEST->" + destDir.getAbsolutePath()));
        destDir.mkdir();
        if (!srcDir.isDirectory()) {
            throw new IOException("Missing directory " + srcDir.getAbsolutePath());
        }
        for (File file : files = srcDir.listFiles()) {
            if (file.isDirectory()) {
                IO.copyDirectory(file, new File(destDir, file.getName()), forceCopy);
                continue;
            }
            if (!file.isFile()) continue;
            IO.copyFile(file.getAbsolutePath(), destDir, forceCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest, boolean forceCopy) throws IOException {
        logger.debug((Object)("copyFile()  SRC->" + src.getAbsolutePath() + "   DEST->" + dest.getAbsolutePath()));
        if (src.isDirectory()) {
            File[] files;
            if (!dest.isDirectory()) {
                throw new IOException("copyFile: Cannot copy directory onto single file");
            }
            for (File file : files = src.listFiles()) {
                IO.copyFile(file, dest, forceCopy);
            }
        } else {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (src.getName().equalsIgnoreCase("Thumbs.db")) {
                return;
            }
            if (!forceCopy && dest.exists()) {
                return;
            }
            if (dest.exists() && !dest.canWrite()) {
                return;
            }
            long lastModified = src.lastModified();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                int bytesRead;
                byte[] buffer = new byte[65536];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                IO.close(in);
                IO.close(out);
                dest.setLastModified(lastModified);
            }
        }
    }

    public static void copyFile(String name, File dest, boolean forceCopy) throws IOException {
        IO.copyFile(new File(name), dest, forceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createChecksum(File file, String alg) throws IOException, NoSuchAlgorithmException {
        byte[] byArray;
        FileInputStream fis = null;
        try {
            int numRead;
            fis = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            MessageDigest complete = MessageDigest.getInstance(alg);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byArray = complete.digest();
        }
        catch (Throwable throwable) {
            IO.close(fis);
            throw throwable;
        }
        IO.close(fis);
        return byArray;
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return IO.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        File f;
        String tmpDir;
        logger.debug((Object)("createTempDirectory()  DIR->" + directory.getAbsolutePath() + "  PREFIX->" + prefix + "   SUFFIX->" + suffix));
        if (prefix == null) {
            throw new NullPointerException();
        }
        String string = suffix = suffix == null ? ".tmp" : suffix;
        if (directory == null && (directory = new File(tmpDir = System.getProperty("java.io.tmpdir"))).isFile()) {
            throw new IOException("TEMP BASE DIR IS A NORMAL FILE!!!  DIR->" + directory.getAbsolutePath());
        }
        if (!directory.exists()) {
            logger.warn((Object)("tmp dir does NOT exist!!! attemptin gto create TMP-> " + directory.getAbsolutePath()));
            if (!directory.mkdirs()) {
                throw new IOException("TEMP BASE DIR COULD NOT BE CREATED!!  DIR->" + directory.getAbsolutePath());
            }
        }
        while (!(f = new File(directory, prefix + Integer.toString(new Random().nextInt() & 0xFFFF) + suffix)).mkdir()) {
        }
        return f;
    }

    public static long deepLastModified(File dir) throws IOException {
        File[] files;
        logger.debug((Object)("moveDirectory()  DIR->" + dir.getAbsolutePath()));
        long lastModified = dir.lastModified();
        for (File file : files = dir.listFiles()) {
            long lm = file.lastModified();
            if (file.isDirectory()) {
                lm = IO.deepLastModified(file);
            }
            if (lm <= lastModified) continue;
            lastModified = lm;
        }
        return lastModified;
    }

    public static boolean deleteDir(File fileOrDir) {
        logger.debug((Object)("deleteDir() fileOrDirPath->" + fileOrDir.getAbsolutePath()));
        if (fileOrDir.exists()) {
            for (File file : fileOrDir.listFiles()) {
                if (file.isDirectory()) {
                    IO.deleteDir(file);
                    continue;
                }
                String msg = "DELETING FILE->" + file.getAbsolutePath() + "   RESULT->" + file.delete();
                logger.debug((Object)msg);
            }
        } else {
            logger.warn((Object)("provided path does not resolve to any files/dir on local filesystem! PATH->" + fileOrDir.getAbsolutePath()));
        }
        return fileOrDir.delete();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    IO.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    public static String extensionOf(File file) {
        return IO.extensionOf(file.getName());
    }

    public static String extensionOf(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = fullName.length() - 1;
        }
        return fullName.substring(dotIndex + 1);
    }

    public static Object marshallObject(String objString) {
        ByteArrayInputStream inStream = new ByteArrayInputStream(objString.getBytes());
        BufferedInputStream bufStream = new BufferedInputStream(inStream);
        XMLDecoder decoder = new XMLDecoder(bufStream);
        return decoder.readObject();
    }

    public static String md5(File file) throws FileNotFoundException, NoSuchAlgorithmException {
        return IO.md5(file, "MD5");
    }

    public static String md5(File file, String algorithm) throws FileNotFoundException, NoSuchAlgorithmException {
        try {
            byte[] b = IO.createChecksum(file, algorithm);
            String result = "";
            for (byte element : b) {
                result = result + Integer.toString((element & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
    }

    public static boolean moveDirectory(File srcDirectory, File destDirectory) throws IOException {
        logger.debug((Object)("moveDirectory()  SRC->" + srcDirectory.getAbsolutePath() + "   DEST->" + destDirectory.getAbsolutePath()));
        if (!srcDirectory.isDirectory()) {
            throw new IOException("moveDirectory: SRC is not a directory!    SRC->" + srcDirectory.getAbsolutePath());
        }
        if (destDirectory.exists() && destDirectory.isFile()) {
            throw new IOException("moveDirectory: DEST is an existing plain file!    DEST->" + destDirectory.getAbsolutePath());
        }
        if (destDirectory.exists() && destDirectory.isDirectory()) {
            destDirectory = new File(destDirectory, srcDirectory.getName());
            logger.info((Object)("created DEST dir!   DEST->" + destDirectory.getAbsolutePath()));
        }
        if (srcDirectory.renameTo(destDirectory)) {
            logger.debug((Object)"move COMPLETE!");
            return true;
        }
        IO.copyDirectory(srcDirectory, destDirectory, true);
        IO.deleteDir(srcDirectory);
        return false;
    }

    public static byte[] readBytes(File f) throws IOException {
        byte[] buf = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        in.read(buf);
        IO.close(in);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readMapFile(File file) throws IOException {
        Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);
        String s = IO.readTextFile(file);
        BufferedReader in = new BufferedReader(new StringReader(s));
        try {
            String line;
            HashMap<String, String> theMap = new HashMap<String, String>();
            while ((line = in.readLine()) != null) {
                int equalsIndex;
                if ((line = line.trim()).startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, equalsIndex).trim();
                String value = line.substring(equalsIndex + 1).trim();
                while (IO.continueLine(line)) {
                    value = value.substring(0, value.length() - 1);
                    line = in.readLine();
                    if (line == null) break;
                    value = value + "\n" + line;
                }
                value = backslashPattern.matcher(value).replaceAll("\\\\");
                theMap.put(key, value);
            }
            HashMap<String, String> hashMap = theMap;
            return hashMap;
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(File file) throws IOException {
        Properties properties;
        logger.debug((Object)("readPropertyFile()  PROPS->" + file.getAbsolutePath()));
        FileInputStream fis = null;
        try {
            Properties props = new Properties();
            fis = new FileInputStream(file);
            props.load(fis);
            properties = props;
        }
        catch (Throwable throwable) {
            IO.close(fis);
            throw throwable;
        }
        IO.close(fis);
        return properties;
    }

    public static String readTextFile(File file) throws IOException {
        return IO.readTextFile(file, System.getProperty("file.encoding"));
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        logger.debug((Object)("readTextFile() FILE->" + file.getAbsolutePath() + "   ENCODING->" + encoding));
        IO.checkFile(file, true);
        byte[] buf = IO.readBytes(file);
        EncodingUtil codec = new EncodingUtil();
        return codec.decode(buf, encoding);
    }

    public static String readTextUrl(URL textUrl) throws IOException {
        int offset;
        logger.debug((Object)("readTextUrl()  URL->" + textUrl.getPath()));
        URLConnection conn = textUrl.openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            throw new IOException("Couldn't connect to " + textUrl);
        }
        byte[] bytes = new byte[length];
        InputStream is = conn.getInputStream();
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read from " + textUrl);
        }
        IO.close(is);
        StringCodec codec = new StringCodec();
        return codec.decode(bytes, System.getProperty("file.encoding"));
    }

    public static String relativePath(File file, File rel) {
        StringTokenizer tokens;
        int i;
        logger.debug((Object)"relativePath()");
        String fileString = file.getAbsolutePath();
        String relString = rel.getAbsolutePath();
        char[] filePath = fileString.toCharArray();
        char[] relPath = relString.toCharArray();
        StringBuffer result = new StringBuffer();
        for (i = 0; i < filePath.length && i < relPath.length && filePath[i] == relPath[i]; ++i) {
        }
        if (i < relPath.length && i < filePath.length || relPath.length < filePath.length && filePath[i] != File.separatorChar) {
            while (i > 0 && relPath[i - 1] != File.separatorChar) {
                --i;
            }
        }
        if (i != 0) {
            tokens = new StringTokenizer(relString.substring(i), File.separator);
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                result.append("../");
            }
        }
        if ((tokens = new StringTokenizer(fileString.substring(i), File.separator)).hasMoreTokens()) {
            result.append(tokens.nextToken());
        } else if (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        while (tokens.hasMoreTokens()) {
            result.append("/" + tokens.nextToken());
        }
        String res = result.toString();
        return res.equals("") ? "." : res;
    }

    public static String serializeObject(Object obj) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BufferedOutputStream bufStream = new BufferedOutputStream(outStream);
        XMLEncoder encoder = new XMLEncoder(bufStream);
        encoder.writeObject(obj);
        encoder.close();
        return outStream.toString();
    }

    public static int sizeof(Object o) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ba);
            oos.writeObject(o);
            return ba.toByteArray().length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static String urlEncode(String s) {
        char[] chars;
        logger.debug((Object)"urlEncode()");
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bytes = StringCodec.isEncodable(s, System.getProperty("file.encoding")) ? s.getBytes(System.getProperty("file.encoding")) : s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        for (char c : chars = s.toCharArray()) {
            if (c > '\u007f' || c == ' ' || c == '#' || c == '%') {
                sb.append('%');
                sb.append(hexDigits[(c & 0xF0) >> 4]);
                sb.append(hexDigits[c & 0xF]);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void writeBytes(byte[] buf, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        out.write(buf);
        IO.close(out);
    }

    public static boolean writeChangedTextFile(String content, File file, String encoding) throws IOException {
        if (!file.exists()) {
            IO.writeTextFile(content, file, encoding);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
        writer.write(content);
        IO.close(writer);
        byte[] outBytes = out.toByteArray();
        byte[] inBytes = IO.readBytes(file);
        if (!Arrays.equals(outBytes, inBytes)) {
            IO.writeBytes(outBytes, file);
            return true;
        }
        return false;
    }

    public static void writeMapFile(Map<Object, Object> map, File f) throws IOException {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
        }
        IO.close(out);
        String s = writer.getBuffer().toString();
        StringCodec codec = new StringCodec();
        byte[] bytes = codec.encode(s);
        if (!s.equals(codec.decode(bytes))) {
            bytes = codec.encode(s, "UTF-8");
        }
        IO.writeBytes(bytes, f);
    }

    public static void writeTextFile(String content, File file) throws IOException {
        IO.writeTextFile(content, file, System.getProperty("file.encoding"));
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        logger.debug((Object)("writeTextFile()  FILE->" + file.getAbsolutePath() + "   ENCODING->" + encoding));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        writer.write(content);
        IO.close(writer);
    }

    public void deleteFile(String filePath) throws IOException {
        if (!new File(filePath).delete()) {
            throw new IOException("Failed to delete '" + filePath + "'!");
        }
        logger.debug((Object)("File: " + filePath + " is deleted"));
    }
}

