/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.io;

import com.ericsson.scac.cms.workflow.utils.ManipulateFile;
import java.io.File;
import org.apache.log4j.Logger;

public class NamingUtils {
    private static final Logger logger = Logger.getLogger(NamingUtils.class);
    private static final String EXTENSION_SEPARATOR = ".";
    private static final String SUFFIX_SEPARATOR = "_";
    private static final int NAME_LENGTH_LIMIT = 100;
    private static final float NAME_LENGTH_THRESHOLD = 0.8f;

    public static String sanitizeName(String dirty) throws IllegalArgumentException {
        if (dirty == null || "".equals(dirty)) {
            throw new IllegalArgumentException("A null or empty String was provided.");
        }
        if (dirty.contains(File.separator)) {
            throw new IllegalArgumentException("Only file NAMES are allowed, NOT file PATHS!");
        }
        String clean = dirty.replaceAll(" ", SUFFIX_SEPARATOR).replaceAll("\\(", "-").replaceAll("\\)", "-").replaceAll("[^.a-zA-Z0-9_-]", "-");
        return clean;
    }

    public static String uniqueName(String originalName, String providerId, String workOrderId) {
        String name = new ManipulateFile().getFilename(originalName);
        String ext = new ManipulateFile().getExtension(originalName);
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(SUFFIX_SEPARATOR).append(System.currentTimeMillis()).append(SUFFIX_SEPARATOR).append(providerId).append(SUFFIX_SEPARATOR).append(workOrderId).append(EXTENSION_SEPARATOR).append(ext);
        return sb.toString();
    }

    public static String pruneName(String name) {
        logger.debug((Object)("called for: " + name));
        String pruned = null;
        int len = name.length();
        int thresLimit = 80;
        if (len > thresLimit) {
            int overage = len - thresLimit;
            logger.debug((Object)("name exceeds threshold (" + thresLimit + "): " + len));
            logger.debug((Object)("overage: " + overage));
            pruned = name.replaceAll("[-]+", "-");
            pruned = pruned.replaceAll("[_]+", SUFFIX_SEPARATOR);
            logger.debug((Object)("collapsed duplicate chars ( - _ ): " + pruned));
            len = pruned.length();
            if (len > thresLimit) {
                overage = len - thresLimit;
                logger.debug((Object)"name still exceeds limit, pruning from the left");
                pruned = pruned.substring(overage);
            }
        } else {
            logger.debug((Object)"name is within limits, no changes are needed");
            pruned = name;
        }
        logger.debug((Object)("pruned: " + pruned));
        return pruned;
    }
}

