/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.notification;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Email {
    private static final String TOKEN_START = "%";
    private static final String TOKEN_END = "%";
    private String smtpServerName = "";
    private Integer smtpServerPort;
    private Boolean authenticationEnable = false;
    private String smtpUsername = "";
    private String smtpPassword = "";
    private String from = "";
    private String[] to;
    private String[] cc = null;
    private String[] bcc = null;
    private String subject = "";
    private String body = "";

    public Email(String from, String[] to, String[] cc, String[] bcc, String subject, String bodyTemplate, Properties bodyTokens) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = this.addTokens(bodyTemplate, bodyTokens);
    }

    public Email(String from, String[] to, String[] cc, String[] bcc, String subject, String body) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = body;
    }

    public Email(String from, String[] to, String[] cc, String subject, String body) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.subject = subject;
        this.body = body;
    }

    public Email(String from, String[] to, String subject, String body) {
        this.from = from;
        this.to = to;
        this.subject = subject;
        this.body = body;
    }

    public String getSmtpServerName() {
        return this.smtpServerName;
    }

    public Integer getSmtpServerPort() {
        return this.smtpServerPort;
    }

    public Boolean getAuthenticationEnable() {
        return this.authenticationEnable;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public String getFrom() {
        return this.from;
    }

    public String[] getTo() {
        return this.to;
    }

    public String[] getCc() {
        return this.cc;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public void SetMailServer(String smtpServerName, Integer smtpServerPort, String smtpServerUsername, String smtpServerPassword) {
        this.smtpServerName = smtpServerName;
        this.smtpServerPort = smtpServerPort;
        this.smtpUsername = smtpServerUsername;
        this.smtpPassword = smtpServerPassword;
        this.authenticationEnable = smtpServerUsername != "" && smtpServerPassword != "" ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.authenticationEnable = false;
    }

    public void setMailServer(String serverName, Integer serverPort) {
        this.smtpServerName = serverName;
        this.smtpServerPort = serverPort;
        this.authenticationEnable = false;
    }

    private String addTokens(String aTemplate, Properties theTokens) {
        int si = 0;
        int i = 0;
        String theTemplateText = aTemplate;
        StringBuffer result = new StringBuffer();
        try {
            for (String aToken : theTokens.stringPropertyNames()) {
                if (aToken.length() == 0) continue;
                while ((i = theTemplateText.indexOf(aToken, si)) >= 0) {
                    result.append(theTemplateText.substring(si, i));
                    result.append(theTokens.getProperty(aToken));
                    si = i + aToken.length();
                }
                result.append(theTemplateText.substring(si));
                theTemplateText = result.toString();
                result.delete(0, result.length());
                si = 0;
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return theTemplateText;
    }

    public Boolean ValidateTemplate(String aTemplateFile, Properties theTokens) {
        int si = 0;
        int ts = 0;
        int te = 0;
        Boolean foundToken = false;
        while ((ts = aTemplateFile.indexOf("%", si)) >= 0) {
            foundToken = false;
            while ((te = aTemplateFile.indexOf("%", ts)) >= 0) {
                String token;
                String tokenValue;
                foundToken = true;
                if ((tokenValue = theTokens.getProperty(token = aTemplateFile.substring(ts, ++te))).length() == 0) {
                    return false;
                }
                si = ++te;
            }
            if (foundToken.booleanValue()) continue;
            return false;
        }
        if (!foundToken.booleanValue() && (te = aTemplateFile.indexOf("%", si = 0)) >= 0) {
            return false;
        }
        return true;
    }

    public void sendMail() throws MessagingException {
        int i;
        boolean debug = false;
        Session session = this.getSession();
        session.setDebug(debug);
        MimeMessage email = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress(this.from);
        email.setFrom((Address)addressFrom);
        InternetAddress[] addressTo = new InternetAddress[this.to.length];
        for (int i2 = 0; i2 < this.to.length; ++i2) {
            addressTo[i2] = new InternetAddress(this.to[i2]);
        }
        email.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        if (this.cc != null) {
            InternetAddress[] addressCc = new InternetAddress[this.cc.length];
            for (i = 0; i < this.cc.length; ++i) {
                addressCc[i] = new InternetAddress(this.cc[i]);
            }
            email.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
        }
        if (this.bcc != null) {
            InternetAddress[] addressBcc = new InternetAddress[this.bcc.length];
            for (i = 0; i < this.bcc.length; ++i) {
                addressBcc[i] = new InternetAddress(this.bcc[i]);
            }
            email.setRecipients(Message.RecipientType.BCC, (Address[])addressBcc);
        }
        email.setSubject(this.subject);
        email.setContent((Object)this.body, "text/plain");
        Transport transport = session.getTransport();
        transport.connect(this.smtpServerName, this.smtpServerPort.intValue(), this.smtpUsername, this.smtpPassword);
        Transport.send((Message)email);
    }

    private Session getSession() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.smtpServerName);
        props.setProperty("mail.transport.protocol", "smtp");
        Authenticator authenticator = new Authenticator(props);
        if (this.authenticationEnable.booleanValue()) {
            return Session.getInstance((Properties)props, (javax.mail.Authenticator)authenticator);
        }
        return Session.getInstance((Properties)props, null);
    }

    private class Authenticator
    extends javax.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator(Properties propertyFile) {
            String username = propertyFile.getProperty("mail.smtp.user");
            String password = propertyFile.getProperty("mail.smtp.password");
            this.authentication = new PasswordAuthentication(username, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

