/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.titlelist;

import com.ericsson.scac.cms.titlelist.TitlelistEntry;
import com.ericsson.scac.cms.titlelist.TitlelistInfo;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class TitlelistUtils {
    private static final Logger logger = Logger.getLogger(TitlelistUtils.class);
    public static final String TLTYPE_BARKER = "Barker";
    public static final String PREVIEW_ASSET_TYPE = "PREVIEW";
    public static final String TITLE_ASSET_TYPE = "TITLE";
    public static final String MOVIE_ASSET_TYPE = "MOVIE";
    public static final String XPATH_ASSET_ID = "/tns:Fields/tns:Identifier/tns:Id";
    public static final String XPATH_ASSET_DESCRIPTION = "/tns:Fields/tns:Description/tns:Text";
    public static final String XPATH_PROVIDER_NAME = "/tns:Fields/tns:ProviderInfo/tns:Name";
    public static final String XPATH_PUBLISH = "/tns:Fields/tns:Rights/tns:LicensingWindowStart";
    public static final String XPATH_UNPUBLISH = "/tns:Fields/tns:Rights/tns:LicensingWindowEnd";
    public static final String XPATH_LOOKUP_KEY = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=LookupKey]/@value";
    public static final String XPATH_TRANSCODE = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=TRANSCODE]/@value";
    public static final String XPATH_RUNTIME = "/tns:Fields/tns:Duration/tns:Duration";
    public static final String XPATH_PROVIDER_ID = "/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id";
    public static final String XPATH_SHORT_TITLE = "/tns:Fields/tns:Title/tns:ShortTitle/tns:Value";
    public static final String XPATH_TITLE_DISPLAY_TITLE_TTV_ = "//*[local-name()='Item'][@type='TITLE']/*[local-name()='Fields']/*[local-name()='Title']/*[local-name()='DisplayTitle']/*[local-name()='Value']";

    public static IAssetListManager getAssetListManager() throws NamingException {
        return (IAssetListManager)new InitialContext().lookup("cms/AssetListManager/local");
    }

    public static TitlelistInfo getTitlelistInfo(AssetList al) {
        TitlelistInfo tl = new TitlelistInfo();
        tl.setName(al.getName());
        tl.setDescription(al.getDescription());
        tl.setTitleListId(String.valueOf(al.getId()));
        tl.setStartTime(TitlelistUtils.getTimeValue(al, "Playout Start Time"));
        tl.setStopTime(TitlelistUtils.getTimeValue(al, "Playout Stop Time"));
        tl.setBarkerType(TitlelistUtils.getStringValue(al, "Barker Type"));
        tl.setAlternatingType(TitlelistUtils.getStringValue(al, "Alternating Type"));
        tl.setChannelId(TitlelistUtils.getStringValue(al, "Channel Id"));
        tl.setActive(TitlelistUtils.getStringValue(al, "Active"));
        return tl;
    }

    public static List<TitlelistEntry> getTitlelistEntries(AssetList al) {
        ArrayList<TitlelistEntry> tleList = new ArrayList<TitlelistEntry>();
        List mapList = al.getAssetsMap();
        for (AssetListAssetMap am : mapList) {
            long targetAssetId = am.getAssetId();
            Title title = am.getTitle();
            Asset parentAsset = title.getAsset();
            Asset targetAsset = parentAsset.getAsset(targetAssetId);
            logger.debug((Object)("id: " + am.getId()));
            logger.debug((Object)("asset-id: " + am.getAssetId()));
            logger.debug((Object)("title-id: " + title.getId()));
            List titleAssets = title.getAsset().getAllAssetsOfType(TITLE_ASSET_TYPE);
            if (titleAssets.size() == 1) {
                Asset asset = (Asset)titleAssets.get(0);
                Field startField = TitlelistUtils.getAssetField(XPATH_PUBLISH, asset);
                Field stopField = TitlelistUtils.getAssetField(XPATH_UNPUBLISH, asset);
                Date startDate = null;
                if (startField != null) {
                    startDate = (Date)startField.getTypedValue();
                }
                Date stopDate = null;
                if (stopField != null) {
                    stopDate = (Date)stopField.getTypedValue();
                    stopDate = TitlelistUtils.setTimeToEndOfDay(stopDate);
                }
                Field titleNameField = TitlelistUtils.getAssetField(XPATH_SHORT_TITLE, asset);
                String titleName = null;
                if (titleNameField != null) {
                    titleName = (String)titleNameField.getTypedValue();
                }
                long titleId = title.getId();
                String assetId = null;
                Field assetIdField = TitlelistUtils.getAssetField(XPATH_ASSET_ID, targetAsset);
                if (assetIdField != null) {
                    assetId = (String)assetIdField.getTypedValue();
                }
                String assetType = targetAsset.getAssetType();
                TitlelistEntry tle = new TitlelistEntry(titleId, titleName, assetId, assetType, startDate, stopDate);
                tleList.add(tle);
            }
            logger.debug((Object)"\n");
        }
        return tleList;
    }

    private static Date setTimeToEndOfDay(Date date) {
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(date);
        int hour = newDate.get(10);
        int minute = newDate.get(12);
        int second = newDate.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            newDate.set(10, 23);
            newDate.set(12, 59);
            newDate.set(13, 59);
        }
        return newDate.getTime();
    }

    private static Field getAssetField(String fieldName, Asset asset) {
        Field field = null;
        field = asset.getFirstField(fieldName);
        return field;
    }

    private static String getAssetString(AssetList assetList, String attrname) {
        String value = null;
        AssetListMetadata metadata = TitlelistUtils.getAssetListMetadata(assetList, attrname);
        if (metadata != null) {
            value = metadata.getStringValue();
        }
        return value;
    }

    private static AssetListMetadata getAssetListMetadata(AssetList assetList, String attrname) {
        AssetListMetadata metadata = null;
        if (assetList != null && attrname != null) {
            metadata = assetList.getAssetListMetadata(attrname);
        }
        return metadata;
    }

    public static byte[] getImageValue(AssetList al, String attrname) {
        byte[] imageValue = null;
        for (AssetListMetadata alm : al.getListMetadata()) {
            if (!attrname.equalsIgnoreCase(alm.getName()) || alm.getImageValue() == null) continue;
            imageValue = alm.getImageValue();
            break;
        }
        return imageValue;
    }

    public static String getStringValue(AssetList al, String attrname) {
        String stringValue = null;
        for (AssetListMetadata alm : al.getListMetadata()) {
            String almName = alm.getName();
            if (!attrname.equalsIgnoreCase(almName)) continue;
            if (alm.getStringValue() != null) {
                stringValue = alm.getStringValue();
                break;
            }
            logger.info((Object)(attrname + "-value: is NULL!"));
        }
        return stringValue;
    }

    public static String getTimeValue(AssetList al, String attrname) {
        String timeValue = null;
        for (AssetListMetadata alm : al.getListMetadata()) {
            if (!attrname.equalsIgnoreCase(alm.getName()) || alm.getTimeValue() == null) continue;
            timeValue = alm.getTimeValue();
            break;
        }
        return timeValue;
    }

    public static String getCMSFieldValue(Asset cmsAsset, String xpath) {
        Field cmsField = null;
        String assetValue = null;
        if (cmsAsset != null) {
            cmsField = cmsAsset.getFirstField(xpath);
        }
        if (cmsField != null) {
            assetValue = cmsField.getValue();
        }
        return assetValue;
    }

    public static String getAssetId(Asset as) {
        Field field = as.getField(XPATH_ASSET_ID);
        String assetId = null;
        if (field != null) {
            assetId = field.getValue();
        }
        return assetId;
    }

    public static Asset getTitleAsset(Asset topLevelAsset) {
        Asset titleAsset = null;
        List titleAssetList = topLevelAsset.getAllAssetsOfType(TITLE_ASSET_TYPE);
        if (titleAssetList != null && titleAssetList.size() > 0) {
            titleAsset = (Asset)titleAssetList.get(0);
        }
        return titleAsset;
    }

    public static String getPackageAssetId(AssetList cmsTitleList) {
        String packageAssetId = null;
        AssetListAssetMap cmsAssetMap = (AssetListAssetMap)cmsTitleList.getAssetsMap().get(0);
        Asset topLevelAsset = cmsAssetMap.getTitle().getAsset();
        packageAssetId = TitlelistUtils.getCMSFieldValue(topLevelAsset, XPATH_ASSET_ID);
        return packageAssetId;
    }

    public static String getPackageAssetId(Title title) {
        String packageAssetId = null;
        Asset topLevelAsset = title.getAsset();
        packageAssetId = TitlelistUtils.getCMSFieldValue(topLevelAsset, XPATH_ASSET_ID);
        return packageAssetId;
    }

    public static List<AssetList> getListOfBarkerAssetsList(List<AssetList> list, Map<String, String> attributes) {
        ArrayList<AssetList> barkerAssetList = null;
        for (AssetList assetList : list) {
            if (!TLTYPE_BARKER.equals(assetList.getType())) continue;
            boolean addToAssetList = true;
            for (String attrib : attributes.keySet()) {
                String actualValue = TitlelistUtils.getStringValue(assetList, attrib);
                String expectValue = attributes.get(attrib);
                if (expectValue.equals(actualValue)) continue;
                addToAssetList = false;
            }
            if (!addToAssetList) continue;
            if (barkerAssetList == null) {
                barkerAssetList = new ArrayList<AssetList>();
            }
            barkerAssetList.add(assetList);
        }
        return barkerAssetList;
    }

    public static AssetList getAssetList(long targetId) throws NamingException {
        AssetList match_al = null;
        IAssetListManager almngr = TitlelistUtils.getAssetListManager();
        List lists = almngr.getAllAssetLists();
        for (AssetList al : lists) {
            long id = al.getId();
            if (id != targetId) continue;
            match_al = al;
            break;
        }
        return match_al;
    }

    public static List<AssetList> getAllAssetListsByType(String type) throws NamingException {
        logger.debug((Object)("called for type: " + type));
        List totalList = TitlelistUtils.getAssetListManager().getAllAssetLists();
        ArrayList<AssetList> matchedList = new ArrayList<AssetList>();
        for (AssetList al : totalList) {
            String alType = al.getType();
            logger.debug((Object)("alType: " + alType));
            if (!alType.equalsIgnoreCase(type)) continue;
            logger.debug((Object)"match found, adding to return list");
            matchedList.add(al);
        }
        return matchedList;
    }
}

