/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FFMPEG {
    private static final Logger logger = Logger.getLogger(FFMPEG.class);
    private static final String CMD_FFPROBE = "/opt/tandbergtv/tools/bin/ffprobe ";
    private static final String OPT_SHOW_FORMAT = "-show_format ";

    public static String getDuration(String filepath) throws IOException {
        String duration = null;
        logger.debug((Object)("filepath: " + filepath));
        String command = CMD_FFPROBE + filepath;
        logger.debug((Object)("command: " + command));
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader input_br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader error_br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        String s = "";
        while ((s = input_br.readLine()) != null) {
            sb.append(s).append("\n");
        }
        while ((s = error_br.readLine()) != null) {
            sb.append(s).append("\n");
        }
        String output = sb.toString();
        logger.debug((Object)("output: " + output));
        duration = FFMPEG.parseOutput(output);
        logger.info((Object)("result: " + duration));
        return duration;
    }

    private static String parseOutput(String output) throws IOException {
        Pattern pattern = Pattern.compile("Duration: ");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            return output.substring(matcher.end(), matcher.end() + 8);
        }
        throw new IOException("ffprobe output does not contain Duration.");
    }

    public static String getDurationInSeconds(String filepath) throws IOException {
        String[] lines;
        String duration = "NOT-YET-SET";
        logger.debug((Object)("filepath: " + filepath));
        String command = "/opt/tandbergtv/tools/bin/ffprobe -show_format " + filepath;
        logger.debug((Object)("command: " + command));
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader input_br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader error_br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        String s = "";
        while ((s = input_br.readLine()) != null) {
            sb.append(s).append("\n");
        }
        while ((s = error_br.readLine()) != null) {
            sb.append(s).append("\n");
        }
        String output = sb.toString();
        logger.debug((Object)("output: " + output));
        String MATCH = "duration=";
        for (String line : lines = output.split("\n|\r\n")) {
            if (!(line = line.trim()).startsWith(MATCH)) continue;
            duration = line.substring(MATCH.length());
            break;
        }
        logger.debug((Object)("result: " + duration));
        return duration;
    }
}

