/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class GnuPG {
    private static final Logger logger = Logger.getLogger(GnuPG.class);
    private static final String GPG_CMD = "/usr/bin/gpg";
    public static final String SUCCESS = "Success";
    public static final String FAILURE = "Failure";
    public static int gpg_exitCode = -1;
    public static String gpg_result = "Failure";
    public static StringBuilder gpg_err = null;

    public static boolean encrypt(String sourcePath, String encryptedPath, String gpgRecipient) throws Exception {
        boolean status;
        block6: {
            logger.debug((Object)("sourcePath: " + sourcePath));
            logger.debug((Object)("encryptedPath: " + encryptedPath));
            logger.debug((Object)("profile: " + gpgRecipient));
            status = false;
            try {
                File inStrFile = new File(sourcePath);
                if (inStrFile.exists()) {
                    File outStrfile = new File(encryptedPath);
                    File outStrDir = outStrfile.getParentFile();
                    if (outStrfile.exists()) {
                        logger.error((Object)("The encrytped file already exists: " + encryptedPath));
                        throw new Exception("The encrytped file already exists: " + encryptedPath);
                    }
                    if (outStrDir.exists()) {
                        status = GnuPG.runGnuPG("/usr/bin/gpg --no-tty --out " + outStrfile.getAbsolutePath() + " --recipient " + gpgRecipient + " --armor --encrypt " + sourcePath);
                        if (status && gpg_exitCode == 0) {
                            status = true;
                        }
                        break block6;
                    }
                    logger.error((Object)("The destination dir doesnt exist: " + encryptedPath));
                    throw new Exception("The destination dir doesnt exist: " + encryptedPath);
                }
                logger.error((Object)("The source file doesnt exist: " + sourcePath));
                throw new Exception("The source file doesnt exist: " + sourcePath);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new Exception(e.getMessage());
            }
        }
        return status;
    }

    public static boolean encryptOld(String sourcePath, String encryptedPath, String gpgRecipient) throws Exception {
        boolean status;
        block6: {
            logger.debug((Object)("sourcePath: " + sourcePath));
            logger.debug((Object)("encryptedPath: " + encryptedPath));
            logger.debug((Object)("profile: " + gpgRecipient));
            status = false;
            try {
                File inStrFile = new File(sourcePath);
                if (inStrFile.exists()) {
                    File outStrDir = new File(encryptedPath);
                    if (outStrDir.isDirectory()) {
                        File outStrfile = new File(encryptedPath + inStrFile.getName() + ".enc");
                        if (outStrfile.exists()) {
                            logger.error((Object)("The encrytped file already exists: " + encryptedPath));
                            throw new Exception("The encrytped file already exists: " + encryptedPath);
                        }
                        status = GnuPG.runGnuPG("/usr/bin/gpg --no-tty --out " + outStrfile.getAbsolutePath() + " --recipient " + gpgRecipient + " --armor --encrypt " + sourcePath);
                        if (status && gpg_exitCode == 0) {
                            status = true;
                        }
                        break block6;
                    }
                    logger.error((Object)("The destination dir doesnt exist: " + encryptedPath));
                    throw new Exception("The destination dir doesnt exist: " + encryptedPath);
                }
                logger.error((Object)("The source file doesnt exist: " + sourcePath));
                throw new Exception("The source file doesnt exist: " + sourcePath);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new Exception(e.getMessage());
            }
        }
        return status;
    }

    public static boolean decrypt(String encryptedPath, String destPath, String gpgPwdFile) throws Exception {
        boolean status;
        block6: {
            status = false;
            logger.debug((Object)("encryptedPath: " + encryptedPath));
            logger.debug((Object)("destPath: " + destPath));
            logger.debug((Object)("passwdPath: " + gpgPwdFile));
            try {
                File inStrFile = new File(encryptedPath);
                if (inStrFile.exists()) {
                    String tmpOutStr = destPath;
                    if (tmpOutStr == null || "".equals(tmpOutStr)) {
                        logger.error((Object)"Processing error occured while getting the output file name");
                        throw new Exception("Processing error occured while geting the output file name");
                    }
                    File outStrfile = new File(destPath);
                    if (outStrfile.exists()) {
                        logger.error((Object)("The decrytped file already exists: " + destPath));
                        throw new Exception("The decrytped file already exists: " + destPath);
                    }
                    status = GnuPG.runGnuPG("/usr/bin/gpg --no-tty --no-use-agent --passphrase-file " + gpgPwdFile + " -d -o " + destPath + " " + encryptedPath);
                    if (status && gpg_exitCode == 0) {
                        status = true;
                    }
                    break block6;
                }
                logger.error((Object)("The source file doesnt exist: " + encryptedPath));
                throw new Exception("The source file doesnt exist: " + encryptedPath);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new Exception(e.getMessage());
            }
        }
        return status;
    }

    private static boolean runGnuPG(String commandArgs) throws Exception {
        logger.debug((Object)("GPG command: " + commandArgs));
        boolean status = false;
        StringBuilder errorString = new StringBuilder();
        try {
            String s;
            logger.debug((Object)"about to execute the process.....");
            Process p = Runtime.getRuntime().exec(commandArgs);
            logger.debug((Object)"process executed.......");
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            logger.debug((Object)"standard output of the command:");
            while ((s = stdInput.readLine()) != null) {
                logger.debug((Object)s);
            }
            logger.debug((Object)"Here is the standard error/warning of the command (if any):");
            while ((s = stdError.readLine()) != null) {
                logger.debug((Object)s);
                errorString.append(s);
            }
            gpg_err = errorString;
            p.waitFor();
            gpg_exitCode = p.exitValue();
            logger.debug((Object)("exit value of the process: " + gpg_exitCode));
            if (gpg_exitCode != 0) {
                throw new Exception(errorString.toString());
            }
            gpg_result = SUCCESS;
            status = true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception(e.getMessage());
        }
        return status;
    }
}

