/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class Tar {
    private static final Logger logger = Logger.getLogger(Tar.class);
    private static final String CMD_TAR = "/bin/tar";
    public static final String SUCCESS = "Success";
    public static final String FAILURE = "Failure";
    public static int tar_exitCode = -1;
    public static String tar_result = "Failure";
    public static StringBuilder tar_err = null;

    public static boolean archive(String sourceDirPath, String archiveFilePath) throws Exception {
        File srcPathDir;
        logger.debug((Object)("sourceDirPath: " + sourceDirPath));
        logger.debug((Object)("archiveFilePath: " + archiveFilePath));
        boolean status = false;
        if (!sourceDirPath.endsWith("/")) {
            sourceDirPath = sourceDirPath + "/";
        }
        if ((srcPathDir = new File(sourceDirPath)).isDirectory()) {
            String command = "/bin/tar -C " + sourceDirPath + " -cvf " + archiveFilePath + " .";
            status = Tar.runTar(command);
            if (status && tar_exitCode == 0) {
                status = true;
            }
        } else {
            logger.error((Object)("The source dir doesnt exist:" + sourceDirPath));
            throw new Exception("The source dir doesnt exist: :" + sourceDirPath);
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean unarchive(String archiveFilePath, String destDirPath) throws Exception {
        logger.debug((Object)("archiveFilePath: " + archiveFilePath));
        logger.debug((Object)("destDirPath: " + destDirPath));
        boolean status = false;
        File tarFile = new File(archiveFilePath);
        File dirPath = new File(destDirPath);
        if (tarFile.exists()) {
            if (dirPath.isDirectory()) {
                String command = "/bin/tar -C " + destDirPath + " -xvf " + archiveFilePath;
                status = Tar.runTar(command);
                if (!status) return status;
                if (tar_exitCode != 0) return status;
                return true;
            }
            logger.error((Object)("The destination dir doesnt exist: " + destDirPath));
            throw new Exception("The destination dir doesnt exist: " + destDirPath);
        }
        logger.error((Object)("The tar file doesnt exist: " + archiveFilePath));
        throw new Exception("The tar file doesnt exist: " + archiveFilePath);
    }

    public static boolean runTar(String commandArgs) throws Exception {
        boolean status = false;
        StringBuilder errorString = new StringBuilder();
        logger.debug((Object)("TAR command:" + commandArgs));
        try {
            String s;
            Process p = Runtime.getRuntime().exec(commandArgs);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            logger.debug((Object)"standard output of the command:");
            while ((s = stdInput.readLine()) != null) {
                logger.debug((Object)s);
            }
            logger.debug((Object)"Here is the standard error/warning of the command (if any):");
            while ((s = stdError.readLine()) != null) {
                logger.debug((Object)s);
                errorString.append(s);
            }
            tar_err = errorString;
            p.waitFor();
            tar_exitCode = p.exitValue();
            logger.debug((Object)("exit value of the process::" + tar_exitCode));
            if (tar_exitCode != 0) {
                logger.error((Object)errorString.toString());
                throw new Exception(errorString.toString());
            }
            tar_result = SUCCESS;
            status = true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception(e.getMessage());
        }
        return status;
    }
}

