/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.wfs;

import com.ericsson.scac.cms.wfs.DebugExecContext;
import java.util.Random;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class BaseActionHandler
implements ActionHandler {
    private static final long serialVersionUID = -7711517770971061037L;
    protected static final Logger log = Logger.getLogger(BaseActionHandler.class);
    public static final String CTX_RESTART_WORKORDER = "Suspended";
    public static final String UNSET = "-";
    public static final String COMPLETE = "COMPLETE";
    public static final String GLOBAL_SUCCESS = "success";
    public static final String GLOBAL_ERROR_MESSAGE = "error-message";
    public static final String CTX_SOURCE_PATH = "SourcePath";
    public static final String CTX_DEST_PATH = "DestinationPath";
    public static final String CTX_CHECKSUM = "checksum";
    public static final String CTX_PATH = "path";
    public static final boolean STRICT = true;
    private String nameSpace = null;

    public String getProperty(ExecutionContext context, String key) {
        return this.getProperty(context, key, false);
    }

    public String getProperty(ExecutionContext context, String key, boolean strict) {
        log.debug((Object)("GET PROPERTY" + (strict ? "(strict)" : "") + "->" + key));
        Object value = context.getVariable(key);
        if ((value == null || "".equals(value) || UNSET.equals(value)) && strict) {
            throw new RuntimeException("REQUIRED VAR NOT FOUND IN CONTEXT!   KEY->" + key);
        }
        log.debug((Object)("    [" + key + "] -->>  [" + value + "]"));
        return value == null || "".equals(value) || UNSET.equals(value) ? "" : "" + value;
    }

    public boolean getBoolean(ExecutionContext context, String key) {
        Object obj = context.getVariable(key);
        return false;
    }

    public void setProperty(ExecutionContext context, String key, String value) {
        log.debug((Object)("SET PROPERTY \n > " + key + (value != null && value.length() > 25 ? "\n" : " >> ") + value));
        context.setVariable(key, (Object)value);
    }

    public void errorMessage(ExecutionContext context, String message) {
        log.debug((Object)("APPENDING MESSAGE->" + message));
        String msgs = null;
        String value = this.getProperty(context, GLOBAL_ERROR_MESSAGE);
        if (msgs == null || UNSET.equals(msgs) || "".equals(msgs)) {
            msgs = "- " + message;
        } else {
            msgs.concat(msgs + "/n- " + message);
        }
        context.setVariable(GLOBAL_ERROR_MESSAGE, (Object)value);
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getWorkOrderId(ExecutionContext context) {
        if (context instanceof DebugExecContext) {
            return "" + new Random().nextInt(100000000);
        }
        return "" + context.getProcessInstance().getId();
    }

    public static void main(String[] args) {
    }
}

