/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.wfs;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public final class Messages {
    private static final Logger log = Logger.getLogger(Messages.class);
    public static final Properties messages = new Properties();

    public static String getMessage(String message, ExecutionContext context) {
        if (message == null) {
            return null;
        }
        Pattern re = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher m = re.matcher(message);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            String resolved = Messages.getMessage("" + context.getVariable(variable), context);
            if (resolved == null) continue;
            m.appendReplacement(result, resolved);
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String getMessage(String messageKey, ExecutionContext context, boolean suppressError) throws Exception {
        if (messages.containsKey(messageKey)) {
            return Messages.getMessage(messages.getProperty(messageKey), context);
        }
        if (!suppressError) {
            throw new Exception("No message found for key=>'" + messageKey + "'");
        }
        return "No message found for key=>'" + messageKey + "'";
    }

    public static void load(String configPath) throws Exception {
        try {
            messages.loadFromXML(new FileInputStream(configPath));
            messages.list(System.out);
        }
        catch (Exception e) {
            String errMsg = "RUNTIME ERROR - Could not load '" + configPath + "' file!";
            log.error((Object)errMsg, (Throwable)e);
            throw new Exception(errMsg, e);
        }
    }

    private Messages() {
    }
}

