/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.scac.cms.workflow.utils;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AssetFileInfo
implements Serializable {
    private static final Logger logger = Logger.getLogger(AssetFileInfo.class);
    private static final long serialVersionUID = 7784898387573303569L;
    private static final String DFLT_EMPTY = "EMPTY";
    private static final String DFLT_NULL = "NULL";
    private static final List<String> INVALIDATING_VALUES_LIST = new ArrayList<String>();
    private static final String COLUMN_DELIMITER = "|";
    private static final String COLUMN_DELIMITER_ESCAPED = "\\|";
    private static final String ROW_DELIMITER = "\n";
    private String assetType = null;
    private String assetId = null;
    private String lookupKey = null;
    private String filepath = null;
    private String filetype = null;
    private long filesize = 0L;
    private String checksum = null;
    private String publicAssetIdentifier = null;

    public String getAssetType() {
        return AssetFileInfo.nullSafe(this.assetType);
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public String getAssetId() {
        return AssetFileInfo.nullSafe(this.assetId);
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getLookupKey() {
        return AssetFileInfo.nullSafe(this.lookupKey);
    }

    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    public String getFilepath() {
        return AssetFileInfo.nullSafe(this.filepath);
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public String getFiletype() {
        return AssetFileInfo.nullSafe(this.filetype);
    }

    public void setFiletype(String filetype) {
        this.filetype = filetype;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public void setFilesize(String filesizeStr) throws Exception {
        long n;
        this.filesize = n = Long.parseLong(filesizeStr);
    }

    public String getChecksum() {
        return AssetFileInfo.nullSafe(this.checksum);
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getPublicAssetIdentifier() {
        return AssetFileInfo.nullSafe(this.publicAssetIdentifier);
    }

    public void setPublicAssetIdentifier(String id) {
        this.publicAssetIdentifier = id;
    }

    public boolean isRegisterable() {
        boolean b = true;
        if (INVALIDATING_VALUES_LIST.contains(this.getLookupKey())) {
            b = false;
        }
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AssetFileInfo [").append("assetType: ").append(this.assetType).append(", assetId: ").append(this.assetId).append(", publicId: ").append(this.publicAssetIdentifier).append(", lookupKey: ").append(this.lookupKey).append(", filetype: ").append(this.filetype).append(", filesize: ").append(this.filesize).append(", checksum: ").append(this.checksum).append(", filepath: ").append(this.filepath).append("]");
        return sb.toString();
    }

    private static String nullSafe(String s) {
        String ret = s;
        if ("".equals(ret)) {
            ret = DFLT_EMPTY;
        } else if (ret == null) {
            ret = DFLT_NULL;
        }
        return ret;
    }

    public static synchronized void writeObject(String filePath, List<AssetFileInfo> list) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filePath));
        oos.writeObject(list);
        oos.close();
    }

    public static synchronized List<AssetFileInfo> readObject(String filePath) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filePath));
        Object obj = ois.readObject();
        ois.close();
        List list = (List)obj;
        return list;
    }

    public static synchronized void writeText(String filePath, List<AssetFileInfo> list) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (AssetFileInfo afi : list) {
            sb.append(afi.getAssetType()).append(COLUMN_DELIMITER).append(afi.getAssetId()).append(COLUMN_DELIMITER).append(afi.getLookupKey()).append(COLUMN_DELIMITER).append(afi.getFilepath()).append(COLUMN_DELIMITER).append(afi.getFilesize()).append(COLUMN_DELIMITER).append(afi.getFiletype()).append(COLUMN_DELIMITER).append(afi.getChecksum()).append(COLUMN_DELIMITER).append(afi.getPublicAssetIdentifier()).append(ROW_DELIMITER);
        }
        String data = sb.toString();
        File outputFile = new File(filePath);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FileWriter fw = new FileWriter(outputFile, false);
        BufferedWriter buf = new BufferedWriter(fw);
        buf.write(data);
        buf.close();
    }

    public static synchronized List<AssetFileInfo> readText(String filePath) throws Exception {
        String[] lines;
        ArrayList<AssetFileInfo> list = new ArrayList<AssetFileInfo>();
        String data = null;
        File f = new File(filePath);
        byte[] rawData = AssetFileInfo.read(f);
        if (rawData != null) {
            data = new String(rawData);
        } else {
            logger.error((Object)"Null data returned");
        }
        for (String s : lines = data.split(ROW_DELIMITER)) {
            String[] columns = s.split(COLUMN_DELIMITER_ESCAPED);
            AssetFileInfo afi = new AssetFileInfo();
            afi.setAssetType(columns[0]);
            afi.setAssetId(columns[1]);
            afi.setLookupKey(columns[2]);
            afi.setFilepath(columns[3]);
            afi.setFilesize(columns[4]);
            afi.setFiletype(columns[5]);
            afi.setChecksum(columns[6]);
            afi.setPublicAssetIdentifier(columns[7]);
            list.add(afi);
        }
        return list;
    }

    private static synchronized byte[] read(File f) throws IOException {
        byte[] data = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        long len = f.length();
        int lenInt = (int)len;
        data = new byte[lenInt];
        bis.read(data, 0, lenInt);
        bis.close();
        return data;
    }

    static {
        INVALIDATING_VALUES_LIST.add(DFLT_EMPTY);
        INVALIDATING_VALUES_LIST.add(DFLT_NULL);
    }
}

